/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.filter.logicProcessor;

import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.filter.logicProcessor.AbstractIDSCmdProcessor;
import com.trs.idm.client.filter.logicProcessor.ProcessorUtil;
import com.trs.idm.interact.agent.IAgent;
import com.trs.idm.util.Base64Util;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DelUserProcessor
extends AbstractIDSCmdProcessor {
    private static final Logger LOG = Logger.getLogger(DelUserProcessor.class);
    private IAgent agent;
    private final String idsCmd = "delUser";

    public DelUserProcessor(IAgent agent) {
        this.agent = agent;
    }

    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean opResult;
        String userNameBase64 = req.getHeader("userName");
        String encoding = req.getHeader("encoding");
        String userName = Base64Util.decode((String)userNameBase64, (String)encoding);
        LOG.info((Object)("get del user http request, userNameBase64:" + userNameBase64 + ", decode userName by headerEncoding:" + userName + ", decode userName by UTF-8:" + Base64Util.decode((String)userNameBase64, (String)"UTF-8") + ", decode username by GBK:" + Base64Util.decode((String)userNameBase64, (String)"GBK")));
        String sourceName = ProcessorUtil.getSourceNameFromRequestHeader(req);
        Properties props = new Properties();
        try {
            props.put("userName", userName);
            props.put("sourceName", sourceName);
        }
        catch (Exception e) {
            LOG.error((Object)("Put userName[" + userName + "] and sourceName[" + sourceName + "] to properties fail! "), (Throwable)e);
        }
        SSOUser ssoUser = new SSOUser(props);
        try {
            opResult = this.agent.getServletAppActorV2().removeUser(req, resp, ssoUser);
        }
        catch (Throwable t) {
            LOG.error((Object)"[ActorErr]removeUser fail!", t);
            resp.sendError(500, "[ActorErr]removeUser() fail! err=" + t);
            return;
        }
        if (resp.isCommitted()) {
            return;
        }
        if (opResult) {
            resp.getOutputStream().print(String.valueOf(this.agent.getAgentName()) + "delUser");
        } else {
            resp.sendError(500, "[ActorErr]removeUser() return false!");
        }
    }

    public String getIDSCmd() {
        return "delUser";
    }
}

