/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.Base64;
import com.trs.idm.util.StringHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class Base64Util {
    private static final String ENCODING = "ISO8859-1";
    public static final String BASE64_HEADER = "(BASE64)";

    public static String decode(String dest) {
        if (dest == null) {
            return "";
        }
        return new String(Base64.decodeBase64(dest.getBytes()));
    }

    public static byte[] decodeBytes(String dest) {
        if (dest == null) {
            return null;
        }
        return Base64.decodeBase64(dest.getBytes());
    }

    public static String decode(byte[] encoded) {
        return new String(Base64.decodeBase64(encoded));
    }

    public static String encode(String origin) {
        if (origin == null) {
            return "";
        }
        return new String(Base64.encodeBase64(origin.getBytes()));
    }

    public static String encode(String origin, String charsetName) {
        if (origin == null) {
            return "";
        }
        String base64Str = "";
        try {
            base64Str = new String(Base64.encodeBase64(origin.getBytes(charsetName)));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return base64Str;
    }

    public static String decode(String base64Str, String charsetName) {
        if (StringHelper.isEmpty(base64Str)) {
            return "";
        }
        if (StringHelper.isEmpty(charsetName)) {
            return Base64Util.decode(base64Str);
        }
        String originStr = "";
        try {
            originStr = new String(Base64.decodeBase64(base64Str.getBytes(ENCODING)), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return originStr;
    }

    static InputStream encode(InputStream inputStream) {
        try {
            int bytesToRead = inputStream.available();
            byte[] input = new byte[bytesToRead];
            int bytesRead = 0;
            while (bytesRead < bytesToRead) {
                int actualRead = inputStream.read(input, bytesRead, bytesToRead - bytesRead);
                if (actualRead == -1) break;
                bytesRead += actualRead;
            }
            String encodeBytes = Base64Util.encode(input);
            return new ByteArrayInputStream(encodeBytes.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ByteArrayInputStream("".getBytes());
        }
    }

    public static String encode(byte[] data) {
        if (data == null) {
            return "";
        }
        return new String(Base64.encodeBase64(data));
    }

    public static byte[] encodeBase64(byte[] binaryData, boolean isChunked) {
        return Base64.encodeBase64(binaryData, isChunked);
    }

    public static byte[] decodeBase64(byte[] base64Data) {
        return Base64.decodeBase64(base64Data);
    }

    public static boolean isBase64Encoded(String strEncoded, String charsetName) {
        byte[] base64Data;
        if (strEncoded == null || strEncoded.length() == 0) {
            return false;
        }
        if (strEncoded.length() % 4 != 0) {
            return false;
        }
        if (!StringHelper.isEmpty(charsetName)) {
            try {
                base64Data = strEncoded.getBytes(charsetName);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                base64Data = strEncoded.getBytes();
            }
        } else {
            base64Data = strEncoded.getBytes();
        }
        if (!Base64.isArrayByteBase64(base64Data)) {
            return false;
        }
        try {
            return strEncoded.equals(Base64Util.encode(Base64Util.decode(strEncoded)));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isBase64Encoded(String strEncoded) {
        return Base64Util.isBase64Encoded(strEncoded, "");
    }
}

