/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.generator.impl;

import com.trs.idm.saml.generator.ITokenGenerator;
import com.trs.idm.util.Base64Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.log4j.Logger;

public class SimpleGenerator
implements ITokenGenerator {
    private static final Logger LOG = Logger.getLogger(SimpleGenerator.class);
    private int defaultFlagLength = 8;
    private Random random = null;
    private String entropy = null;
    private String randomClass = "java.security.SecureRandom";
    private MessageDigest digest = null;
    private String algorithm = "MD5";
    private static final String DEFAULT_ALGORITHM = "MD5";

    public String generateToken() {
        return new Long(System.currentTimeMillis()).toString();
    }

    public String generateEncryToken(String originToken) {
        return Base64Util.encode(originToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateRandomFlag(int flagLength) {
        if (flagLength == 0) {
            flagLength = this.defaultFlagLength;
        }
        byte[] random = new byte[flagLength];
        StringBuffer result = new StringBuffer();
        int resultLenBytes = 0;
        SimpleGenerator simpleGenerator = this;
        synchronized (simpleGenerator) {
            while (resultLenBytes < flagLength) {
                this.getRandomBytes(random);
                random = this.getDigest().digest(random);
                int j = 0;
                while (j < random.length && resultLenBytes < flagLength) {
                    byte b1 = (byte)((random[j] & 0xF0) >> 4);
                    byte b2 = (byte)(random[j] & 0xF);
                    if (b1 < 10) {
                        result.append((char)(48 + b1));
                    } else {
                        result.append((char)(65 + (b1 - 10)));
                    }
                    if (b2 < 10) {
                        result.append((char)(48 + b2));
                    } else {
                        result.append((char)(65 + (b2 - 10)));
                    }
                    ++resultLenBytes;
                    ++j;
                }
            }
        }
        return result.toString();
    }

    private void getRandomBytes(byte[] bytes) {
        this.getRandom();
        this.getRandom().nextBytes(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Random getRandom() {
        if (this.random == null) {
            SimpleGenerator simpleGenerator = this;
            synchronized (simpleGenerator) {
                if (this.random == null) {
                    long seed;
                    long t1 = seed = System.currentTimeMillis();
                    char[] entropy = this.getEntropy().toCharArray();
                    int i = 0;
                    while (i < entropy.length) {
                        long update = (byte)entropy[i] << i % 8 * 8;
                        seed ^= update;
                        ++i;
                    }
                    try {
                        Class<?> clazz = Class.forName(this.randomClass);
                        this.random = (Random)clazz.newInstance();
                        this.random.setSeed(seed);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("SSOSessionManager.random: " + this.randomClass), (Throwable)e);
                        this.random = new Random();
                        this.random.setSeed(seed);
                    }
                    long t2 = System.currentTimeMillis();
                    if (t2 - t1 > 100L) {
                        LOG.debug((Object)("SSOSessionIdGen.seeding time high! " + this.randomClass + " " + (t2 - t1)));
                    }
                }
            }
        }
        return this.random;
    }

    private synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            long t1 = System.currentTimeMillis();
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error((Object)("SSOSessionManager.digest:     " + this.algorithm + "   " + e));
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    LOG.error((Object)("SSOSessionManager.digest:   MD5   " + e));
                    this.digest = null;
                }
            }
            long t2 = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getDigest(): " + (t2 - t1)));
            }
        }
        return this.digest;
    }

    private String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    private void setEntropy(String entropy) {
        this.entropy = entropy;
    }
}

