/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.protocol;

import com.trs.idm.interact.protocol.PacketUtil;
import com.trs.idm.interact.protocol.ProtocolPacket;
import com.trs.idm.util.StringHelper;
import org.apache.log4j.Logger;

public class ResponsePacket
extends ProtocolPacket {
    private byte errCode;
    private static final Logger logger = Logger.getLogger(ResponsePacket.class);

    public byte getErrCode() {
        return this.errCode;
    }

    public ResponsePacket(byte errcode, String[] body) {
        boolean PROTOCOL_MAJ_OLD_VER = true;
        this.buildResponsePacket(errcode, body, (byte)1, null);
    }

    public ResponsePacket(byte errcode, String[] body, byte majorVersion, String idmServerCharset) {
        this.buildResponsePacket(errcode, body, majorVersion, idmServerCharset);
    }

    private void buildResponsePacket(byte errcode, String[] body, byte majorVersion, String idmServerCharset) {
        this.errCode = errcode;
        this.bodyLength = PacketUtil.caculateBodyLength(body, majorVersion, idmServerCharset);
        if (this.bodyLength > 0) {
            this.bodyStrs = body;
            this.bodyDatas = PacketUtil.stringArray2PacketBodyBytes(body, this.bodyLength, majorVersion, idmServerCharset);
        }
    }

    public ResponsePacket(byte errcode, byte[] body, byte processCmd) {
        this.errCode = errcode;
        short s = this.bodyLength = body == null ? (short)0 : (short)body.length;
        if (this.bodyLength > 0) {
            this.bodyDatas = body;
            this.bodyStrs = PacketUtil.packetBodyBytes2StringArray(body);
        }
        this.setProcessCommand(processCmd);
    }

    public ResponsePacket(byte errcode, byte[] body, byte processCmd, byte majorVersion) {
        this.errCode = errcode;
        short s = this.bodyLength = body == null ? (short)0 : (short)body.length;
        if (this.bodyLength > 0) {
            this.bodyDatas = body;
            this.bodyStrs = PacketUtil.packetBodyBytes2StringArray(body, majorVersion, null);
            this.setMajorVersion(majorVersion);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("new ResponsePacket by errCode[" + this.errCode + "], bodyLength[" + this.bodyLength + "], bodyDatas[" + this.bodyDatas + "], bodyStrs[" + this.bodyStrs + "]"));
        }
        this.setProcessCommand(processCmd);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(super.toString());
        sb.append(" cmd=").append(this.processCmd);
        sb.append(";rsCode=").append(this.errCode);
        sb.append(";bodyLen=").append(this.bodyLength);
        sb.append(". body:  ").append(StringHelper.toString(this.bodyStrs, true, "; "));
        return sb.toString();
    }

    public byte getPacketType() {
        return 1;
    }

    public void setErrCode(byte b) {
        this.errCode = b;
    }

    public byte[] toBytes() {
        byte[] head = PacketUtil.responseHead2Bytes(this.bodyLength, this.packetId, this.errCode, this.processCmd);
        byte[] pack = new byte[16 + this.bodyLength];
        System.arraycopy(head, 0, pack, 0, 16);
        if (this.bodyDatas != null) {
            System.arraycopy(this.bodyDatas, 0, pack, 16, this.bodyLength);
        }
        return pack;
    }

    public void setProcessCommand(byte cmd) {
        this.processCmd = cmd;
    }

    public byte getProcessCommand() {
        return this.processCmd;
    }
}

