/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent.service;

import com.trs.idm.client.IWebCoAppActor;
import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.actor.v2.IServletAppActorV2;
import com.trs.idm.exception.IdMException;
import com.trs.idm.interact.agent.Agent;
import com.trs.idm.interact.agent.AgentFactory;
import com.trs.idm.interact.agent.IAgent;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AgentServiceForPortal {
    private static boolean agentFactoryExists = AgentServiceForPortal.isAgentFactoryClassExists();
    private static AgentServiceForPortal wrapper = new AgentServiceForPortal();
    private IAgent agent = null;
    private IServletAppActorV2 appActor = null;
    private Agent oldAgent = null;
    private IWebCoAppActor oldActor = null;

    AgentServiceForPortal() {
        if (agentFactoryExists) {
            this.agent = AgentFactory.getInstance();
            this.agent.start();
            this.appActor = this.agent.getServletAppActorV2();
        } else {
            this.oldAgent = Agent.getSingleton();
            this.oldActor = this.oldAgent.getWebAppActor();
        }
    }

    public boolean checkLocalLogin(HttpServletRequest request, HttpServletResponse response) {
        if (agentFactoryExists) {
            return this.appActor.checkLocalLogin(request, response);
        }
        return this.oldActor.checkLocalLogin(request.getSession()) || this.oldActor.canPass(request);
    }

    public String findSSOID(String sessionId) throws IdMException, IOException {
        if (agentFactoryExists) {
            return this.agent.findSSOID(sessionId);
        }
        return this.oldAgent.findSSOID(sessionId);
    }

    public Properties findUserBySSOSessionId(String ssoSessId, String coSessId, String clientIp) throws IdMException, IOException {
        if (agentFactoryExists) {
            return this.agent.findUserBySSOSessionId(ssoSessId, coSessId, clientIp);
        }
        return this.oldAgent.findUserBySSOSessionId(ssoSessId, coSessId, clientIp);
    }

    public void loadUserInfoToSession(Properties userProps, HttpServletRequest request, HttpServletResponse response) {
        if (agentFactoryExists) {
            SSOUser user = new SSOUser(userProps);
            this.appActor.loadLoginUser(request, response, user);
        } else {
            HttpSession session = request.getSession();
            this.oldActor.loadUserInfoToSession(userProps, session, request);
        }
    }

    public String findProxyUserNameAndPwd(String agentName, String userName, String sourceName) throws IdMException, IOException {
        return this.agent.findProxyUserNameAndPwd(agentName, userName, sourceName);
    }

    public static AgentServiceForPortal getWrapperInstance() {
        return wrapper;
    }

    private static boolean isAgentFactoryClassExists() {
        try {
            Class.forName("com.trs.idm.interact.agent.AgentFactory");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

