/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.actor;

import com.trs.idm.client.actor.ActorException;
import com.trs.idm.client.actor.FormValues;
import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.actor.StdHttpSessionBasedActor;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class DemoAppActor
extends StdHttpSessionBasedActor {
    private static final Logger LOG = Logger.getLogger(DemoAppActor.class);
    private static final String LOGIN_FLAG = "loginUser";

    public boolean checkLocalLogin(HttpSession session) throws ActorException {
        try {
            return session.getAttribute(LOGIN_FLAG) != null;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public void loadLoginUser(HttpServletRequest request, SSOUser user) throws ActorException {
        HttpSession session = request.getSession();
        session.setAttribute(LOGIN_FLAG, (Object)user.getUserName());
        Set names = user.propertyNames();
        for (String name : names) {
            System.out.println("name: " + name);
            System.out.println("value: " + user.getProperty(name));
        }
        LOG.info((Object)("loadLoginUser, user groups info:" + user.getSSOGroups()));
    }

    public void logout(HttpSession session) throws ActorException {
        try {
            session.invalidate();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean addUser(SSOUser user, HttpServletRequest request) throws ActorException {
        LOG.info((Object)("coApp add user, user:" + user + ",\n\r, ssoGroup:" + user.getSSOGroup()));
        Set names = user.propertyNames();
        for (String name : names) {
            System.out.println("name: " + name);
            System.out.println("value: " + user.getProperty(name));
        }
        List userGroups = this.listUserGroupInfo(user);
        System.out.println("user group [" + userGroups + "] .");
        return true;
    }

    public boolean disableUser(SSOUser user) throws ActorException {
        LOG.info((Object)("DemoAppActor disableUser, user:" + user + ", userName:" + user.getUserName()));
        return true;
    }

    public boolean enableUser(SSOUser user) throws ActorException {
        LOG.info((Object)("DemoAppActor enableUser, user:" + user + ", userName:" + user.getUserName()));
        return true;
    }

    public String extractUserName(HttpServletRequest request) throws ActorException {
        String result = request.getParameter("userName");
        return result == null ? "" : result;
    }

    public String extractUserPwd(HttpServletRequest request) throws ActorException {
        String result = request.getParameter("password");
        return result == null ? "" : result;
    }

    public FormValues extractExtraInput(HttpServletRequest request) throws ActorException {
        String sourceName = request.getParameter("sourceName");
        String isAutoLogin = request.getParameter("isAutoLogin");
        String TRSIDSVerifyCode = request.getParameter("TRSIDSVerifyCode");
        FormValues values = new FormValues();
        values.put("sourceName", sourceName);
        values.put("TRSIDSVerifyCode", TRSIDSVerifyCode);
        values.put("isAutoLogin", isAutoLogin);
        LOG.info((Object)("extract extra login info, request = " + values.toString()));
        return values;
    }

    public boolean removeUser(SSOUser user, HttpServletRequest request) throws ActorException {
        LOG.info((Object)("coapp remove user,user:" + user));
        Set names = user.propertyNames();
        for (String name : names) {
            System.out.println("name: " + name);
            System.out.println("value: " + user.getProperty(name));
        }
        return true;
    }

    public boolean updateUser(SSOUser user, HttpServletRequest request) throws ActorException {
        LOG.info((Object)("coapp update user,user:" + user + ",\n\r, ssoGroup:" + user.getSSOGroup()));
        Set names = user.propertyNames();
        for (String name : names) {
            System.out.println("name: " + name);
            System.out.println("value: " + user.getProperty(name));
        }
        List userGroups = this.listUserGroupInfo(user);
        System.out.println("user group [" + userGroups + "] .");
        return true;
    }

    public boolean userExist(SSOUser user) throws ActorException {
        return true;
    }

    public boolean addGroup(SSOGroup group, HttpServletRequest req) {
        LOG.info((Object)("add group, group:" + group));
        Set names = group.propertyNames();
        for (String name : names) {
            System.out.println("name: " + name);
            System.out.println("value: " + group.getProperty(name));
        }
        return true;
    }

    public boolean delGroup(SSOGroup group, HttpServletRequest req) {
        LOG.info((Object)("delete group:" + group));
        return true;
    }

    public boolean updateGroup(SSOGroup group, HttpServletRequest req) {
        LOG.info((Object)("update group, group:" + group));
        Set names = group.propertyNames();
        for (String name : names) {
            System.out.println("name: " + name);
            System.out.println("value: " + group.getProperty(name));
        }
        return true;
    }

    public boolean moveToGroup(SSOUser user, SSOGroup group) throws ActorException {
        LOG.info((Object)("move user:" + user + " to  group:" + group.getGroupProperty()));
        return true;
    }

    public boolean removeFromGroup(SSOUser user, SSOGroup group) throws ActorException {
        LOG.info((Object)("move user:" + user + " from group:" + group.getGroupProperty()));
        return true;
    }
}

