/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.utils.StringHelper;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class UrlUtil {
    public static String getDomainByLevel(String serverName, int tldLevel) {
        if (StringHelper.isEmpty(serverName) || serverName.indexOf(".") < 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(20);
        String[] arr = serverName.split("\\.");
        int length = arr.length;
        if (length > 0 && arr[length - 1].matches("\\b\\d+\\b")) {
            return "";
        }
        if (tldLevel >= length) {
            sb.append(serverName);
        } else {
            int j = 0;
            while (j < tldLevel) {
                sb.append(".");
                sb.append(arr[j + length - tldLevel]);
                ++j;
            }
        }
        return sb.toString();
    }

    public static String addParam(String url, String paramName, Object value) {
        if (url == null || paramName == null) {
            return url;
        }
        if (url.indexOf(63) == -1) {
            return String.valueOf(url) + '?' + paramName + '=' + value;
        }
        return String.valueOf(url) + '&' + paramName + '=' + value;
    }

    public static String replaceParamValue(String url, String paramName, Object value) {
        if (url == null || paramName == null) {
            return url;
        }
        String target = String.valueOf(paramName) + '=';
        int startPos = UrlUtil.getParamStartPos(url, paramName);
        if (startPos == -1) {
            return url;
        }
        char ch = url.charAt(startPos - 1);
        if (ch != '?' && ch != '&') {
            return url;
        }
        int endPos = url.indexOf(38, startPos);
        if (endPos == -1) {
            String remain = url.substring(0, startPos - 1);
            return UrlUtil.addParam(remain, paramName, value);
        }
        String partStart = url.substring(0, startPos);
        String partEnd = url.substring(endPos);
        return String.valueOf(partStart) + target + value + partEnd;
    }

    public static boolean paramExists(String url, String paramName) {
        return UrlUtil.getParamStartPos(url, paramName) != -1;
    }

    static int getParamStartPos(String url, String paramName) {
        String target = String.valueOf(paramName) + '=';
        int startPos = url.indexOf(target);
        if (startPos < 1) {
            return -1;
        }
        char ch = url.charAt(startPos - 1);
        if (ch != '?' && ch != '&') {
            return -1;
        }
        return startPos;
    }

    public static String addOrReplaceParam(String url, String paramName, Object value) {
        if (UrlUtil.paramExists(url, paramName)) {
            return UrlUtil.replaceParamValue(url, paramName, value);
        }
        return UrlUtil.addParam(url, paramName, value);
    }

    private UrlUtil() {
    }

    public static String encode(String str) {
        return UrlUtil.encode(str, "UTF-8");
    }

    public static String decode(String str) {
        return UrlUtil.decode(str, "UTF-8");
    }

    public static String encode(String str, String encoding) {
        try {
            return URLEncoder.encode(str, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String decode(String str, String encoding) {
        try {
            return URLDecoder.decode(str, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static boolean isFtp(URL url) {
        return "ftp".equals(url.getProtocol());
    }

    public static String getHost(URL url) {
        String authority = url.getAuthority();
        int lastIndex = authority.lastIndexOf(64);
        if (lastIndex == -1) {
            return authority;
        }
        String hostAndPort = authority.substring(lastIndex + 1);
        int posOfColon = hostAndPort.indexOf(58);
        if (posOfColon == -1) {
            return hostAndPort;
        }
        return hostAndPort.substring(0, posOfColon);
    }

    public static int getPort(URL url) {
        return url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
    }

    public static String getRemoteDir(URL url) {
        String existedPath = url.getPath();
        if (!StringHelper.isEmpty(existedPath)) {
            return existedPath;
        }
        String authority = url.getAuthority();
        String externalForm = url.toExternalForm();
        return StringHelper.substring(externalForm, authority, "?");
    }

    public static String getUserName(URL url) {
        String userInfo = url.getUserInfo();
        if (userInfo == null) {
            return null;
        }
        int index = userInfo.indexOf(58);
        if (index == -1) {
            return null;
        }
        return userInfo.substring(0, index);
    }

    public static String getPassword(URL url) {
        String authority = url.getAuthority();
        int lastAt = authority.lastIndexOf(64);
        if (lastAt == -1) {
            return null;
        }
        int colon = authority.indexOf(58);
        if (colon == -1) {
            return null;
        }
        return authority.substring(colon + 1, lastAt);
    }
}

