/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.exception.NoSuchResourceException;
import com.trs.dev4.jdk16.exception.WrappedException;
import com.trs.dev4.jdk16.utils.AssertUtil;
import com.trs.dev4.jdk16.utils.UrlUtil;
import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClassUtil {
    public static Class<? extends Object> getClassByName(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    public static String getClassName(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.getClass().getName();
    }

    public static String getSimpleName(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.getClass().getSimpleName();
    }

    public static List<Class<?>> listAllInterfaces(Class<?> clazz) {
        ArrayList list = new ArrayList();
        Class<?>[] directInterfaces = clazz.getInterfaces();
        list.addAll(Arrays.asList(directInterfaces));
        int i = 0;
        while (i < directInterfaces.length) {
            list.addAll(ClassUtil.listAllInterfaces(directInterfaces[i]));
            ++i;
        }
        return list;
    }

    public static boolean isImplementedInterface(Class<?> clazz, Class<?> interFace) {
        List<Class<?>> allInterfaces = ClassUtil.listAllInterfaces(clazz);
        return allInterfaces.contains(interFace);
    }

    public static String getSourceLocation(Object obj) {
        if (obj == null) {
            return null;
        }
        return ClassUtil.getSourceLocation(obj.getClass());
    }

    public static String getSourceLocation(Class<? extends Object> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            ProtectionDomain pd = clazz.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                return cs.getLocation().toString();
            }
            return null;
        }
        catch (RuntimeException e) {
            return e.toString();
        }
    }

    public static URL assertAndLocateResource(Class<?> clazz, String resourcePath) {
        AssertUtil.notNull(resourcePath, "the resource name is null!");
        AssertUtil.notNull(clazz, "the class object is null!");
        URL resUrl = clazz.getResource(resourcePath);
        if (resUrl == null) {
            if (resourcePath.startsWith("/")) {
                throw new NoSuchResourceException("resource [ " + resourcePath + " ] not found in [ " + clazz.getResource("/") + " ]!");
            }
            throw new NoSuchResourceException("resource [ " + resourcePath + " ] not found in [ " + clazz.getResource("/") + ClassUtil.getFSPathFormOfPackage(clazz) + " ]!");
        }
        return resUrl;
    }

    public static File assertAndLocateResourceFile(Class<?> clazz, String resourcePath) {
        URL resourceUrl = ClassUtil.assertAndLocateResource(clazz, resourcePath);
        return new File(UrlUtil.decode(resourceUrl.getFile()));
    }

    public static String getFSPathFormOfPackage(Class<?> clazz) {
        Class<?> c = clazz;
        while (c.isArray()) {
            c = c.getComponentType();
        }
        String baseName = c.getName();
        int index = baseName.lastIndexOf(46);
        if (index != -1) {
            return baseName.substring(0, index).replace('.', '/');
        }
        return baseName;
    }
}

