/*
 * Decompiled with CFR 0.152.
 */
package com.eprobiti.trs;

import com.eprobiti.trs.TRSDeviceInfo;
import com.eprobiti.trs.TRSUtils;

public final class TRSSystemInfo {
    public String ServerName;
    public long ServerID;
    public long SerialNo;
    public String OSLabel;
    public String IPAddress;
    public long CPUAmount;
    public double CPUElapsed;
    public double CPUIdled;
    public double CPULoad1;
    public double CPULoad5;
    public double CPULoad15;
    public long MemTotal;
    public long MemAvail;
    public int Charset;
    private String[] GlobalDisks;
    private String[] SystemPaths;

    TRSSystemInfo() {
    }

    private static TRSDeviceInfo[] getDeviceInfo(String[] saProperties) {
        if (saProperties == null) {
            return null;
        }
        int _iPathCount = saProperties.length;
        TRSDeviceInfo[] _oaDevices = new TRSDeviceInfo[_iPathCount];
        int i = 0;
        while (i < _iPathCount) {
            String[] _saPropertySplits = TRSUtils.split(saProperties[i], "\u0001");
            _oaDevices[i] = new TRSDeviceInfo();
            _oaDevices[i].Name = TRSUtils.getStrPropertValue(_saPropertySplits, "NAME");
            _oaDevices[i].Features = TRSUtils.getStrPropertValue(_saPropertySplits, "FEATURES");
            _oaDevices[i].TotalSize = TRSUtils.getIntPropertValue(_saPropertySplits, "TOTALSIZE");
            _oaDevices[i].AvailSize = TRSUtils.getIntPropertValue(_saPropertySplits, "AVAILSIZE");
            ++i;
        }
        return _oaDevices;
    }

    public TRSDeviceInfo[] getSystemPaths() {
        return TRSSystemInfo.getDeviceInfo(this.SystemPaths);
    }

    public TRSDeviceInfo[] getGlobalDisks() {
        return TRSSystemInfo.getDeviceInfo(this.GlobalDisks);
    }
}

