/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.util;

import EDU.oswego.cs.dl.util.concurrent.LinkedNode;
import com.trs.infra.cluster.util.AtomicInteger;
import java.util.Iterator;

public class LinkedQueue {
    protected LinkedNode head_;
    protected final Object putLock_ = new Object();
    protected LinkedNode last_;
    protected AtomicInteger size_ = new AtomicInteger(0);
    protected int waitingForTake_ = 0;

    public LinkedQueue() {
        this.last_ = this.head_ = new LinkedNode(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(Object x) {
        Object object = this.putLock_;
        synchronized (object) {
            LinkedNode p = new LinkedNode(x);
            LinkedNode linkedNode = this.last_;
            synchronized (linkedNode) {
                this.last_.next = p;
                this.last_ = p;
            }
            if (this.waitingForTake_ > 0) {
                this.putLock_.notify();
            }
        }
        this.size_.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object extract() {
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            Object x = null;
            LinkedNode first = this.head_.next;
            if (first != null) {
                x = first.value;
                first.value = null;
                this.head_ = first;
            }
            if (x != null) {
                this.size_.decrementAndGet();
            }
            return x;
        }
    }

    public void put(Object x) {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        this.insert(x);
    }

    public boolean offer(Object x, long msecs) {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        this.insert(x);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() {
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.putLock_;
        synchronized (object) {
            try {
                ++this.waitingForTake_;
                while (true) {
                    if ((x = this.extract()) != null) {
                        --this.waitingForTake_;
                        return x;
                    }
                    this.putLock_.wait();
                }
            }
            catch (InterruptedException ex) {
                --this.waitingForTake_;
                this.putLock_.notify();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            LinkedNode first = this.head_.next;
            if (first != null) {
                return first.value;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            return this.head_.next == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long msecs) {
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.putLock_;
        synchronized (object) {
            try {
                long waitTime = msecs;
                long start = msecs <= 0L ? 0L : System.currentTimeMillis();
                ++this.waitingForTake_;
                while (true) {
                    if ((x = this.extract()) != null || waitTime <= 0L) {
                        --this.waitingForTake_;
                        return x;
                    }
                    this.putLock_.wait(waitTime);
                    waitTime = msecs - (System.currentTimeMillis() - start);
                }
            }
            catch (InterruptedException ex) {
                --this.waitingForTake_;
                this.putLock_.notify();
                return null;
            }
        }
    }

    public int size() {
        return this.size_.get();
    }

    public Iterator iterator() {
        return new Iterator(){
            LinkedNode node;
            {
                this.node = LinkedQueue.this.head_.next;
            }

            public void remove() {
                throw new RuntimeException();
            }

            public Object next() {
                Object value = this.node.value;
                this.node = this.node.next;
                return value;
            }

            public boolean hasNext() {
                return this.node != null;
            }
        };
    }
}

