/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl.transport;

import com.trs.infra.cluster.Callbackable;
import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.impl.ClusterSenderBase;
import com.trs.infra.cluster.impl.transport.AddressByTCP;
import com.trs.infra.cluster.io.ByteArrayOutputStream;
import com.trs.infra.cluster.io.FilterStreamReader;
import com.trs.infra.cluster.io.FilterStreamWriter;
import com.trs.infra.cluster.io.TransportTracer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.log4j.Logger;

public class SenderByTCP
extends ClusterSenderBase {
    private static final Logger s_logger;
    private static int senderNumber;
    private Socket socket;
    private FilterStreamReader reader;
    private FilterStreamWriter writer;
    private boolean connected = false;
    private long sendBytes = 0L;
    private Member localMember;
    private Member remoteMember;
    private final byte[] headerBuffer = new byte[32];
    private TransportTracer transportTracer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.transport.SenderByTCP");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    private static synchronized int nextSenderNumber() {
        return senderNumber++;
    }

    public SenderByTCP(Member localMember, Member remoteMember) {
        super("SenderByTCP_" + SenderByTCP.nextSenderNumber());
        this.localMember = localMember;
        this.remoteMember = remoteMember;
    }

    public Member getRemoteMember() {
        return this.remoteMember;
    }

    protected void sendMessage(ClusterMessage message) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Be to send message:" + message + ",with:" + this.socket));
        }
        message.setSendTime();
        byte[] buffer = this.headerBuffer;
        message.flushHead(buffer, 0);
        if (message.isDelaySend()) {
            Callbackable callback;
            int retry = 0;
            while (retry < this.getMaxRetry()) {
                try {
                    this.insureConnect();
                    if (this.transportTracer != null) {
                        this.writer.getBypass().reset();
                    }
                    this.writer.write(buffer, 0, 32);
                    this.writer.flush();
                    if (this.transportTracer == null) break;
                    ByteArrayOutputStream bypass = this.writer.getBypass();
                    this.transportTracer.trace(bypass.getBuffer(), 0, bypass.size());
                    break;
                }
                catch (IOException e) {
                    StringBuffer sb = new StringBuffer(256);
                    sb.append("Send:").append(message);
                    sb.append(" local:").append(this.getLocalAddress());
                    sb.append(" remote:").append(this.getRemoteAddress());
                    sb.append(" failed, retry:").append(retry);
                    s_logger.error((Object)sb.toString(), (Throwable)e);
                    this.cleanup();
                }
                catch (AbortConnectException e) {
                    // empty catch block
                }
                ++retry;
            }
            if ((callback = message.getCallback()) != null) {
                callback.callBack(this.writer);
            } else {
                s_logger.error((Object)("Delay end message '" + message + "' no callback"));
            }
        } else {
            int retry = 0;
            while (retry < this.getMaxRetry()) {
                try {
                    this.insureConnect();
                    if (this.transportTracer != null) {
                        this.writer.getBypass().reset();
                    }
                    this.writer.write(buffer, 0, 32);
                    message._save(this.writer);
                    this.writer.flush();
                    if (this.transportTracer == null) break;
                    ByteArrayOutputStream bypass = this.writer.getBypass();
                    this.transportTracer.trace(bypass.getBuffer(), 0, bypass.size());
                    break;
                }
                catch (IOException e) {
                    StringBuffer sb = new StringBuffer(256);
                    sb.append("Send:").append(message);
                    sb.append(" local:").append(this.getLocalAddress());
                    sb.append(" remote:").append(this.getRemoteAddress());
                    sb.append(" failed, retry:").append(retry);
                    s_logger.error((Object)sb.toString(), (Throwable)e);
                    this.cleanup();
                }
                catch (AbortConnectException abortConnectException) {
                    // empty catch block
                }
                ++retry;
            }
        }
    }

    protected long getSendBytes() {
        if (this.writer != null) {
            return this.sendBytes + this.writer.size();
        }
        return this.sendBytes;
    }

    /*
     * Unable to fully structure code
     */
    final void insureConnect() throws AbortConnectException {
        if (!this.isConnected() || !this.isContinue()) ** GOTO lbl13
        return;
lbl-1000:
        // 1 sources

        {
            try {
                this.openConnect();
                return;
            }
            catch (IOException e) {
                SenderByTCP.s_logger.error((Object)"Reconnect failed", (Throwable)e);
                try {
                    Thread.sleep(30000L);
                    continue;
                }
                catch (InterruptedException var1_2) {
                    // empty catch block
                }
            }
lbl13:
            // 3 sources

            ** while (this.isContinue())
        }
lbl14:
        // 1 sources

        throw new AbortConnectException();
    }

    final boolean isConnected() {
        return this.connected;
    }

    void openConnect() throws IOException {
        InetAddress localHost = this.getConfig().getInetTCPListenAddress();
        InetSocketAddress localAddress = new InetSocketAddress(localHost, 0);
        InetAddress remoteHost = this.remoteMember.getTCPAddress();
        int remotePort = this.remoteMember.getTCPPort();
        InetSocketAddress remoteAddress = new InetSocketAddress(remoteHost, remotePort);
        this.socket = new Socket();
        this.socket.bind(localAddress);
        this.socket.connect(remoteAddress);
        AddressByTCP local = new AddressByTCP(this.socket.getLocalAddress(), this.socket.getLocalPort());
        this.setLocalAddress(local);
        AddressByTCP remote = new AddressByTCP(this.socket.getInetAddress(), this.socket.getPort());
        this.setRemoteAddress(remote);
        this.reader = new FilterStreamReader(this.socket.getInputStream());
        this.writer = new FilterStreamWriter(this.socket.getOutputStream());
        this.writer.write_string(this.localMember._guid());
        this.writer.flush();
        if (this.transportTracer != null) {
            this.transportTracer = this.transportTracer.initialize(this.socket, true);
        }
        if (this.transportTracer != null) {
            this.writer.setBypass(new ByteArrayOutputStream(65536));
        }
        this.connected = true;
    }

    protected void startup() {
        try {
            String path;
            if (s_logger.isDebugEnabled() && (path = this.getConfig().getTracerDirectory()) != null) {
                String file = this.getName();
                this.transportTracer = TransportTracer.newTracer(path, file);
            }
            this.openConnect();
        }
        catch (IOException e) {
            String info = "ReceiverByTCP startup failed";
            s_logger.fatal((Object)info, (Throwable)e);
            throw new RuntimeException(info, e);
        }
    }

    protected void cleanup() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                s_logger.error((Object)"Close socket input stream failed", (Throwable)e);
            }
            this.reader = null;
        }
        if (this.writer != null) {
            this.sendBytes += this.writer.size();
            try {
                this.writer.close();
            }
            catch (Exception e) {
                s_logger.error((Object)"Close socket output stream failed", (Throwable)e);
            }
            this.writer = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                s_logger.error((Object)"Close socket failed", (Throwable)e);
            }
            this.socket = null;
        }
        this.connected = false;
    }

    private static class AbortConnectException
    extends Exception {
        private static final long serialVersionUID = 8558961740396727724L;

        private AbortConnectException() {
        }
    }
}

