/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl.transport;

import com.trs.infra.cluster.impl.InetListener;
import com.trs.infra.cluster.impl.transport.AddressByUDP;
import com.trs.infra.cluster.impl.transport.DatagramPacketPool;
import com.trs.infra.cluster.impl.transport.DatagramPacketQueue;
import com.trs.infra.cluster.impl.transport.ReceiverByUDP;
import com.trs.infra.cluster.io.TransportTracer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;

public class InetListenerByUDP
extends InetListener {
    private static final Logger s_logger;
    private DatagramSocket receiveSocket;
    private DatagramPacketPool dataPacketPool;
    private DatagramPacketQueue dataPacketQueue;
    private TransportTracer transportTracer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.transport.InetListenerByUDP");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public InetListenerByUDP() {
        super("InetListenerByUDP");
    }

    protected void startup() {
        try {
            String path;
            this.dataPacketPool = new DatagramPacketPool(64, this.getConfig().getUDPBufferSize());
            this.dataPacketQueue = new DatagramPacketQueue(4096);
            int port = this.getConfig().getUDPListenPort();
            InetAddress bind = this.getConfig().getInetUDPListenAddress();
            this.receiveSocket = new DatagramSocket(new InetSocketAddress(bind, port));
            this.receiveSocket.setReceiveBufferSize(this.getConfig().getUDPBufferSize());
            AddressByUDP localAddress = new AddressByUDP(bind, port);
            int i = 0;
            while (i < this.getConfig().getUDPThreadCount()) {
                ReceiverByUDP receiver = new ReceiverByUDP(this.dataPacketQueue);
                receiver.setContext(this.getContext());
                receiver.setLocalAddress(localAddress);
                receiver.setRemoteAddress(null);
                receiver.start();
                ++i;
            }
            if (s_logger.isDebugEnabled() && (path = this.getConfig().getTracerDirectory()) != null) {
                String file = this.getName();
                this.transportTracer = TransportTracer.newTracer(path, file);
                if (this.transportTracer != null) {
                    this.transportTracer = this.transportTracer.initialize(this.receiveSocket, false);
                }
            }
        }
        catch (IOException e) {
            String info = "InetListenerByUDP startup failed";
            s_logger.fatal((Object)info, (Throwable)e);
            throw new RuntimeException(info, e);
        }
    }

    protected void doListen() {
        try {
            DatagramPacketPool.CDP cdp = this.dataPacketPool.getCDP();
            DatagramPacket datePacket = cdp.getDatePacket();
            this.receiveSocket.receive(datePacket);
            TransportTracer tracer = this.transportTracer;
            if (tracer != null) {
                tracer.trace(datePacket);
            }
            this.dataPacketQueue.put(cdp);
        }
        catch (Exception e) {
            s_logger.error((Object)"InetListenerByUDP doListen failed", (Throwable)e);
        }
    }

    protected void cleanup() {
        try {
            this.receiveSocket.close();
        }
        catch (Exception e) {
            s_logger.error((Object)"InetListenerByUDP cleanup failed", (Throwable)e);
        }
        s_logger.info((Object)("Because close(), drop message count:" + this.dataPacketQueue.size()));
    }
}

