/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.debug;

import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.StreamReader;
import com.trs.infra.cluster.StreamType;
import com.trs.infra.cluster.StreamWriter;
import com.trs.infra.cluster.impl.InnerStreamTypes;
import java.io.IOException;

public class DebugMessage
extends ClusterMessage {
    public static final int MAJOR_MESSAGE_ID = 7;
    public static final int MINOR_DEBUG = 0;
    public static final int MINOR_ACK = 1;
    private int ackFor;
    private int debugSequence;
    private String messageBody;
    private long ackTime;

    public final String getMessageBody() {
        return this.messageBody;
    }

    public final void setMessageBody(String messageBody) {
        this.messageBody = messageBody;
    }

    public DebugMessage() {
        this.setMajorId(7);
    }

    public String _guid() {
        return null;
    }

    public StreamType _type() {
        return InnerStreamTypes.DebugMessage;
    }

    public void _load(StreamReader is) throws IOException {
        this.ackFor = is.read_int();
        this.debugSequence = is.read_int();
        this.messageBody = is.read_string();
    }

    public void _save(StreamWriter os) throws IOException {
        os.write_int(this.ackFor);
        os.write_int(this.debugSequence);
        os.write_string(this.messageBody);
    }

    public final int getAckFor() {
        return this.ackFor;
    }

    public final void setAckFor(int ackFor) {
        this.ackFor = ackFor;
    }

    public final long getAckTime() {
        return this.ackTime;
    }

    public final void setAckTime(long ackTime) {
        this.ackTime = ackTime;
    }

    public final void setAckTime() {
        this.ackTime = System.currentTimeMillis();
    }

    public final int getDebugSequence() {
        return this.debugSequence;
    }

    public final void setDebugSequence(int debugSequence) {
        this.debugSequence = debugSequence;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(128);
        buff.append("DebugMsg: seq=");
        buff.append(this.debugSequence);
        buff.append(", sendDelay=");
        long sendTime = this.getSendTime();
        buff.append(sendTime - this.getCreateTime());
        buff.append(", askDelay=");
        buff.append(this.ackTime - sendTime);
        return buff.toString();
    }
}

