/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class DocType
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: DocType.java,v $ $Revision: 1.14 $ $Date: 2001/04/27 18:21:19 $ $Name: jdom_1_0_b7_rc4 $";
    protected String elementName;
    protected String publicID;
    protected String systemID;
    protected Document document;

    protected DocType() {
    }

    public DocType(String elementName) {
        this(elementName, "", "");
    }

    public DocType(String elementName, String systemID) {
        this(elementName, "", systemID);
    }

    public DocType(String elementName, String publicID, String systemID) {
        this.elementName = elementName;
        this.publicID = publicID;
        this.systemID = systemID;
    }

    public Object clone() {
        DocType docType = null;
        try {
            docType = (DocType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        docType.document = null;
        return docType;
    }

    public final boolean equals(Object ob) {
        if (ob instanceof DocType) {
            DocType dt = (DocType)ob;
            return this.stringEquals(dt.elementName, this.elementName) && this.stringEquals(dt.publicID, this.publicID) && this.stringEquals(dt.systemID, this.systemID);
        }
        return false;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public final String getSerializedForm() {
        boolean hasPublic = false;
        StringBuffer serForm = new StringBuffer().append("<!DOCTYPE ").append(this.elementName);
        if (this.publicID != null && !this.publicID.equals("")) {
            serForm.append(" PUBLIC \"").append(this.publicID).append("\"");
            hasPublic = true;
        }
        if (this.systemID != null && !this.systemID.equals("")) {
            if (!hasPublic) {
                serForm.append(" SYSTEM");
            }
            serForm.append(" \"").append(this.systemID).append("\"");
        }
        serForm.append(">");
        return serForm.toString();
    }

    public String getSystemID() {
        return this.systemID;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected DocType setDocument(Document document) {
        this.document = document;
        return this;
    }

    public DocType setPublicID(String publicID) {
        this.publicID = publicID;
        return this;
    }

    public DocType setSystemID(String systemID) {
        this.systemID = systemID;
        return this;
    }

    private boolean stringEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1.equals(s2);
    }

    public String toString() {
        return "[DocType: " + new XMLOutputter().outputString(this) + "]";
    }
}

