/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.Assert;

public class FileAsserts {
    private static String processOneLine(int lineNumber, BufferedReader expectedData, BufferedReader actualData) throws IOException {
        String problem = null;
        String expectedLine = expectedData.readLine();
        if (!actualData.ready()) {
            problem = "at line " + lineNumber + ", expected:\n" + expectedLine + "\n" + "but actual file was not ready for reading at this line.";
        } else {
            String actualLine = actualData.readLine();
            if (!expectedLine.equals(actualLine)) {
                problem = "at line " + lineNumber + " there was a mismatch.  Expected:\n";
                int maxLen = expectedLine.length();
                if (expectedLine.length() > actualLine.length()) {
                    maxLen = actualLine.length();
                }
                int startOffset = 0;
                for (int i = 0; i < maxLen; ++i) {
                    if (expectedLine.charAt(i) == actualLine.charAt(i)) continue;
                    startOffset = i;
                    break;
                }
                problem = problem + expectedLine.substring(startOffset) + "\n" + "actual was:\n" + actualLine.substring(startOffset) + "\n";
            }
        }
        return problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertEquals(BufferedReader expected, BufferedReader actual) throws Exception {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        String problem = null;
        try {
            int lineCounter = 0;
            while (expected.ready() && problem == null) {
                problem = FileAsserts.processOneLine(lineCounter, expected, actual);
                ++lineCounter;
            }
        }
        finally {
            expected.close();
            actual.close();
        }
        if (problem != null) {
            Assert.fail((String)problem);
        }
    }

    public static void assertEquals(InputStream expected, File actual) throws Exception {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        Assert.assertTrue((boolean)actual.canRead());
        BufferedReader expectedData = new BufferedReader(new InputStreamReader(expected));
        BufferedReader actualData = new BufferedReader(new InputStreamReader(new FileInputStream(actual)));
        FileAsserts.assertEquals(expectedData, actualData);
    }

    public static void assertEquals(File expected, File actual) throws Exception {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        Assert.assertTrue((boolean)expected.canRead());
        Assert.assertTrue((boolean)actual.canRead());
        BufferedReader expectedData = new BufferedReader(new InputStreamReader(new FileInputStream(expected)));
        BufferedReader actualData = new BufferedReader(new InputStreamReader(new FileInputStream(actual)));
        FileAsserts.assertEquals(expectedData, actualData);
    }
}

