/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.GenericRequest;
import java.util.ArrayList;
import java.util.List;

public class DeleteObjectsRequest
extends GenericRequest {
    public static final int DELETE_OBJECTS_ONETIME_LIMIT = 1000;
    private final List<String> keys = new ArrayList<String>();
    private boolean quiet;
    private String encodingType;

    public DeleteObjectsRequest(String bucketName) {
        super(bucketName);
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public DeleteObjectsRequest withQuiet(boolean quiet) {
        this.setQuiet(quiet);
        return this;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(List<String> keys) {
        if (keys == null || keys.size() == 0) {
            throw new IllegalArgumentException("Keys to delete must be specified");
        }
        if (keys.size() > 1000) {
            throw new IllegalArgumentException("The count of keys to delete exceed max limit 1000");
        }
        for (String key : keys) {
            if (key != null && !key.equals("") && OSSUtils.validateObjectKey(key)) continue;
            throw new IllegalArgumentException("Illegal object key " + key);
        }
        this.keys.clear();
        this.keys.addAll(keys);
    }

    public DeleteObjectsRequest withKeys(List<String> keys) {
        this.setKeys(keys);
        return this;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public DeleteObjectsRequest withEncodingType(String encodingType) {
        this.setEncodingType(encodingType);
        return this;
    }
}

