/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DeleteObjectsTest
extends TestBase {
    @Test
    public void testDeleleExistingObjects() {
        ArrayList<String> existingKeys = new ArrayList<String>();
        int keyCount = 100;
        String keyPrefix = "delete-existing-objects";
        int i = 0;
        while (i < 100) {
            existingKeys.add("delete-existing-objects" + i);
            ++i;
        }
        if (!TestUtils.batchPutObject(secondClient, bucketName, existingKeys)) {
            Assert.fail((String)"batch put object failed");
        }
        DeleteObjectsRequest request = new DeleteObjectsRequest(bucketName);
        request.setKeys(existingKeys);
        try {
            DeleteObjectsResult result = secondClient.deleteObjects(request);
            List<String> deletedObjects = result.getDeletedObjects();
            Assert.assertEquals((int)100, (int)deletedObjects.size());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeleleNonexistentObjects() {
        ArrayList<String> nonexistentKeys = new ArrayList<String>();
        int keyCount = 100;
        String keyPrefix = "delete-nonexistent-objects";
        int i = 0;
        while (i < 100) {
            nonexistentKeys.add("delete-nonexistent-objects" + i);
            ++i;
        }
        DeleteObjectsRequest request = new DeleteObjectsRequest(bucketName);
        request.setKeys(nonexistentKeys);
        try {
            DeleteObjectsResult result = secondClient.deleteObjects(request);
            List<String> deletedObjects = result.getDeletedObjects();
            Assert.assertEquals((int)100, (int)deletedObjects.size());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeleleNullOrEmptyObjects() {
        ArrayList<String> emptyKeys = new ArrayList<String>();
        DeleteObjectsRequest request = new DeleteObjectsRequest(bucketName);
        try {
            request.setKeys(emptyKeys);
            secondClient.deleteObjects(request);
            Assert.fail((String)"Delete objects should not be successfully");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        ArrayList<String> withNullKeys = new ArrayList<String>();
        withNullKeys.add("dummykey");
        withNullKeys.add(null);
        try {
            request.setKeys(withNullKeys);
            secondClient.deleteObjects(request);
            Assert.fail((String)"Delete objects should not be successfully");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testDeleleObjectsExceedLimit() {
        ArrayList<String> existingKeys = new ArrayList<String>();
        int keyCount = 1001;
        String keyPrefix = "delete-objects-exceed-limit";
        int i = 0;
        while (i < 1001) {
            existingKeys.add("delete-objects-exceed-limit" + i);
            ++i;
        }
        DeleteObjectsRequest request = new DeleteObjectsRequest(bucketName);
        try {
            request.setKeys(existingKeys);
            secondClient.deleteObjects(request);
            Assert.fail((String)"Delete objects should not be successfully");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testDeleleObjectsQuietly() {
        ArrayList<String> existingKeys = new ArrayList<String>();
        int keyCount = 100;
        String keyPrefix = "delete-objects-quietly";
        int i = 0;
        while (i < 100) {
            existingKeys.add("delete-objects-quietly" + i);
            ++i;
        }
        if (!TestUtils.batchPutObject(secondClient, bucketName, existingKeys)) {
            Assert.fail((String)"batch put object failed");
        }
        DeleteObjectsRequest request = new DeleteObjectsRequest(bucketName);
        request.setQuiet(true);
        request.setKeys(existingKeys);
        try {
            DeleteObjectsResult result = secondClient.deleteObjects(request);
            List<String> deletedObjects = result.getDeletedObjects();
            Assert.assertEquals((int)0, (int)deletedObjects.size());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Ignore
    public void testDeleteObjectsWithEncodingType() {
        String objectPrefix = "object-with-special-characters-";
        try {
            ArrayList<String> existingKeys = new ArrayList<String>();
            existingKeys.add("object-with-special-characters-\u0001\u0007");
            existingKeys.add("object-with-special-characters-\u0002\u0007");
            if (!TestUtils.batchPutObject(secondClient, bucketName, existingKeys)) {
                Assert.fail((String)"batch put object failed");
            }
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName);
            listObjectsRequest.setEncodingType("url");
            ObjectListing objectListing = secondClient.listObjects(listObjectsRequest);
            ArrayList<String> returnedKeys = new ArrayList<String>();
            for (OSSObjectSummary s : objectListing.getObjectSummaries()) {
                String decodedKey = URLDecoder.decode(s.getKey(), "UTF-8");
                returnedKeys.add(decodedKey);
                Assert.assertTrue((boolean)existingKeys.contains(decodedKey));
            }
            Assert.assertEquals((int)existingKeys.size(), (int)objectListing.getObjectSummaries().size());
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName);
            deleteObjectsRequest.setEncodingType("url");
            deleteObjectsRequest.setKeys(returnedKeys);
            deleteObjectsRequest.setQuiet(false);
            DeleteObjectsResult deleteObjectsResult = secondClient.deleteObjects(deleteObjectsRequest);
            Assert.assertEquals((String)"url", (String)deleteObjectsResult.getEncodingType());
            Assert.assertEquals((int)existingKeys.size(), (int)deleteObjectsResult.getDeletedObjects().size());
            for (String o : deleteObjectsResult.getDeletedObjects()) {
                String decodedKey = URLDecoder.decode(o, "UTF-8");
                Assert.assertTrue((boolean)existingKeys.contains(decodedKey));
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

