/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.BucketWebsiteResult;
import com.aliyun.oss.model.SetBucketWebsiteRequest;
import junit.framework.Assert;
import org.junit.Test;

public class BucketWebsiteTest
extends TestBase {
    @Test
    public void testNormalSetBucketWebsite() {
        String bucketName = "normal-set-bucket-website";
        String indexDocument = "index.html";
        String errorDocument = "error.html";
        try {
            try {
                secondClient.createBucket("normal-set-bucket-website");
                SetBucketWebsiteRequest request = new SetBucketWebsiteRequest("normal-set-bucket-website");
                request.setIndexDocument("index.html");
                request.setErrorDocument("error.html");
                secondClient.setBucketWebsite(request);
                TestUtils.waitForCacheExpiration(5);
                BucketWebsiteResult result = secondClient.getBucketWebsite("normal-set-bucket-website");
                Assert.assertEquals((String)"index.html", (String)result.getIndexDocument());
                Assert.assertEquals((String)"error.html", (String)result.getErrorDocument());
                secondClient.deleteBucketWebsite("normal-set-bucket-website");
                request = new SetBucketWebsiteRequest("normal-set-bucket-website");
                request.setIndexDocument("index.html");
                request.setErrorDocument(null);
                secondClient.setBucketWebsite(request);
                TestUtils.waitForCacheExpiration(5);
                result = secondClient.getBucketWebsite("normal-set-bucket-website");
                Assert.assertEquals((String)"index.html", (String)result.getIndexDocument());
                Assert.assertTrue((result.getErrorDocument() == null ? 1 : 0) != 0);
                secondClient.deleteBucketWebsite("normal-set-bucket-website");
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("normal-set-bucket-website");
            }
        }
        finally {
            secondClient.deleteBucket("normal-set-bucket-website");
        }
    }

    @Test
    public void testUnormalSetBucketWebsite() {
        String bucketName = "unormal-set-bucket-website";
        String indexDocument = "index.html";
        String errorDocument = "error.html";
        try {
            SetBucketWebsiteRequest request;
            secondClient.createBucket("unormal-set-bucket-website");
            String nonexistentBucket = "nonexistent-bucket";
            try {
                request = new SetBucketWebsiteRequest("nonexistent-bucket");
                request.setIndexDocument("index.html");
                request.setErrorDocument("error.html");
                secondClient.setBucketWebsite(request);
                Assert.fail((String)"Set bucket website should not be successful");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
            }
            try {
                request = new SetBucketWebsiteRequest("nonexistent-bucket");
                request.setIndexDocument(null);
                request.setErrorDocument("error.html");
                secondClient.setBucketWebsite(request);
                Assert.fail((String)"Set bucket website should not be successful");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof NullPointerException));
            }
        }
        finally {
            secondClient.deleteBucket("unormal-set-bucket-website");
        }
    }

    @Test
    public void testUnormalGetBucketWebsite() {
        String nonexistentBucket = "unormal-get-bucket-website";
        try {
            secondClient.getBucketWebsite("unormal-get-bucket-website");
            Assert.fail((String)"Get bucket website should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
        }
        String bucketWithoutOwnership = "oss";
        try {
            secondClient.getBucketLogging("oss");
            Assert.fail((String)"Get bucket website should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("AccessDenied"));
        }
        String bucketWithoutWebsiteConfiguration = "bucket-without-website-configuration";
        try {
            try {
                secondClient.createBucket("bucket-without-website-configuration");
                secondClient.getBucketWebsite("bucket-without-website-configuration");
                Assert.fail((String)"Get bucket website should not be successful");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"NoSuchWebsiteConfiguration", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not have a website configuration."));
                secondClient.deleteBucket("bucket-without-website-configuration");
            }
        }
        finally {
            secondClient.deleteBucket("bucket-without-website-configuration");
        }
    }

    @Test
    public void testUnormalDeleteBucketWebsite() {
        String nonexistentBucket = "unormal-delete-bucket-website";
        try {
            secondClient.deleteBucketWebsite("unormal-delete-bucket-website");
            Assert.fail((String)"Delete bucket website should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
        }
        String bucketWithoutOwnership = "oss";
        try {
            secondClient.deleteBucketWebsite("oss");
            Assert.fail((String)"Delete bucket website should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("AccessDenied"));
        }
        String bucketWithoutWebsiteConfiguration = "bucket-without-website-configuration";
        try {
            try {
                secondClient.createBucket("bucket-without-website-configuration");
                secondClient.deleteBucketWebsite("bucket-without-website-configuration");
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("bucket-without-website-configuration");
            }
        }
        finally {
            secondClient.deleteBucket("bucket-without-website-configuration");
        }
    }
}

