/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.auth;

import com.aliyun.oss.common.auth.ServiceSignature;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.common.utils.HttpUtil;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import org.junit.Assert;
import org.junit.Test;

public class ServiceSignatureTest {
    @Test
    public void testComputeSignature() throws Exception {
        ServiceSignature sign = ServiceSignature.create();
        String key = "csdev";
        String data = "/ListTable\nDate=Mon%2C%2028%20Nov%202011%2014%3A02%3A46%20GMT&OTSAccessKeyId=csdev&APIVersion=1&SignatureMethod=HmacSHA1&SignatureVersion=1";
        String expected = "3mAoxRc8hd7WdaFB5Ii7dGNcwx0=";
        String signature = sign.computeSignature(key, data);
        Assert.assertEquals((Object)expected, (Object)signature);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        try {
            Date dt = DateUtil.parseRfc822Date("Mon, 28 Nov 2011 14:02:46 GMT");
            parameters.put("Date", DateUtil.formatRfc822Date(dt));
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        parameters.put("OTSAccessKeyId", "csdev");
        parameters.put("APIVersion", "1");
        parameters.put("SignatureMethod", "HmacSHA1");
        parameters.put("SignatureVersion", "1");
        data = "/ListTable\n" + HttpUtil.paramToQueryString(parameters, "utf-8");
        signature = sign.computeSignature("csdev", data);
        Assert.assertEquals((Object)expected, (Object)signature);
    }
}

