/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import java.util.Enumeration;
import org.htmlparser.HTMLNode;
import org.htmlparser.tags.HTMLTag;

public class HTMLScriptTag
extends HTMLTag {
    private String language;
    private String type;
    private String scriptCode;

    public HTMLScriptTag(int tagBegin, int tagEnd, String tagContents, String scriptCode, String language, String type, String tagLine) {
        super(tagBegin, tagEnd, tagContents, tagLine);
        this.scriptCode = scriptCode;
        this.language = language;
        this.type = type;
    }

    public HTMLScriptTag(int tagBegin, int tagEnd, String tagContents, String scriptCode, String language, String type, String tagLine, int _nLine) {
        super(tagBegin, tagEnd, tagContents, tagLine, _nLine);
        this.scriptCode = scriptCode;
        this.language = language;
        this.type = type;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getScriptCode() {
        return this.scriptCode;
    }

    public String getType() {
        return this.type;
    }

    public void setLanguage(String newLanguage) {
        this.language = newLanguage;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String toHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<SCRIPT");
        Enumeration e = this.parsed.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.parsed.get(key);
            if (key.equals("$<TAGNAME>$")) continue;
            sb.append(String.valueOf(String.valueOf(new StringBuffer(" ").append(key).append("=\"").append(value).append("\""))));
        }
        sb.append(">");
        if (this.isEndOfLineCharState()) {
            sb.append(HTMLNode.lineSeparator);
        }
        sb.append(this.scriptCode);
        sb.append("</SCRIPT>");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Script Node : \n");
        if (this.language.length() != 0 || this.type.length() != 0) {
            sb.append("Properties -->\n");
            if (this.language.length() != 0) {
                sb.append(String.valueOf(String.valueOf(new StringBuffer("[Language : ").append(this.language).append("]\n"))));
            }
            if (this.type.length() != 0) {
                sb.append(String.valueOf(String.valueOf(new StringBuffer("[Type : ").append(this.type).append("]\n"))));
            }
        }
        sb.append("\n");
        sb.append("Code\n");
        sb.append("****\n");
        sb.append(String.valueOf(String.valueOf(this.getScriptCode())).concat("\n"));
        return sb.toString();
    }
}

