/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Hashtable;
import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;
import org.htmlparser.HTMLStringNode;
import org.htmlparser.scanners.HTMLBaseHREFScanner;
import org.htmlparser.scanners.HTMLImageScanner;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLEndTag;
import org.htmlparser.tags.HTMLLinkTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLLinkProcessor;
import org.htmlparser.util.HTMLParserException;

public class HTMLLinkScanner
extends HTMLTagScanner {
    public static final String LINK_SCANNER_ID = "A";
    public static final String DIRTY_TAG_MESSAGE = " is a dirty link tag - the tag was not closed. \nWe encountered an open tag, before the previous end tag was found.\nCorrecting this..";
    private HTMLTagScanner previousOpenLinkScanner = null;
    private HTMLLinkProcessor processor = new HTMLLinkProcessor();

    public HTMLLinkScanner() {
    }

    public HTMLLinkScanner(String filter) {
        super(filter);
    }

    protected HTMLTag createLinkTag(String currentLine, HTMLNode node, boolean mailLink, boolean javascriptLink, String link, String linkText, String accessKey, int linkBegin, String tagContents, String linkContents, Vector nodeVector, int _nLine) {
        int linkEnd = node.elementEnd();
        HTMLLinkTag linkTag = new HTMLLinkTag(link, linkText, linkBegin, linkEnd, accessKey, currentLine, nodeVector, mailLink, javascriptLink, tagContents, linkContents, _nLine);
        linkTag.setThisScanner(this);
        return linkTag;
    }

    public boolean evaluate(String s, HTMLTagScanner previousOpenScanner) {
        char ch = (s = HTMLTagScanner.absorbLeadingBlanks(s)).charAt(0);
        if ((ch == 'a' || ch == 'A') && this.previousOpenLinkScanner != null) {
            StringBuffer msg = new StringBuffer();
            msg.append("<");
            msg.append(s);
            msg.append(">");
            msg.append(DIRTY_TAG_MESSAGE);
            this.feedback.warning(msg.toString());
            return true;
        }
        boolean retVal = s.length() < 5 ? false : !(ch != 'a' && ch != 'A' || s.charAt(1) != ' ' && s.charAt(1) != '\n' && s.charAt(1) != '\r');
        if (retVal && s.toUpperCase().indexOf("HREF") == -1) {
            retVal = false;
        }
        return retVal;
    }

    public String extractLink(HTMLTag tag, String url) throws HTMLParserException {
        try {
            Hashtable table = tag.parseParameters();
            String relativeLink = (String)table.get("HREF");
            if (relativeLink != null) {
                relativeLink = this.removeChars(relativeLink, '\n');
                relativeLink = this.removeChars(relativeLink, '\r');
            }
            String string = this.processor.extract(relativeLink, url);
            return string;
        }
        catch (Exception e) {
            String msg = tag != null ? tag.getText() : "null";
            throw new HTMLParserException(String.valueOf(String.valueOf(new StringBuffer("HTMLLinkScanner.extractLink() : Error while extracting link from tag ").append(msg).append(", url = ").append(url))), e);
        }
    }

    public String getAccessKey(String text) {
        String ret;
        block6: {
            ret = null;
            int n = text.toUpperCase().indexOf("ACCESSKEY");
            if (-1 == n) break block6;
            n += "ACCESSKEY".length();
            int length = text.length();
            char ch = '\u0000';
            while (n < length) {
                char c = text.charAt(n);
                ch = c;
                if ('=' == c) break;
                if (Character.isWhitespace(ch)) {
                    ++n;
                    continue;
                }
                n = length;
            }
            if ('=' == ch) {
                ++n;
                while (n < length && Character.isWhitespace(ch = text.charAt(n))) {
                    ++n;
                }
                StringBuffer buffer = new StringBuffer();
                while (n < length && Character.isDigit(ch = text.charAt(n))) {
                    buffer.append(ch);
                    ++n;
                }
                if (buffer.length() != 0) {
                    ret = buffer.toString();
                }
            }
        }
        return ret;
    }

    public boolean isPreviousLinkScannerOpen() {
        return this.previousOpenLinkScanner != null;
    }

    public HTMLTag scan(HTMLTag tag, String url, HTMLReader reader, String currentLine) throws HTMLParserException {
        try {
            HTMLNode node;
            if (this.previousOpenLinkScanner != null) {
                if (tag.getText().length() == 1) {
                    String newLine = this.replaceFaultyTagWithEndTag(tag, currentLine);
                    reader.changeLine(newLine);
                    HTMLEndTag hTMLEndTag = new HTMLEndTag(tag.elementBegin(), tag.elementBegin() + 3, LINK_SCANNER_ID, currentLine, tag.getLine());
                    return hTMLEndTag;
                }
                String newLine = this.insertEndTagBeforeNode(tag, currentLine);
                reader.changeLine(newLine);
                HTMLEndTag hTMLEndTag = new HTMLEndTag(tag.elementBegin(), tag.elementBegin() + 3, LINK_SCANNER_ID, currentLine, tag.getLine());
                return hTMLEndTag;
            }
            this.previousOpenLinkScanner = this;
            boolean mailLink = false;
            boolean javascriptLink = false;
            String linkText = "";
            String accessKey = null;
            String tagContents = tag.getText();
            String linkContents = "";
            String link = this.extractLink(tag, url);
            int mailto = link.indexOf("mailto");
            int javascript = link.indexOf("javascript:");
            int http = link.indexOf("http://");
            int https = link.indexOf("https://");
            if (mailto == 0) {
                mailto = link.indexOf(":");
                link = link.substring(mailto + 1);
                mailLink = true;
            } else if (javascript == 0) {
                link = link.substring(11);
                javascriptLink = true;
            }
            accessKey = this.getAccessKey(tag.getText());
            int linkBegin = tag.elementBegin();
            boolean endFlag = false;
            Vector<HTMLNode> nodeVector = new Vector<HTMLNode>();
            do {
                String tmp;
                if ((node = reader.readElement()) instanceof HTMLStringNode) {
                    tmp = ((HTMLStringNode)node).getText();
                    linkText = String.valueOf(String.valueOf(linkText)).concat(String.valueOf(String.valueOf(tmp)));
                    linkContents = String.valueOf(String.valueOf(linkContents)).concat(String.valueOf(String.valueOf(tmp)));
                }
                if (node instanceof HTMLEndTag) {
                    tmp = ((HTMLEndTag)node).getText();
                    linkContents = String.valueOf(String.valueOf(linkContents)).concat(String.valueOf(String.valueOf("</".concat(String.valueOf(String.valueOf(tmp))))));
                    char ch = tmp.charAt(0);
                    if (ch == 'a' || ch == 'A') {
                        endFlag = true;
                        continue;
                    }
                    endFlag = false;
                    if (tmp.toUpperCase().indexOf("TD") != -1 || tmp.toUpperCase().indexOf("TR") != -1) {
                        String newLine = this.insertEndTagBeforeNode(node, reader.getCurrentLine());
                        reader.changeLine(newLine);
                        endFlag = true;
                        node = new HTMLEndTag(node.elementBegin(), node.elementBegin() + 3, LINK_SCANNER_ID, newLine);
                        continue;
                    }
                    nodeVector.addElement(node);
                    continue;
                }
                if (node == null) continue;
                nodeVector.addElement(node);
            } while (!endFlag && node != null);
            if (node instanceof HTMLEndTag || node == null) {
                if (node == null) {
                    HTMLEndTag endTag = new HTMLEndTag(0, 3, LINK_SCANNER_ID, "</A>");
                    node = endTag;
                }
                this.previousOpenLinkScanner = null;
                HTMLTag endTag = this.createLinkTag(currentLine, node, mailLink, javascriptLink, link, linkText, accessKey, linkBegin, tagContents, linkContents, nodeVector, tag.getLine());
                return endTag;
            }
            HTMLParserException ex = new HTMLParserException("HTMLLinkScanner.scan() : Could not create link tag from ".concat(String.valueOf(String.valueOf(currentLine))));
            this.feedback.error("HTMLLinkScanner.scan() : Could not create link tag from ".concat(String.valueOf(String.valueOf(currentLine))), ex);
            throw ex;
        }
        catch (Exception e) {
            HTMLParserException ex = new HTMLParserException("HTMLLinkScanner.scan() : Error while scanning a link tag, current line = ".concat(String.valueOf(String.valueOf(currentLine))), e);
            this.feedback.error("HTMLLinkScanner.scan() : Error while scanning a link tag, current line = ".concat(String.valueOf(String.valueOf(currentLine))), ex);
            throw ex;
        }
    }

    public String replaceFaultyTagWithEndTag(HTMLTag tag, String currentLine) {
        String newLine = currentLine.substring(0, tag.elementBegin());
        newLine = String.valueOf(String.valueOf(newLine)).concat("</A>");
        newLine = String.valueOf(String.valueOf(newLine)).concat(String.valueOf(String.valueOf(currentLine.substring(tag.elementEnd() + 1, currentLine.length()))));
        return newLine;
    }

    public HTMLBaseHREFScanner createBaseHREFScanner(String filter) {
        return new HTMLBaseHREFScanner(filter, this.processor);
    }

    public HTMLImageScanner createImageScanner(String filter) {
        return new HTMLImageScanner(filter, this.processor);
    }

    public String[] getID() {
        String[] ids = new String[]{LINK_SCANNER_ID};
        return ids;
    }

    static {
        LINK_SCANNER_ID = LINK_SCANNER_ID;
        DIRTY_TAG_MESSAGE = DIRTY_TAG_MESSAGE;
    }
}

