/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmlutils;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class XMLWriter {
    private static String XMLDECLSTART = "<?xml version='1.0'";
    private static String XMLDECLEND = " ?>";
    private static String ENCODING = " encoding=";
    private static String STANDALONE = " standalone=";
    private static String YES = "yes";
    private static String NO = "no";
    private static String DOCTYPESTART = "<!DOCTYPE ";
    private static String DOCTYPEEND = " >";
    private static String SYSTEMID = " SYSTEM ";
    private static String PUBLICID = " PUBLIC ";
    private static String AMPENTITY = "&amp;";
    private static String LTENTITY = "&lt;";
    private static String GTENTITY = "&gt;";
    private static String APOSENTITY = "&apos;";
    private static String QUOTENTITY = "&quot;";
    private static String RETURN = System.getProperty("line.separator");
    private static final char QUOT = '\"';
    private static final char APOS = '\'';
    private static final char LT = '<';
    private static final char GT = '>';
    private static final char AMP = '&';
    private static final char SPACE = ' ';
    private static final char EQUALS = '=';
    private static final char SLASH = '/';
    public String[] attrs;
    public String[] values;
    private Writer writer;
    private boolean pretty = false;
    private boolean charsWritten = false;
    private int saveIndent = -1;
    private int increment = 3;
    private int indent = -1 * this.increment;

    public XMLWriter() {
    }

    public XMLWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setPrettyPrinting(boolean bl, int n) {
        this.pretty = bl;
        this.increment = n < 0 ? 3 : n;
        this.indent = -1 * this.increment;
    }

    public void writeXMLDecl() throws IOException {
        this.writer.write(XMLDECLSTART);
        this.writeEncoding();
        this.writer.write(XMLDECLEND);
        if (this.pretty) {
            this.writer.write(RETURN);
        }
    }

    public void writeXMLDecl(boolean bl) throws IOException {
        this.writer.write(XMLDECLSTART);
        this.writeEncoding();
        this.writer.write(STANDALONE);
        this.writeQuotedValue(bl ? YES : NO);
        this.writer.write(XMLDECLEND);
        if (this.pretty) {
            this.writer.write(RETURN);
        }
    }

    public void writeDOCTYPE(String string, String string2, String string3) throws IOException {
        this.writer.write(DOCTYPESTART);
        this.writer.write(string);
        if (string3 != null) {
            this.writer.write(PUBLICID);
            this.writeQuotedValue(string3);
            this.writer.write(32);
        }
        if (string2 != null) {
            if (string3 == null) {
                this.writer.write(SYSTEMID);
            }
            this.writeQuotedValue(string2);
        }
        this.writer.write(DOCTYPEEND);
        if (this.pretty) {
            this.writer.write(RETURN);
        }
    }

    public void writeElementStart(String string, int n, boolean bl) throws IOException {
        this.indent += this.increment;
        if (!this.charsWritten && this.pretty) {
            this.writer.write(RETURN);
            this.indent();
        }
        this.writer.write(60);
        this.writer.write(string);
        if (this.attrs != null) {
            int n2 = 0;
            while (n2 < n) {
                this.writer.write(32);
                this.writer.write(this.attrs[n2]);
                this.writer.write(61);
                this.writeAttributeValue(this.values[n2]);
                ++n2;
            }
        }
        if (bl) {
            this.writer.write(47);
            this.indent -= this.increment;
        }
        this.writer.write(62);
    }

    public void writeElementEnd(String string) throws IOException {
        if (this.charsWritten) {
            if (this.saveIndent == this.indent) {
                this.charsWritten = false;
                this.saveIndent = -1;
            }
        } else if (this.pretty) {
            this.writer.write(RETURN);
            this.indent();
        }
        this.indent -= this.increment;
        this.writer.write(60);
        this.writer.write(47);
        this.writer.write(string);
        this.writer.write(62);
        this.writer.flush();
    }

    public void writeCharacters(String string) throws IOException {
        this.writeCharacters(string.toCharArray(), 0, string.length());
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws IOException {
        this.characters(cArray, n, n2);
        this.charsWritten = true;
        if (this.saveIndent == -1) {
            this.saveIndent = this.indent;
        }
    }

    public void allocateAttrs(int n) {
        this.attrs = new String[n];
        this.values = new String[n];
    }

    private void writeEncoding() throws IOException {
        String string;
        if (this.writer instanceof OutputStreamWriter && (string = ((OutputStreamWriter)this.writer).getEncoding()) != null) {
            this.writer.write(ENCODING);
            this.writeQuotedValue(string);
        }
    }

    private void writeAttributeValue(String string) throws IOException {
        this.writer.write(34);
        this.characters(string.toCharArray(), 0, string.length());
        this.writer.write(34);
    }

    private void writeQuotedValue(String string) throws IOException {
        char c = this.getQuote(string);
        this.writer.write(c);
        this.writer.write(string);
        this.writer.write(c);
    }

    private char getQuote(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\"') {
                return '\'';
            }
            ++n;
        }
        return '\"';
    }

    private void characters(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n;
        while (n4 < n + n2) {
            block0 : switch (cArray[n4]) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    if (n3 < n4) {
                        this.writer.write(cArray, n3, n4 - n3);
                    }
                    n3 = n4 + 1;
                    switch (cArray[n4]) {
                        case '&': {
                            this.writer.write(AMPENTITY);
                            break block0;
                        }
                        case '<': {
                            this.writer.write(LTENTITY);
                            break block0;
                        }
                        case '>': {
                            this.writer.write(GTENTITY);
                            break block0;
                        }
                        case '\'': {
                            this.writer.write(APOSENTITY);
                            break block0;
                        }
                        case '\"': {
                            this.writer.write(QUOTENTITY);
                            break block0;
                        }
                    }
                }
            }
            ++n4;
        }
        if (n3 < n + n2) {
            this.writer.write(cArray, n3, n + n2 - n3);
        }
    }

    private void indent() throws IOException {
        int n = 0;
        while (n < this.indent) {
            this.writer.write(32);
            ++n;
        }
    }
}

