/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps.utils;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.Key;
import org.xmlmiddleware.xmldbms.maps.OrderInfo;
import org.xmlmiddleware.xmldbms.maps.Table;

public class DMLGenerator {
    private static final String INSERT = "INSERT INTO ";
    private static final String VALUES = " VALUES (";
    private static final String UPDATE = "UPDATE ";
    private static final String SET = " SET ";
    private static final String DELETE = "DELETE ";
    private static final String PARAM = "? ";
    private static final String COMMA = ", ";
    private static final String COMMAPARAM = ", ? ";
    private static final String CLOSEPAREN = ")";
    private static final String OPENPAREN = " (";
    private static final String SPACE = " ";
    private static final String SELECT = "SELECT ";
    private static final String FROM = " FROM ";
    private static final String WHERE = " WHERE ";
    private static final String ORDERBY = " ORDER BY ";
    private static final String DESC = " DESC";
    private static final String AND = " AND ";
    private static final String EQUALSPARAM = " = ? ";
    private static final String PERIOD = ".";
    protected String m_quote;
    protected String m_catalogSeparator;
    protected boolean m_isCatalogAtStart;
    protected boolean m_useCatalog;
    protected boolean m_useSchema;

    public DMLGenerator(DatabaseMetaData databaseMetaData) throws SQLException {
        this.m_quote = databaseMetaData.getIdentifierQuoteString();
        if (this.m_quote == null) {
            this.m_quote = "";
        }
        this.m_isCatalogAtStart = databaseMetaData.isCatalogAtStart();
        this.m_catalogSeparator = databaseMetaData.getCatalogSeparator();
        if (this.m_catalogSeparator == null) {
            this.m_catalogSeparator = PERIOD;
        }
        if (this.m_catalogSeparator.length() == 0) {
            this.m_catalogSeparator = PERIOD;
        }
        this.m_useCatalog = databaseMetaData.supportsCatalogsInDataManipulation();
        this.m_useSchema = databaseMetaData.supportsSchemasInDataManipulation();
    }

    public String getInsert(Table table) {
        return this.getInsert(table, null);
    }

    public String getInsert(Table table, Column[] columnArray) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(INSERT);
        stringBuffer.append(this.getTableName(table));
        stringBuffer.append(OPENPAREN);
        int n = 0;
        if (columnArray == null) {
            Enumeration enumeration = table.getColumns();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(this.makeColumnName((Column)enumeration.nextElement(), n != 0));
                ++n;
            }
        } else {
            int n2 = 0;
            while (n2 < columnArray.length) {
                stringBuffer.append(this.makeColumnName(columnArray[n2], n != 0));
                ++n;
                ++n2;
            }
        }
        stringBuffer.append(CLOSEPAREN);
        stringBuffer.append(VALUES);
        stringBuffer.append(PARAM);
        int n3 = 1;
        while (n3 < n) {
            stringBuffer.append(COMMAPARAM);
            ++n3;
        }
        stringBuffer.append(CLOSEPAREN);
        return stringBuffer.toString();
    }

    public String getSelect(Table table, Key key, OrderInfo orderInfo) {
        return this.buildSelect(table, this.makeWhereLink(key.getColumns()), table.getResultSetColumns(), orderInfo);
    }

    public String getSelect(Table table, Key key) {
        return this.buildSelect(table, this.makeWhereLink(key.getColumns()), key.getColumns(), null);
    }

    public String getSelect(Table table, Key key, Column[] columnArray) {
        return this.buildSelect(table, this.makeWhereLink(key.getColumns()), columnArray, null);
    }

    public String getSelect(Table table, Key key, String string, OrderInfo orderInfo) {
        String string2 = null;
        if (key != null) {
            string2 = this.makeWhereLink(key.getColumns());
        }
        if (string != null) {
            string2 = string2 == null ? WHERE + string : String.valueOf(string2) + AND + string;
        }
        return this.buildSelect(table, string2, table.getResultSetColumns(), orderInfo);
    }

    public String getUpdate(Table table, Key key, Column[] columnArray) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        boolean bl = true;
        stringBuffer.append(UPDATE);
        stringBuffer.append(this.getTableName(table));
        stringBuffer.append(SET);
        if (columnArray != null) {
            int n = 0;
            while (n < columnArray.length) {
                if (!bl) {
                    stringBuffer.append(COMMA);
                }
                stringBuffer.append(this.makeColumnName(columnArray[n], false));
                stringBuffer.append(EQUALSPARAM);
                bl = false;
                ++n;
            }
        } else {
            Enumeration enumeration = table.getColumns();
            while (enumeration.hasMoreElements()) {
                if (!bl) {
                    stringBuffer.append(COMMA);
                }
                stringBuffer.append(this.makeColumnName((Column)enumeration.nextElement(), false));
                stringBuffer.append(EQUALSPARAM);
                bl = false;
            }
        }
        stringBuffer.append(this.makeWhereLink(key.getColumns()));
        return stringBuffer.toString();
    }

    public String getDelete(Table table, Key key) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(DELETE);
        stringBuffer.append(FROM);
        stringBuffer.append(this.getTableName(table));
        stringBuffer.append(this.makeWhereLink(key.getColumns()));
        return stringBuffer.toString();
    }

    public String getDeleteWhere(Table table, Key key, String string) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        String string2 = null;
        stringBuffer.append(DELETE);
        stringBuffer.append(FROM);
        stringBuffer.append(this.getTableName(table));
        if (key != null) {
            string2 = this.makeWhereLink(key.getColumns());
        }
        if (string != null) {
            string2 = string2 == null ? WHERE + string : String.valueOf(string2) + AND + string;
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public String getTableName(Table table) {
        String string;
        String string2 = null;
        String string3 = new String();
        if (this.m_useCatalog && (string2 = table.getCatalogName()) != null && this.m_isCatalogAtStart) {
            string3 = String.valueOf(string3) + this.makeQuotedName(string2);
            string3 = String.valueOf(string3) + this.m_catalogSeparator;
        }
        if (this.m_useSchema && (string = table.getSchemaName()) != null) {
            string3 = String.valueOf(string3) + this.makeQuotedName(string);
            string3 = String.valueOf(string3) + PERIOD;
        }
        string3 = String.valueOf(string3) + this.makeQuotedName(table.getTableName());
        if (this.m_useCatalog && string2 != null && !this.m_isCatalogAtStart) {
            string3 = String.valueOf(string3) + this.m_catalogSeparator;
            string3 = String.valueOf(string3) + this.makeQuotedName(string2);
        }
        return string3;
    }

    protected String buildSelect(Table table, String string, Column[] columnArray, OrderInfo orderInfo) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        boolean bl = false;
        stringBuffer.append(SELECT);
        int n = 0;
        while (n < columnArray.length) {
            if (columnArray[n].getType() != 0) {
                stringBuffer.append(this.makeColumnName(columnArray[n], bl));
                bl = true;
            }
            ++n;
        }
        stringBuffer.append(FROM);
        stringBuffer.append(this.getTableName(table));
        if (string != null) {
            stringBuffer.append(string);
        }
        if (orderInfo != null) {
            this.appendOrderBy(stringBuffer, orderInfo);
        }
        return stringBuffer.toString();
    }

    protected String makeWhereLink(Column[] columnArray) {
        String string = new String();
        string = String.valueOf(string) + WHERE;
        int n = 0;
        while (n < columnArray.length) {
            if (n != 0) {
                string = String.valueOf(string) + AND;
            }
            string = String.valueOf(string) + this.makeColumnName(columnArray[n], false);
            string = String.valueOf(string) + EQUALSPARAM;
            ++n;
        }
        return string;
    }

    protected void appendOrderBy(StringBuffer stringBuffer, OrderInfo orderInfo) {
        if (orderInfo.orderValueIsFixed()) {
            return;
        }
        stringBuffer.append(ORDERBY);
        stringBuffer.append(this.makeColumnName(orderInfo.getOrderColumn(), false));
        if (!orderInfo.isAscending()) {
            stringBuffer.append(DESC);
        }
    }

    protected String makeColumnName(Column column, boolean bl) {
        String string = this.makeQuotedName(column.getName());
        if (bl) {
            return COMMA + string;
        }
        return string;
    }

    private String makeQuotedName(String string) {
        return String.valueOf(this.m_quote) + string + this.m_quote;
    }
}

