/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.util;

import com.trs.infra.common.WCMException;
import com.trs.scm.persistent.Account;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.Platform;
import com.trs.scm.sdk.util.CMyContentTranslate;
import com.trs.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import java.text.SimpleDateFormat;
import org.dom4j.CDATA;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MicroContentConvertor
implements IXMLConvertor {
    @Override
    public String toXmlString(MethodContext _methodContext, Object _result) throws ConvertException {
        MicroContent tempMicor = (MicroContent)_result;
        String sObjectsTagName = this.makeTagName(_result.getClass());
        Element rootElement = DocumentHelper.createElement((String)sObjectsTagName);
        if (tempMicor == null) {
            return rootElement.asXML();
        }
        int nAccountId = _methodContext.getValue("AccountId", 0);
        if (nAccountId == 0) {
            return "\u672a\u4f20\u5165\u6b63\u786e\u7684\u8d26\u53f7\uff01";
        }
        Account oAccount = null;
        try {
            oAccount = Account.findById(nAccountId);
        }
        catch (WCMException e) {
            return "\u67e5\u8be2\u8d26\u53f7\u5931\u8d25\uff01";
        }
        String sPlat = oAccount.getPlatform();
        rootElement = MicroContentConvertor.parseMicroContent(rootElement, tempMicor, null, sPlat);
        return rootElement.asXML();
    }

    public static Element parseMicroContent(Element rootElement, MicroContent tempMicor, String tagName, String _plat) {
        Element microContentElement = null;
        microContentElement = tagName != null ? rootElement.addElement(tagName) : rootElement;
        Element eId = microContentElement.addElement("MicroContentId");
        eId.setText(tempMicor.getId());
        Element eCon = microContentElement.addElement("CONTENT");
        CDATA oCdata = null;
        String sContent = "";
        try {
            int nStartIndex;
            sContent = CMyContentTranslate.microContentTranslate(tempMicor.getContent(), _plat, true);
            if (_plat.equals(Platform.T163PlatFormName) && (nStartIndex = sContent.indexOf("!#T163#!")) > 0) {
                String sContentParams = sContent.substring(nStartIndex + 8, sContent.length() - 1);
                sContent = sContent.substring(0, nStartIndex);
                String[] pParams = sContentParams.split("!#T163#!");
                tempMicor.setThumbnailPic(pParams[0]);
                tempMicor.setBmiddlePic(pParams[1]);
                tempMicor.setOriginalPic(pParams[1]);
            }
            oCdata = DocumentHelper.createCDATA((String)sContent);
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        eCon.add(oCdata);
        Element eThumPic = microContentElement.addElement("ThumbnailPic");
        if (!CMyString.isEmpty((String)tempMicor.getThumbnailPic())) {
            CDATA oThumCdata = DocumentHelper.createCDATA((String)tempMicor.getThumbnailPic());
            eThumPic.add(oThumCdata);
        }
        Element eMiPic = microContentElement.addElement("BmiddlePic");
        if (!CMyString.isEmpty((String)tempMicor.getBmiddlePic())) {
            CDATA oBmiCdata = DocumentHelper.createCDATA((String)tempMicor.getBmiddlePic());
            eMiPic.add(oBmiCdata);
        }
        Element eOrigPic = microContentElement.addElement("OriginalPic");
        if (!CMyString.isEmpty((String)tempMicor.getOriginalPic())) {
            CDATA oOrigCdata = DocumentHelper.createCDATA((String)tempMicor.getOriginalPic());
            eOrigPic.add(oOrigCdata);
        }
        Element eCommentCount = microContentElement.addElement("CommentCount");
        eCommentCount.setText(Integer.valueOf(tempMicor.getCommentCount()).toString());
        Element eRepostCount = microContentElement.addElement("RepostCount");
        eRepostCount.setText(Integer.valueOf(tempMicor.getRepostCount()).toString());
        Element eSOURCE = microContentElement.addElement("Source");
        String sSour = tempMicor.getSource();
        sSour = sSour.replaceAll("<a.*href[^>]*>", "");
        sSour = sSour.replaceAll("</a>", "");
        CDATA oSourceData = DocumentHelper.createCDATA((String)sSour);
        eSOURCE.add(oSourceData);
        Element eMicroUser = microContentElement.addElement("MicroUser");
        Element eUserName = eMicroUser.addElement("UserName");
        CDATA oUserNameData = DocumentHelper.createCDATA((String)tempMicor.getUser().getName());
        eUserName.add(oUserNameData);
        Element eUserHeadPic = eMicroUser.addElement("UserHeadPic");
        CDATA oUserPicData = DocumentHelper.createCDATA((String)tempMicor.getUser().getHead());
        eUserHeadPic.add(oUserPicData);
        Element eISRETWEETED = microContentElement.addElement("IsRetweeted");
        eISRETWEETED.setText(Boolean.valueOf(tempMicor.isRetweeted()).toString());
        Element eFavorited = microContentElement.addElement("IsFavorited");
        eFavorited.setText(Boolean.valueOf(tempMicor.isFavorited()).toString());
        Element eTruncated = microContentElement.addElement("IsTruncated");
        eTruncated.setText(Boolean.valueOf(tempMicor.isTruncated()).toString());
        Element eCreateDate = microContentElement.addElement("IsCreateDate");
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            eCreateDate.setText(df.format(tempMicor.getCreateDate()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tempMicor.isRetweeted() && tempMicor.getRetweetedMicroContent() != null) {
            microContentElement = MicroContentConvertor.parseMicroContent(microContentElement, tempMicor.getRetweetedMicroContent(), "RetweetedMicroContent", _plat);
        }
        if (tagName != null) {
            return rootElement;
        }
        return microContentElement;
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{MicroContent.class.getName()};
    }

    private String makeTagName(Class _objectClass) {
        String sObjectsTagName = _objectClass.getName();
        int nPos = sObjectsTagName.lastIndexOf(46);
        if (nPos >= 0) {
            sObjectsTagName = sObjectsTagName.substring(nPos + 1);
        }
        return sObjectsTagName;
    }
}

