/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.domain;

import com.trs.DreamFactory;
import com.trs.components.document.DocumentTimeRangeHelper;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.publish.domain.IPreNextDocuments;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PreNextDocumentsImpl
implements IPreNextDocuments {
    private static final Logger LOG = Logger.getLogger(PreNextDocumentsImpl.class);
    private Hashtable m_hChannelDocIdsCache = new Hashtable(10);
    public static int MAX_READ_COUNT = 3000;

    @Override
    public Documents[] getPreNextDocuments(Channel _channel, Document document, int num, String _where) throws WCMException {
        Documents[] pCacheDocuments;
        if (_channel == null) {
            _channel = document.getChannel();
        }
        if ((pCacheDocuments = this.getPreNextDocumentsFromCache(_channel, document, num, _where)) != null) {
            return pCacheDocuments;
        }
        return this.initCache(_channel, document, num, _where);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Documents[] initCache(Channel _channel, Document _document, int _nNum, String _where) throws WCMException {
        Integer n = _channel.getKey();
        synchronized (n) {
            String sOrder;
            Documents[] pCacheDocuments = this.getPreNextDocumentsFromCache(_channel, _document, _nNum, _where);
            if (pCacheDocuments != null) {
                return pCacheDocuments;
            }
            IFolderPubStatusCacheMgr m_oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
            boolean zOnlyPublished = "true".equals(ConfigServer.getServer().getSysConfigValue("PRENEXT_PUBLISHED_ONLY", ""));
            StringBuffer sql = new StringBuffer(512);
            sql.append("select WCMCHNLDOC.DOCID from WCMCHNLDOC");
            String chnlQuery = _channel.getQuery();
            boolean bIncludeWcmDoc = false;
            if (!CMyString.isEmpty(chnlQuery)) {
                bIncludeWcmDoc = this.checkWcmDocExist(chnlQuery);
            }
            if (CMyString.isEmpty(sOrder = _channel.getOrderBy()) && CMyString.isEmpty(sOrder = _channel.getSite().getOrderBy())) {
                sOrder = "DOCORDERPRI desc, DocOrder desc";
            }
            if (!bIncludeWcmDoc) {
                bIncludeWcmDoc = this.checkWcmDocExist(sOrder);
            }
            _where = CMyString.showEmpty(_where);
            if (!bIncludeWcmDoc) {
                bIncludeWcmDoc = this.checkWcmDocExist(_where);
            }
            String sTimeWhere = DocumentTimeRangeHelper.makeWhereWithTimeLimit(_channel);
            if (!bIncludeWcmDoc) {
                bIncludeWcmDoc = this.checkWcmDocExist(sTimeWhere);
            }
            if (bIncludeWcmDoc) {
                sql.append(", WCMDOCUMENT");
            }
            sql.append(" where (CHNLID=? and (WCMCHNLDOC.DOCID=?");
            sql.append(" or (MODAL in(?,?) and ");
            int[] pStatusIds = null;
            if (zOnlyPublished) {
                pStatusIds = new int[]{10};
                sql.append("WCMCHNLDOC.DOCSTATUS = ?");
            } else {
                pStatusIds = m_oCacheMgr.findStatusesCanDoPub(103, _channel.getSiteId());
                sql.append("WCMCHNLDOC.DOCSTATUS in(?");
                for (int i = 1; i < pStatusIds.length; ++i) {
                    sql.append(",?");
                }
                sql.append(")");
            }
            sql.append(")))");
            if (!CMyString.isEmpty(chnlQuery)) {
                sql.append(" and (");
                sql.append(chnlQuery);
                sql.append(")");
            }
            if (!CMyString.isEmpty(_where)) {
                sql.append(" and (");
                sql.append(_where);
                sql.append(")");
            }
            if (!CMyString.isEmpty(sTimeWhere)) {
                sql.append(" and (");
                sql.append(sTimeWhere);
                sql.append(")");
            }
            if (bIncludeWcmDoc) {
                sql.append(" and WCMCHNLDOC.DOCID=WCMDOCUMENT.DOCID");
            }
            sql.append(" order by ");
            sql.append(sOrder);
            int[] pParameters = new int[4 + pStatusIds.length];
            pParameters[0] = _channel.getId();
            pParameters[1] = _document.getId();
            pParameters[2] = 1;
            pParameters[3] = 3;
            System.arraycopy(pStatusIds, 0, pParameters, 4, pStatusIds.length);
            Connection oConn = null;
            Statement oPreStmt = null;
            ResultSet rsData = null;
            try {
                Integer iId;
                int i;
                oConn = this.getDBManager().getConnection();
                oPreStmt = oConn.prepareStatement(sql.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("prenext docs sql: " + sql));
                    int len = pParameters.length;
                    for (i = 0; i < len; ++i) {
                        LOG.debug((Object)("param " + i + ": " + pParameters[i]));
                    }
                }
                for (i = 0; i < pParameters.length; ++i) {
                    oPreStmt.setInt(i + 1, pParameters[i]);
                }
                rsData = oPreStmt.executeQuery();
                int nCurrIndex = -1;
                int nTempCount = 0;
                Vector<Integer> vDocIds = new Vector<Integer>(3000);
                boolean bFindEnd = true;
                while (rsData.next()) {
                    if (nCurrIndex >= 0 && nTempCount >= MAX_READ_COUNT) {
                        bFindEnd = false;
                        break;
                    }
                    int nDocId = rsData.getInt(1);
                    ++nTempCount;
                    if (nDocId == _document.getId()) {
                        nCurrIndex = nTempCount - 1;
                        nTempCount = 0;
                    }
                    vDocIds.add(new Integer(nDocId));
                }
                if (nCurrIndex == -1) {
                    StringBuffer sbInfo = new StringBuffer();
                    sbInfo.append(I18NMessage.get(PreNextDocumentsImpl.class, "PreNextDocumentsImpl.label1", "\u7cfb\u7edf\u6545\u969c\uff0c\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u6587\u6863\uff01SQL:"));
                    sbInfo.append(sql);
                    sbInfo.append(I18NMessage.get(PreNextDocumentsImpl.class, "PreNextDocumentsImpl.label2", " \u53c2\u6570\uff1a"));
                    int i2 = 0;
                    while (true) {
                        if (i2 >= pParameters.length) {
                            throw new WCMException(sbInfo.toString());
                        }
                        sbInfo.append(pParameters[i2] + ",");
                        ++i2;
                    }
                }
                if (bFindEnd) {
                    vDocIds.add(new Integer(0));
                }
                this.m_hChannelDocIdsCache.put(_channel.getKey() + "_" + _where, vDocIds);
                rsData.close();
                rsData = null;
                oPreStmt.close();
                oPreStmt = null;
                this.getDBManager().freeConnection(oConn);
                oConn = null;
                int nSize = vDocIds.size();
                int nNextNum = nSize - nCurrIndex - 1;
                if (nNextNum < _nNum && (iId = (Integer)vDocIds.get(nSize - 1)) != 0) {
                    Documents[] documentsArray = null;
                    return documentsArray;
                }
                Documents preDocuments = new Documents(null, nCurrIndex, 1);
                int i3 = nCurrIndex - 1;
                for (int nCount = 0; nCount < _nNum && i3 >= 0; --i3, ++nCount) {
                    preDocuments.addElement((Integer)vDocIds.get(i3));
                }
                Documents nextDocuments = new Documents(null, _nNum, 1);
                int i4 = nCurrIndex + 1;
                for (int nCount = 0; nCount < _nNum && i4 < nSize; ++i4, ++nCount) {
                    nextDocuments.addElement((Integer)vDocIds.get(i4));
                }
                Documents[] documentsArray = new Documents[]{preDocuments, nextDocuments};
                return documentsArray;
            }
            catch (Exception ex) {
                throw new WCMException(40, I18NMessage.get(PreNextDocumentsImpl.class, "PreNextDocumentsImpl.label3", "\u8bfbID\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38:") + sql, ex);
            }
            finally {
                try {
                    if (oPreStmt != null) {
                        oPreStmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (oConn != null) {
                    this.getDBManager().freeConnection(oConn);
                }
            }
        }
    }

    private boolean checkWcmDocExist(String _str) {
        return _str != null && _str.toUpperCase().indexOf("WCMDOCUMENT.") != -1;
    }

    private Documents[] getPreNextDocumentsFromCache(Channel _channel, Document _document, int _num, String _where) {
        Integer iId;
        Vector vDocIds = (Vector)this.m_hChannelDocIdsCache.get(_channel.getKey() + "_" + _where);
        if (vDocIds == null) {
            return null;
        }
        int nIndex = vDocIds.indexOf(_document.getKey());
        if (nIndex < 0) {
            return null;
        }
        int nSize = vDocIds.size();
        int nNextNum = nSize - nIndex - 1;
        if (nNextNum < _num && (iId = (Integer)vDocIds.get(nSize - 1)) != 0) {
            return null;
        }
        Documents preDocuments = new Documents(null, _num, 1);
        int i = nIndex - 1;
        for (int nCount = 0; nCount < _num && i >= 0; --i, ++nCount) {
            preDocuments.addElement((Integer)vDocIds.get(i));
        }
        Documents nextDocuments = new Documents(null, _num, 1);
        int i2 = nIndex + 1;
        for (int nCount = 0; nCount < _num && i2 < nSize; ++i2, ++nCount) {
            nextDocuments.addElement((Integer)vDocIds.get(i2));
        }
        return new Documents[]{preDocuments, nextDocuments};
    }

    private DBManager getDBManager() {
        return DBManager.getDBManager();
    }
}

