/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.ExtendedField;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.DocumentXmlConverter;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.resource.Securities;
import com.trs.components.wcm.resource.Sources;
import com.trs.components.wcm.resource.Statuses;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyZip;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class DocumentExporter {
    private static final String TRSWCM_EXPORTDOCUMENTS_HOLDER = "${TRSWCM_EXPORTDOCUMENTS}";
    private static final String FILE_ENCODING = "utf-8";
    private static final String HTMFILE_DOCUMENT_VIEW_SRC = "document_view.htm";
    public static final String HTMFILE_DOCUMENT_VIEW_EXPORT = "trs_wcm_viewer_doview.htm";
    private static final String HTMFILE_DOCUMENT_LIST_SRC = "document_list.htm";
    public static final String HTMFILE_DOCUMENT_LIST_EXPORT = "trs_wcm_viewer_index.htm";
    public static final String RESOURCE_XML = "resource.xml";
    public static final String REFERENCE_XML = "reference.xml";
    private DocumentXmlConverter m_docconverter = new DocumentXmlConverter();
    private static Logger s_logger = Logger.getLogger(DocumentExporter.class);
    protected static ObjToXmlConverter m_converter = new ObjToXmlConverter();
    private static String FILE_CONTENT_LIST;
    private static String FILE_CONTENT_VIEW;
    private static String EXPORTSRC_PATH;
    private static String EXPORTRESOURCE_PATH;
    private static final BaseObj RESOURCE;

    public String export(int _nDocId, String _sFieldsList, boolean _bWithAppendixes) throws WCMException {
        Documents aDocs = Documents.findByIds(this.getLoginUser(), String.valueOf(_nDocId));
        if (aDocs == null) {
            throw new WCMException(200006, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label1", "\u6ca1\u6709\u627e\u5230\u6587\u6863,id[") + _nDocId + "]!");
        }
        return this.export(aDocs, _sFieldsList, _bWithAppendixes);
    }

    public String export(Document _document, String _sFieldsList, boolean _bWithAppendixes) throws WCMException {
        if (_document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label2", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u65e0\u6cd5\u5bfc\u51fa!"));
        }
        Documents aDocs = Documents.createNewInstance(this.getLoginUser());
        aDocs.addElement(_document);
        return this.export(aDocs, _sFieldsList, _bWithAppendixes);
    }

    public String export(String _sDocIds, String _sFieldsList, boolean _bWithAppendixes) throws WCMException {
        Documents aDocs = Documents.findByIds(this.getLoginUser(), _sDocIds);
        if (aDocs == null || aDocs.isEmpty()) {
            throw new WCMException(200006, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6587\u6863!ID:[") + _sDocIds + "]");
        }
        return this.export(aDocs, _sFieldsList, _bWithAppendixes);
    }

    public String export(Documents _documents, String _sFieldsList, boolean _bWithAppendixes) throws WCMException {
        if (_documents == null || _documents.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label4", "\u6ca1\u6709\u6307\u5b9a\u8981\u5bfc\u51fa\u7684\u6587\u6863!"));
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sTempXmlFile = filesMan.getNextFileName("ST", "xml", null, true);
        this.m_docconverter.setWithAppendix(_bWithAppendixes);
        this.m_docconverter.toXMLFile(_documents, sTempXmlFile, null, _sFieldsList);
        String sTempZipFile = filesMan.getNextFileName("ST", "zip", null, true);
        CMyZip oMyZip = new CMyZip();
        try {
            oMyZip.setZipFileName(sTempZipFile);
            oMyZip.addToZip(sTempXmlFile, false);
        }
        catch (CMyException e) {
            throw new WCMException(54, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label5", "\u521b\u5efaZip\u6587\u4ef6\u5931\u8d25!"), e);
        }
        finally {
            CMyFile.deleteFile(sTempXmlFile);
        }
        try {
            oMyZip = this.exportRelateFiles(oMyZip, _documents, _bWithAppendixes);
        }
        catch (CMyException e) {
            throw new WCMException(1100, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label6", "\u6dfb\u52a0\u6587\u6863\u76f8\u5173\u8d44\u6e90\u6587\u4ef6\u5230zip\u6587\u4ef6\u4e2d\u5931\u8d25!"), e);
        }
        try {
            this.exportResourcesForOffLineView(oMyZip, _documents, sTempXmlFile);
            oMyZip.done();
        }
        catch (CMyException e) {
            throw new WCMException(1100, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label7", "\u6dfb\u52a0\u79bb\u7ebf\u6d4f\u8d44\u6e90\u6587\u4ef6\u5230zip\u6587\u4ef6\u5931\u8d25!"), e);
        }
        return CMyFile.extractFileName(sTempZipFile);
    }

    private CMyZip exportRelateFiles(CMyZip _myZip, Documents _docs, boolean _bWithAppendixes) throws WCMException, CMyException {
        AppendixMgr currMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        Document doc = null;
        Appendixes appendixes = null;
        for (int i = 0; i < _docs.size(); ++i) {
            doc = (Document)_docs.getAt(i);
            if (doc == null) continue;
            if (_bWithAppendixes) {
                appendixes = currMgr.getAppendixes(doc, 60);
                _myZip = this.exportAppendixes(_myZip, appendixes);
            }
            this.exportExternalFileIfNecessary(_myZip, doc);
            if (doc.getType() != 20 && doc.getPropertyAsInt("DocFlag", 0) <= 0) continue;
            _myZip = this.processPicFiles(doc, _myZip);
        }
        return _myZip;
    }

    private void exportExternalFileIfNecessary(CMyZip _oMyZip, Document _document) throws CMyException {
        if (40 != _document.getType()) {
            return;
        }
        String sFile = _document.getPropertyAsString("DOCFILENAME");
        if (sFile == null || (sFile = sFile.trim()).length() == 0) {
            return;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFilePath = filesMan.mapFilePath(sFile, 0) + sFile;
        if (CMyFile.fileExists(sFilePath)) {
            _oMyZip.addToZip(sFilePath, false);
        }
    }

    private CMyZip processPicFiles(Document _document, CMyZip _oMyZip) throws CMyException {
        FilesMan filesMan = FilesMan.getFilesMan();
        List picFiles = _document.getHTMLWCMFiles();
        String sPicFile = null;
        for (int j = 0; j < picFiles.size(); ++j) {
            sPicFile = (String)picFiles.get(j);
            if (!CMyFile.fileExists(sPicFile = filesMan.mapFilePath(sPicFile, 0) + sPicFile)) continue;
            _oMyZip.addToZip(sPicFile, false);
        }
        return _oMyZip;
    }

    private CMyZip exportAppendixes(CMyZip _oMyZip, Appendixes _appendixes) throws WCMException, CMyException {
        FilesMan filesMan = FilesMan.getFilesMan();
        Appendix aAppendix = null;
        String sAppendixFile = null;
        for (int i = 0; i < _appendixes.size(); ++i) {
            aAppendix = (Appendix)_appendixes.getAt(i);
            if (aAppendix == null || aAppendix.getFlag() == 40) continue;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("appendix[" + i + "]:" + aAppendix.getFile()));
            }
            if (!CMyFile.fileExists(sAppendixFile = filesMan.mapFilePath(aAppendix.getFile(), 0) + aAppendix.getFile())) {
                s_logger.warn((Object)("missing the appendix file:" + sAppendixFile));
                continue;
            }
            _oMyZip.addToZip(sAppendixFile, false);
        }
        return _oMyZip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportResourcesForOffLineView(CMyZip _oMyZip, Documents _documents, String _sExportXmlFile) throws CMyException {
        if (EXPORTSRC_PATH == null) {
            this.initExportHtmFileContent();
        }
        ResourceXmlConverter converter = new ResourceXmlConverter(_documents);
        String sResourceXml = EXPORTSRC_PATH + "viewer" + File.separator + RESOURCE_XML;
        try {
            converter.toXMLFile(RESOURCE, sResourceXml);
            this.updateHtmlFile(_sExportXmlFile);
            _oMyZip.setZipWithChildDirPath(true);
            _oMyZip.addToZip(EXPORTSRC_PATH, false);
        }
        finally {
            CMyFile.deleteFile(sResourceXml);
        }
    }

    private synchronized void initExportHtmFileContent() {
        try {
            EXPORTRESOURCE_PATH = FilesMan.getFilesMan().getPathConfigValue("DS", 0) + "exportresource" + File.separator;
            EXPORTSRC_PATH = EXPORTRESOURCE_PATH + "exportsrc" + File.separator;
            String sListFile = EXPORTRESOURCE_PATH + HTMFILE_DOCUMENT_LIST_SRC;
            FILE_CONTENT_LIST = CMyFile.readFile(sListFile, FILE_ENCODING);
            String sViewFile = EXPORTRESOURCE_PATH + HTMFILE_DOCUMENT_VIEW_SRC;
            FILE_CONTENT_VIEW = CMyFile.readFile(sViewFile, FILE_ENCODING);
        }
        catch (CMyException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateHtmlFile(String _sExportXmlFile) throws CMyException {
        String sSrcFile = CMyFile.extractFileName(_sExportXmlFile);
        String sListFile = EXPORTSRC_PATH + HTMFILE_DOCUMENT_LIST_EXPORT;
        String sListHtml = CMyString.replaceStr(FILE_CONTENT_LIST, TRSWCM_EXPORTDOCUMENTS_HOLDER, sSrcFile);
        CMyFile.writeFile(sListFile, sListHtml, FILE_ENCODING);
        String sViewFile = EXPORTSRC_PATH + HTMFILE_DOCUMENT_VIEW_EXPORT;
        String sViewHtml = CMyString.replaceStr(FILE_CONTENT_VIEW, TRSWCM_EXPORTDOCUMENTS_HOLDER, sSrcFile);
        CMyFile.writeFile(sViewFile, sViewHtml, FILE_ENCODING);
    }

    protected User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    static {
        RESOURCE = new BaseObj(){

            @Override
            public int getWCMType() {
                return -2;
            }

            @Override
            public String getDbTableName() {
                return "RESOURCE";
            }

            @Override
            public String getIdFieldName() {
                return "RESOURCEID";
            }

            @Override
            public boolean isValid() {
                return false;
            }
        };
        RESOURCE.setProperties(new Hashtable<String, Object>());
    }

    protected class NullBaseObj
    extends BaseObj {
        private String DB_TABLE_NAME = null;

        protected NullBaseObj() {
        }

        @Override
        public int getWCMType() {
            return -1;
        }

        @Override
        public String getDbTableName() {
            return this.DB_TABLE_NAME;
        }

        @Override
        public String getIdFieldName() {
            return null;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        public void setDbTableName(String _sTablename) {
            this.DB_TABLE_NAME = _sTablename;
        }
    }

    private class ResourceXmlConverter
    extends BaseObjToXmlConverter {
        private String m_sChannelIds = null;
        private User m_user = null;
        private Documents m_oDocuments;
        private Map m_oContext = null;

        public ResourceXmlConverter(Documents _documents) {
            this.m_oDocuments = _documents;
            this.m_user = DocumentExporter.this.getLoginUser();
        }

        private void buildContext() throws WCMException {
            if (this.m_oContext != null) {
                return;
            }
            this.m_oContext = new HashMap();
            Channels channels = Channels.createNewInstance(this.m_user);
            Statuses statuses = Statuses.createNewInstance(this.m_user);
            Sources sources = Sources.createNewInstance(this.m_user);
            Securities securities = Securities.createNewInstance(this.m_user);
            int nSize = this.m_oDocuments.size();
            for (int i = 0; i < nSize; ++i) {
                int nSecurityId;
                Document document = (Document)this.m_oDocuments.getAt(i);
                if (document == null) continue;
                channels.addElement(document.getChannelId());
                statuses.addElement(document.getStatusId());
                int nSourceId = document.getSourceId();
                if (nSourceId > 0) {
                    sources.addElement(nSourceId);
                }
                if ((nSecurityId = document.getSecurityId()) <= 0) continue;
                securities.addElement(nSecurityId);
            }
            this.m_oContext.put("channels", channels);
            this.m_oContext.put("statuses", statuses);
            this.m_oContext.put("sources", sources);
            this.m_oContext.put("securities", securities);
        }

        @Override
        protected Element[] getChildElement(BaseObj _baseObj) throws WCMException {
            Element[] childrenEls = new Element[]{this.getChannelsEl(), this.getStatusesEl(), this.getDocSourcesEl(), this.getDocSecuritiesEl(), this.getExtFieldsEl()};
            return childrenEls;
        }

        private Element getChannelsEl() throws WCMException {
            this.buildContext();
            String sFiledList = "ChannelId,ChnlName,ChnlDesc";
            Channels channels = (Channels)this.m_oContext.get("channels");
            this.setChannelIds(channels.getIdListAsString());
            return m_converter.toXmlElement(channels, sFiledList);
        }

        private void setChannelIds(String _sIds) {
            this.m_sChannelIds = _sIds;
        }

        private Element getStatusesEl() throws WCMException {
            this.buildContext();
            String sFieldList = "StatusId,SName,SDesc,SDisp";
            Statuses statuses = (Statuses)this.m_oContext.get("statuses");
            return m_converter.toXmlElement(statuses, sFieldList);
        }

        private Element getDocSourcesEl() throws WCMException {
            this.buildContext();
            String sFieldList = "SourceId,SrcName";
            Sources sources = (Sources)this.m_oContext.get("sources");
            return m_converter.toXmlElement(sources, sFieldList);
        }

        private Element getDocSecuritiesEl() throws WCMException {
            this.buildContext();
            String sFieldList = "SecurityId,SName";
            Securities securities = (Securities)this.m_oContext.get("securities");
            return m_converter.toXmlElement(securities, sFieldList);
        }

        private Element getExtFieldsEl() throws WCMException {
            if (this.m_sChannelIds == null) {
                return null;
            }
            String sFieldList = "ObjId,EXTFIELDID,LOGICFIELDDESC";
            String sWhere = "ObjId IN(" + this.m_sChannelIds + ") AND ObjType=" + 101;
            ContentExtFields fields = new ContentExtFields(this.m_user);
            WCMFilter aFilter = new WCMFilter("", sWhere, "", sFieldList);
            fields.open(aFilter);
            ArrayList<NullBaseObj> list = new ArrayList<NullBaseObj>(fields.size());
            for (int i = 0; i < fields.size(); ++i) {
                ContentExtField field = (ContentExtField)fields.getAt(i);
                if (field == null) continue;
                NullBaseObj nullable = new NullBaseObj();
                nullable.setDbTableName("DOCEXTENDEDFIELD");
                Hashtable<String, Object> properties = new Hashtable<String, Object>(3);
                properties.put("DOCCHANNEL", String.valueOf(field.getObjId()));
                ExtendedField phyfield = ExtendedField.findById(field.getExtFieldId());
                String fieldName = phyfield.getName();
                properties.put("REALFIELD", fieldName);
                properties.put("LOGICFIELDDESC", CMyString.showNull(field.getDesc(), fieldName));
                properties.put("FIELDTYPE", CMyString.showNull(phyfield.getAttributeValue("FIELDTYPE")));
                properties.put("ENMVALUE", CMyString.showNull(phyfield.getAttributeValue("ENMVALUE")));
                nullable.setProperties(properties);
                list.add(nullable);
            }
            return m_converter.toXmlElement(list, null);
        }
    }
}

