/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.ObjectMember;
import com.trs.cms.auth.persistent.ObjectMembers;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;

public class MemberLCListenerForRight
implements IObjectLCListenerOnDel {
    @Override
    public void notifyOnDelObj(BaseObj objDeleted, int eventType) throws WCMException {
        if (objDeleted == null) {
            return;
        }
        int nObjType = objDeleted.getWCMType();
        if (nObjType != 204 && nObjType != 201 && nObjType != 203) {
            return;
        }
        User currUser = ContextHelper.getLoginUser();
        WCMFilter aFilter = new WCMFilter("", "MEMBERTYPE=? AND MEMBERID=?", "", "");
        aFilter.addSearchValues(nObjType);
        aFilter.addSearchValues(objDeleted.getId());
        ObjectMembers objectMembers = ObjectMembers.openWCMObjs(currUser, aFilter);
        if (objectMembers != null) {
            int nSize = objectMembers.size();
            for (int i = 0; i < nSize; ++i) {
                ObjectMember objectMember = (ObjectMember)objectMembers.getAt(i);
                if (objectMember == null) continue;
                objectMember.delete(currUser);
            }
        }
        aFilter = new WCMFilter("", "OPRTYPE=? AND OPRID=?", "", "");
        aFilter.addSearchValues(nObjType);
        aFilter.addSearchValues(objDeleted.getId());
        Rights rights = Rights.openWCMObjs(currUser, aFilter);
        if (rights != null) {
            int nSize = rights.size();
            for (int i = 0; i < nSize; ++i) {
                Right right = (Right)rights.getAt(i);
                if (right == null) continue;
                right.delete(currUser);
            }
        }
    }
}

