/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.shell;

import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.impl.ClusterContextImpl;
import com.trs.infra.cluster.impl.ExtensionMessage;
import com.trs.infra.cluster.shell.Command;
import com.trs.infra.cluster.shell.Debug;
import com.trs.infra.cluster.shell.DebugExt;
import com.trs.infra.cluster.shell.Exit;
import com.trs.infra.cluster.shell.Help;
import com.trs.infra.cluster.shell.HoldExtensionMessage;
import com.trs.infra.cluster.shell.List;
import com.trs.infra.cluster.shell.Restart;
import com.trs.infra.cluster.shell.SendDebug;
import com.trs.infra.cluster.shell.SendExtMsg;
import com.trs.infra.cluster.shell.TcpSet;
import com.trs.infra.cluster.shell.TestExtension;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ClusterConsole {
    private static final String TEST_EXT_GUID = "ClusterMain$Test";
    private static String extensionGuid = "ClusterMain$Test";
    static int holdExtensionMessage = 0;
    private static BufferedReader reader = null;
    static ClusterContextImpl context = null;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("No config file provider.");
            System.exit(1);
        }
        File file = new File(args[0]);
        ClusterConfig config = new ClusterConfig();
        config.load(file);
        ClusterContextImpl impl = new ClusterContextImpl();
        impl.setConfig(config);
        extensionGuid = args.length > 1 ? args[1] : TEST_EXT_GUID;
        impl.getExtensionManager().addExtension(new TestExtension(extensionGuid));
        impl.start();
        context = impl;
        InputStreamReader insr = new InputStreamReader(System.in);
        reader = new BufferedReader(insr);
        Map CMDS = ClusterConsole.intiCommand();
        System.out.println("Cluster> ");
        System.out.println("Cluster> ");
        System.out.println("\tWelcome, you are using cluster console. Try help.");
        System.out.println("Cluster> ");
        while (true) {
            Command cmd;
            if ((cmd = (Command)CMDS.get(ClusterConsole.readIn("Cluster> "))) == null) {
                continue;
            }
            cmd.exec();
        }
    }

    private static Map intiCommand() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("holdext", new HoldExtensionMessage());
        commands.put("exit", new Exit());
        commands.put("list", new List());
        commands.put("tcpset", new TcpSet());
        commands.put("restart", new Restart());
        commands.put("debug", new Debug());
        commands.put("senddebug", new SendDebug());
        commands.put("sendext", new SendExtMsg());
        commands.put("debugext", new DebugExt());
        commands.put("help", new Help(commands));
        return commands;
    }

    protected static void sendMsg(String msg, String to) {
        ExtensionMessage message = new ExtensionMessage();
        message.setExtensionId(extensionGuid);
        message.setArguments((Serializable)((Object)msg));
        Member toMember = context.getMemberManager().find(to);
        if (toMember == null) {
            context.send(message);
        } else {
            context.send((ClusterMessage)message, toMember);
        }
    }

    static String readIn(String prompt) {
        System.out.print(prompt);
        try {
            String line = reader.readLine();
            return line;
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    static void setTcp() {
        ClusterConfig config;
        config.setTcpNoDelay(!(config = context.getConfig()).getTcpNoDelay());
        config.setKeepAlive(!config.getKeepAlive());
        config.setResuseAddress(!config.getReuseAddress());
        if (config.getTcpNoDelay()) {
            System.out.println("TcpNoDelay, KeepAlive, ReuseAddress on.");
        } else {
            System.out.println("TcpNoDelay, KeepAlive, ReuseAddress off.");
        }
    }
}

