/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.io;

import com.trs.infra.cluster.StreamReader;
import com.trs.infra.cluster.io.ByteArrayOutputStream;
import com.trs.infra.cluster.io.StreamDataUtil;
import com.trs.infra.cluster.io.StreamException;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class FilterStreamReader
extends FilterInputStream
implements StreamReader {
    static final byte[] BLANK_BYTE_ARRAY = new byte[0];
    static final String BLANK_STRING = "";
    private long fullSize;
    private int intCount;
    private ByteArrayOutputStream bypass;
    private final byte[] numberBuffer = new byte[8];
    private byte[] stringBuffer = new byte[256];

    public FilterStreamReader(InputStream in) {
        super(in);
    }

    private final void incCount(int value) {
        int temp = this.intCount + value;
        if (temp > 0) {
            this.intCount = temp;
            return;
        }
        this.intCount = 0;
        this.fullSize = this.fullSize + (long)this.intCount + (long)value;
    }

    public final ByteArrayOutputStream getBypass() {
        return this.bypass;
    }

    public final void setBypass(ByteArrayOutputStream bypass) {
        this.bypass = bypass;
    }

    public final long size() {
        return this.fullSize + (long)this.intCount;
    }

    public long skip(long target) throws IOException {
        int total = 0;
        int length = 0;
        while ((long)total < target && (length = (int)this.in.skip(target - (long)total)) > 0) {
            total += length;
        }
        return total;
    }

    public void close() throws IOException {
        super.close();
        this.fullSize = 0L;
        this.intCount = 0;
        this.bypass = null;
    }

    public final int read() throws IOException {
        int b = this.in.read();
        if (b < 0) {
            throw new EOFException();
        }
        this.incCount(1);
        ByteArrayOutputStream bypass = this.bypass;
        if (bypass != null) {
            bypass.write(b);
        }
        return b;
    }

    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        int length = this.in.read(b, off, len);
        if (length < 0) {
            throw new EOFException();
        }
        this.incCount(length);
        ByteArrayOutputStream bypass = this.bypass;
        if (bypass != null) {
            bypass.write(b, off, length);
        }
        return length;
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = 0;
        while (count < len) {
            count += this.read(b, off + count, len - count);
        }
    }

    public final boolean read_boolean() throws IOException {
        return this.read() != 0;
    }

    public final byte read_byte() throws IOException {
        return (byte)(this.read() & 0xFF);
    }

    public final char read_char() throws IOException {
        int b1 = this.read();
        int b2 = this.read();
        return (char)((b1 << 8) + (b2 << 0));
    }

    public final short read_short() throws IOException {
        int b1 = this.read();
        int b2 = this.read();
        return (short)((b1 << 8) + (b2 << 0));
    }

    public final int read_int() throws IOException {
        int b1 = this.read();
        int b2 = this.read();
        int b3 = this.read();
        int b4 = this.read();
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
    }

    public final long read_long() throws IOException {
        this.readFully(this.numberBuffer, 0, 8);
        return StreamDataUtil.read_long(this.numberBuffer, 0);
    }

    public final float read_float() throws IOException {
        return Float.intBitsToFloat(this.read_int());
    }

    public final double read_double() throws IOException {
        return Double.longBitsToDouble(this.read_long());
    }

    public final String read_string() throws IOException {
        int length = this.read_int();
        if (length < -1) {
            throw new StreamException("Invalide string length");
        }
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return BLANK_STRING;
        }
        if (length > this.stringBuffer.length) {
            this.stringBuffer = new byte[length];
        }
        this.readFully(this.stringBuffer, 0, length);
        return new String(this.stringBuffer, 0, length, "UTF-8");
    }

    public final Object read_object() throws IOException, ClassNotFoundException {
        byte flag = this.read_byte();
        if (flag == 0) {
            return null;
        }
        ObjectInputStream ois = new ObjectInputStream(this);
        Object value = ois.readUnshared();
        flag = this.read_byte();
        return value;
    }

    public final byte[] read_byte_array() throws IOException {
        int length = this.read_int();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return BLANK_BYTE_ARRAY;
        }
        byte[] buffer = new byte[length];
        this.readFully(buffer, 0, length);
        return buffer;
    }
}

