/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl.transport;

import java.net.DatagramPacket;

public class DatagramPacketPool {
    private final CDP[] pool;
    private final int poolSize;
    private final int bufferSize;

    public DatagramPacketPool(int poolSize, int bufferSize) {
        CDP[] poolLocal = new CDP[poolSize];
        int i = 0;
        while (i < poolSize) {
            byte[] buffer = new byte[bufferSize];
            DatagramPacket packet = new DatagramPacket(buffer, 0, bufferSize);
            poolLocal[i] = new CDP(packet);
            ++i;
        }
        this.pool = poolLocal;
        this.poolSize = poolSize;
        this.bufferSize = bufferSize;
    }

    public final CDP getCDP() {
        CDP[] poolLocal = this.pool;
        int poolSize = this.poolSize;
        int i = 0;
        while (i < poolSize) {
            CDP cdp = poolLocal[i];
            if (cdp.check()) {
                return cdp;
            }
            ++i;
        }
        byte[] buffer = new byte[this.bufferSize];
        DatagramPacket packet = new DatagramPacket(buffer, 0, this.bufferSize);
        return new CDP(packet);
    }

    public static class CDP {
        private DatagramPacket datePacket;
        private boolean freePacket;

        private CDP(DatagramPacket datePacket) {
            this.datePacket = datePacket;
            this.freePacket = true;
        }

        public final DatagramPacket getDatePacket() {
            return this.datePacket;
        }

        public final void setDatePacket(DatagramPacket datePacket) {
            this.datePacket = datePacket;
        }

        public final boolean isFreePacket() {
            return this.freePacket;
        }

        public final void setFreePacket(boolean freePacket) {
            this.freePacket = freePacket;
        }

        public final boolean check() {
            if (this.freePacket) {
                this.freePacket = false;
                return true;
            }
            return false;
        }

        public final void reuse() {
            this.datePacket.setAddress(null);
            this.datePacket.setData(this.datePacket.getData());
            this.datePacket.setPort(0);
            this.freePacket = true;
        }
    }
}

