/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl;

import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.MemberListener;
import com.trs.infra.cluster.Startable;
import com.trs.infra.cluster.Statistic;
import com.trs.infra.cluster.impl.ClusterContextImpl;
import com.trs.infra.cluster.impl.ClusterMessageQueue;
import com.trs.infra.cluster.impl.ClusterSenderBase;
import com.trs.infra.cluster.impl.transport.SenderByMulticast;
import com.trs.infra.cluster.impl.transport.SenderByTCP;
import com.trs.infra.cluster.impl.transport.SenderByUDP;
import com.trs.infra.cluster.member.MemberImpl;
import com.trs.infra.cluster.member.MemberManagerImpl;
import com.trs.infra.cluster.member.MemberTransport;
import org.apache.log4j.Logger;

final class ClusterSenderDispatcher
implements MemberListener,
Startable {
    private static final Logger s_logger;
    private ClusterContextImpl context;
    private MemberManagerImpl memberManager;
    private ClusterMessageQueue queueMulticast;
    private SenderByMulticast senderMulticast;
    private ClusterMessageQueue queueUDP;
    private SenderByUDP senderUDP;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.ClusterSenderDispatcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public ClusterSenderDispatcher(ClusterContextImpl context) {
        this.context = context;
    }

    public final MemberManagerImpl getMemberManager() {
        return this.memberManager;
    }

    public final void setMemberManager(MemberManagerImpl memberManager) {
        this.memberManager = memberManager;
    }

    public void start() {
        this.queueMulticast = new ClusterMessageQueue(4096);
        this.queueUDP = new ClusterMessageQueue(4096);
        this.senderUDP = new SenderByUDP();
        this.senderUDP.setContext(this.context);
        this.senderUDP.setMessageQueue(this.queueUDP);
        this.senderUDP.start();
    }

    public void close() {
        this.senderUDP.close();
    }

    public void dispatch(ClusterMessage message) {
        if (message.getTargetAddress() != null) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Be to queue UDP message: " + message));
            }
            this.queueUDP.put(message);
            return;
        }
        if (message.isBroadcast()) {
            this.queueMulticast.put(message);
            return;
        }
        this.dispatch(message, this.memberManager.membersArray());
    }

    public void dispatch(ClusterMessage message, MemberImpl member) {
        MemberTransport transport;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Be to queue TCP message: " + message + ", to member:" + member));
        }
        if ((transport = member.getTransport()) == null) {
            s_logger.error((Object)("Member:" + member + " without transport"));
            return;
        }
        transport.getSendQueue().put(message);
    }

    public void dispatch(ClusterMessage message, MemberImpl[] members) {
        int length = 0;
        if (members != null) {
            length = members.length;
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Be to queue TCP message: " + message + ", to members:" + length));
        }
        if (length <= 0) {
            return;
        }
        int i = 0;
        while (i < length) {
            MemberTransport transport;
            MemberImpl member = members[i];
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Be to queue TCP message: " + message + ", to member:" + member));
            }
            if ((transport = member.getTransport()) == null) {
                s_logger.error((Object)("Member:" + member + " without transport"));
            } else {
                transport.getSendQueue().put(message);
            }
            ++i;
        }
    }

    public void memberFailed(Member member) {
        this.memberLeft(member);
    }

    public void memberJoined(Member member) {
        MemberImpl memberImpl = (MemberImpl)member;
        MemberTransport transport = memberImpl.getTransport();
        int tcpSenderLimit = this.context.getConfig().getTCPThreadCount();
        int i = transport.getSenderCount();
        while (i < tcpSenderLimit) {
            SenderByTCP sender = new SenderByTCP(this.memberManager.member(), memberImpl);
            sender.setContext(this.context);
            sender.setMessageQueue(transport.getSendQueue());
            sender.start();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void memberLeft(Member member) {
        memberImpl = (MemberImpl)member;
        itr = memberImpl.getTransport().getSenders();
        if (itr != null) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            sender = (ClusterSenderBase)itr.next();
            if (sender == null) continue;
            sender.close();
lbl8:
            // 3 sources

            ** while (itr.hasNext())
        }
lbl9:
        // 1 sources

    }

    public void addSender(ClusterSenderBase sender) {
        MemberImpl member = (MemberImpl)sender.getRemoteMember();
        if (member != null) {
            member.getTransport().addSender(sender);
        }
    }

    public void removeSender(ClusterSenderBase sender) {
        MemberImpl member = (MemberImpl)sender.getRemoteMember();
        if (member != null) {
            member.getTransport().removeSender(sender);
        }
    }

    public Statistic getStatistic() {
        return null;
    }
}

