/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import java.io.Serializable;
import org.w3c.dom.Node;

public class QName
implements Serializable {
    private String namespaceURI;
    private String localPart;

    public QName() {
    }

    public QName(Node node) throws IllegalArgumentException {
        String namespaceURI = node.getNamespaceURI();
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Can't create QName: NamespaceURI must not be null.");
        }
        String localPart = node.getLocalName();
        if (localPart == null) {
            throw new IllegalArgumentException("Can't create QName: LocalName must not be null.");
        }
        this.setNamespaceURI(namespaceURI);
        this.setLocalPart(localPart);
    }

    public QName(String namespaceURI, String localPart) {
        this.setNamespaceURI(namespaceURI);
        this.setLocalPart(localPart);
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI == null ? "" : namespaceURI;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setLocalPart(String localPart) {
        this.localPart = localPart == null ? "" : localPart;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public int hashCode() {
        return this.namespaceURI.hashCode() + this.localPart.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.namespaceURI.equals(((QName)obj).getNamespaceURI()) && this.localPart.equals(((QName)obj).getLocalPart());
    }

    public boolean matches(Node node) {
        return node != null && this.namespaceURI.equals(node.getNamespaceURI()) && this.localPart.equals(node.getLocalName());
    }

    public String toString() {
        return new StringBuffer(this.namespaceURI.length() + 2 + this.localPart.length()).append('{').append(this.namespaceURI).append('}').append(this.localPart).toString();
    }
}

