/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j.solr;

import com.chenlb.mmseg4j.ComplexSeg;
import com.chenlb.mmseg4j.Dictionary;
import com.chenlb.mmseg4j.MaxWordSeg;
import com.chenlb.mmseg4j.Seg;
import com.chenlb.mmseg4j.SimpleSeg;
import com.chenlb.mmseg4j.analysis.MMSegTokenizer;
import com.chenlb.mmseg4j.solr.Utils;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.solr.analysis.BaseTokenizerFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MMSegTokenizerFactory
extends BaseTokenizerFactory
implements ResourceLoaderAware {
    static final Logger log = Logger.getLogger(MMSegTokenizerFactory.class.getName());
    private ThreadLocal<MMSegTokenizer> tokenizerLocal = new ThreadLocal();
    private Dictionary dic = null;

    private Seg newSeg(Map<String, String> map) {
        Seg seg = null;
        log.info("create new Seg ...");
        String string = map.get("mode");
        if ("simple".equals(string)) {
            log.info("use simple mode");
            seg = new SimpleSeg(this.dic);
        } else if ("complex".equals(string)) {
            log.info("use complex mode");
            seg = new ComplexSeg(this.dic);
        } else {
            log.info("use max-word mode");
            seg = new MaxWordSeg(this.dic);
        }
        return seg;
    }

    public Tokenizer create(Reader reader) {
        MMSegTokenizer mMSegTokenizer = this.tokenizerLocal.get();
        if (mMSegTokenizer == null) {
            mMSegTokenizer = this.newTokenizer(reader);
        } else {
            try {
                mMSegTokenizer.reset(reader);
            }
            catch (IOException iOException) {
                mMSegTokenizer = this.newTokenizer(reader);
                log.info("MMSegTokenizer.reset i/o error by:" + iOException.getMessage());
            }
        }
        return mMSegTokenizer;
    }

    private MMSegTokenizer newTokenizer(Reader reader) {
        MMSegTokenizer mMSegTokenizer = new MMSegTokenizer(this.newSeg(this.getArgs()), reader);
        this.tokenizerLocal.set(mMSegTokenizer);
        return mMSegTokenizer;
    }

    public void inform(ResourceLoader resourceLoader) {
        String string = (String)this.args.get("dicPath");
        this.dic = Utils.getDict(string, resourceLoader);
        log.info("dic load... in=" + this.dic.getDicPath().toURI());
    }
}

