/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.BlobInputStream;
import COM.ibm.db2.app.BlobOutputStream;
import COM.ibm.db2.app.BlobWithIO;
import COM.ibm.db2.app.Lob;
import java.io.InputStream;
import java.io.OutputStream;

class BlobWithDB2UDFLocator
extends Lob
implements BlobWithIO {
    int locator;

    BlobWithDB2UDFLocator(int n) throws Exception {
        this.locator = n;
    }

    public void close() {
        this.locator = 0;
    }

    void assertOpen() throws Exception {
        if (this.locator == 0) {
            throw new Exception("Blob is closed.");
        }
    }

    public long size() throws Exception {
        this.assertOpen();
        return BlobWithDB2UDFLocator.getSize(this.locator);
    }

    public InputStream getInputStream() throws Exception {
        return new BlobInputStream(this);
    }

    public OutputStream getOutputStream() throws Exception {
        return new BlobOutputStream(this);
    }

    public synchronized void append(byte[] byArray, int n, int n2) throws Exception {
        this.assertOpen();
        BlobWithDB2UDFLocator.doAppend(byArray, n, n2, this.locator);
    }

    public synchronized int substr(int n, byte[] byArray, int n2, int n3) throws Exception {
        this.assertOpen();
        int n4 = Math.min((int)this.size() - n, n3);
        BlobWithDB2UDFLocator.doSubstr(n, byArray, n2, n3, this.locator);
        return n4;
    }

    static native int getSize(int var0) throws Exception;

    static native void doAppend(byte[] var0, int var1, int var2, int var3) throws Exception;

    static native void doSubstr(int var0, byte[] var1, int var2, int var3, int var4) throws Exception;
}

