/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;

public class Cvs
extends Task {
    private Commandline cmd = new Commandline();
    private String cvsRoot;
    private String pack;
    private String command = "checkout";
    private boolean quiet = false;
    private boolean noexec = false;
    private File dest;
    private File output;
    private File error;

    public void execute() throws BuildException {
        OutputStream errorstream;
        block28: {
            Commandline toExecute = new Commandline();
            toExecute.setExecutable("cvs");
            if (this.cvsRoot != null) {
                toExecute.createArgument().setValue("-d");
                toExecute.createArgument().setValue(this.cvsRoot);
            }
            if (this.noexec) {
                toExecute.createArgument().setValue("-n");
            }
            if (this.quiet) {
                toExecute.createArgument().setValue("-q");
            }
            toExecute.createArgument().setLine(this.command);
            toExecute.addArguments(this.cmd.getCommandline());
            if (this.pack != null) {
                toExecute.createArgument().setLine(this.pack);
            }
            PumpStreamHandler streamhandler = null;
            OutputStream outputstream = null;
            errorstream = null;
            if (this.error == null && this.output == null) {
                streamhandler = new LogStreamHandler(this, 2, 1);
            } else {
                if (this.output != null) {
                    try {
                        outputstream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output)));
                    }
                    catch (IOException e) {
                        throw new BuildException(e, this.location);
                    }
                } else {
                    outputstream = new LogOutputStream(this, 2);
                }
                if (this.error != null) {
                    try {
                        errorstream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.error)));
                    }
                    catch (IOException e) {
                        throw new BuildException(e, this.location);
                    }
                } else {
                    errorstream = new LogOutputStream(this, 1);
                }
                streamhandler = new PumpStreamHandler(outputstream, errorstream);
            }
            Execute exe = new Execute(streamhandler, null);
            exe.setAntRun(this.project);
            if (this.dest == null) {
                this.dest = this.project.getBaseDir();
            }
            exe.setWorkingDirectory(this.dest);
            exe.setCommandline(toExecute.getCommandline());
            try {
                try {
                    exe.execute();
                }
                catch (IOException e) {
                    throw new BuildException(e, this.location);
                }
                Object var7_9 = null;
                if (this.output == null) break block28;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (this.output != null) {
                    try {
                        outputstream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.error != null) {
                    try {
                        errorstream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                outputstream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.error != null) {
            try {
                errorstream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void setCommand(String c) {
        this.command = c;
    }

    public void setCvsRoot(String root) {
        if (root != null && root.trim().equals("")) {
            root = null;
        }
        this.cvsRoot = root;
    }

    public void setDate(String p) {
        if (p != null && p.trim().length() > 0) {
            this.cmd.createArgument().setValue("-D");
            this.cmd.createArgument().setValue(p);
        }
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public void setError(File error) {
        this.error = error;
    }

    public void setNoexec(boolean ne) {
        this.noexec = ne;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setPackage(String p) {
        this.pack = p;
    }

    public void setQuiet(boolean q) {
        this.quiet = q;
    }

    public void setTag(String p) {
        if (p != null && p.trim().length() > 0) {
            this.cmd.createArgument().setValue("-r");
            this.cmd.createArgument().setValue(p);
        }
    }
}

