/*
 * Decompiled with CFR 0.152.
 */
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentGetObjectSample {
    private static String endpoint = "*** Provide OSS endpoint ***";
    private static String accessKeyId = "*** Provide your AccessKeyId ***";
    private static String accessKeySecret = "*** Provide your AccessKeySecret ***";
    private static OSSClient client = null;
    private static String bucketName = "*** Provide bucket name ***";
    private static String key = "*** Provide key ***";
    private static String localFilePath = "*** Provide local file path ***";
    private static ExecutorService executorService = Executors.newFixedThreadPool(5);
    private static AtomicInteger completedBlocks = new AtomicInteger(0);

    public static void main(String[] args) throws IOException {
        client = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        try {
            try {
                System.out.println("Uploading a new object to OSS from a file\n");
                client.putObject(new PutObjectRequest(bucketName, key, ConcurrentGetObjectSample.createSampleFile()));
                ObjectMetadata metadata = client.getObjectMetadata(bucketName, key);
                long objectSize = metadata.getContentLength();
                RandomAccessFile raf = new RandomAccessFile(localFilePath, "rw");
                raf.setLength(objectSize);
                raf.close();
                long blockSize = 0x500000L;
                int blockCount = (int)(objectSize / 0x500000L);
                if (objectSize % 0x500000L != 0L) {
                    ++blockCount;
                }
                System.out.println("Total blocks count " + blockCount + "\n");
                System.out.println("Start to download " + key + "\n");
                int i = 0;
                while (i < blockCount) {
                    long startPos = (long)i * 0x500000L;
                    long endPos = i + 1 == blockCount ? objectSize : (long)(i + 1) * 0x500000L;
                    executorService.execute(new BlockFetcher(startPos, endPos, i + 1));
                    ++i;
                }
                executorService.shutdown();
                while (!executorService.isTerminated()) {
                    try {
                        executorService.awaitTermination(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (completedBlocks.intValue() != blockCount) {
                    throw new IllegalStateException("Download fails due to some blocks are not finished yet");
                }
                System.out.println("Succeed to download object " + key);
            }
            catch (OSSException oe) {
                System.out.println("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
                System.out.println("Error Message: " + oe.getErrorCode());
                System.out.println("Error Code:       " + oe.getErrorCode());
                System.out.println("Request ID:      " + oe.getRequestId());
                System.out.println("Host ID:           " + oe.getHostId());
                if (client != null) {
                    client.shutdown();
                }
            }
            catch (ClientException ce) {
                System.out.println("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
                System.out.println("Error Message: " + ce.getMessage());
                if (client != null) {
                    client.shutdown();
                }
            }
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    private static File createSampleFile() throws IOException {
        File file = File.createTempFile("oss-java-sdk-", ".txt");
        file.deleteOnExit();
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
        int i = 0;
        while (i < 1000000) {
            writer.write("abcdefghijklmnopqrstuvwxyz\n");
            writer.write("0123456789011234567890\n");
            ++i;
        }
        ((Writer)writer).close();
        return file;
    }

    private static class BlockFetcher
    implements Runnable {
        private long startPos;
        private long endPos;
        private int blockNumber;

        public BlockFetcher(long startPos, long endPos, int blockNumber) {
            this.startPos = startPos;
            this.endPos = endPos;
            this.blockNumber = blockNumber;
        }

        @Override
        public void run() {
            block18: {
                RandomAccessFile raf = null;
                try {
                    try {
                        raf = new RandomAccessFile(localFilePath, "rw");
                        raf.seek(this.startPos);
                        OSSObject object = client.getObject(new GetObjectRequest(bucketName, key).withRange(this.startPos, this.endPos));
                        InputStream objectContent = object.getObjectContent();
                        try {
                            try {
                                byte[] buf = new byte[4096];
                                int bytesRead = 0;
                                while ((bytesRead = objectContent.read(buf)) != -1) {
                                    raf.write(buf, 0, bytesRead);
                                }
                                completedBlocks.incrementAndGet();
                                System.out.println("Block#" + this.blockNumber + " done\n");
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                objectContent.close();
                            }
                        }
                        finally {
                            objectContent.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (raf == null) break block18;
                        try {
                            raf.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    if (raf != null) {
                        try {
                            raf.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

