/*
 * Decompiled with CFR 0.152.
 */
package com.trs.devhelper;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class JsCombineFilter
implements Filter {
    private Logger logger = Logger.getLogger(JsCombineFilter.class);
    private HashMap resourceMap = new HashMap();
    private String m_sJsEncoding = "utf-8";

    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration enumNames = filterConfig.getInitParameterNames();
        while (enumNames.hasMoreElements()) {
            String sName = (String)enumNames.nextElement();
            String sValue = filterConfig.getInitParameter(sName);
            String[] aValue = sValue.split(",");
            this.resourceMap.put(sName, aValue);
            this.logger.debug((Object)"put jscombinefilter parameters");
            this.logger.debug((Object)(sName + ":" + sValue));
        }
    }

    private void outContent(String srcPath, StringBuffer out) throws Exception {
        FileService file = new FileService(srcPath);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            String fn = file.getAbsolutePath();
            if (fn.endsWith(".js")) {
                out.append("/**--");
                out.append(fn.replaceAll("\\\\", "/").replaceAll(".*/([^/]*.js)", "$1"));
                out.append("--**/\n");
                out.append(CMyFile.readFile(fn, this.m_sJsEncoding));
                out.append("\n");
            }
        } else {
            FileStore[] files = file.listFiles();
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    this.outContent(files[i].getAbsolutePath(), out);
                }
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String sUri = httpRequest.getRequestURI();
        String sPath = sUri.replaceAll("/[^/]*(/.*/)[^/]*.js", "$1");
        ServletContext application = httpRequest.getSession(true).getServletContext();
        httpResponse.setContentType("text/javascript:charset=utf-8");
        httpResponse.setCharacterEncoding("utf-8");
        int nIdx = sUri.lastIndexOf("/");
        String realPath = application.getRealPath(sPath);
        String sFileName = sUri.substring(nIdx + 1);
        String sFileNameWithoutExt = sFileName.replaceFirst("\\.[^\\.]*", "");
        String sFileExt = sFileName.replaceAll(".*\\.([^\\.]*)$", "$1");
        if (!sFileExt.equals("js")) {
            chain.doFilter(request, response);
            return;
        }
        if (sPath.endsWith("/app/js/data/opers/")) {
            this.doWithOpers(response, httpResponse, realPath, sFileName, sFileNameWithoutExt);
            return;
        }
        if (this.doWithResouceMapping(httpRequest, httpResponse)) {
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean doWithResouceMapping(HttpServletRequest request, HttpServletResponse response) {
        String sUri = request.getRequestURI();
        String sContextPath = request.getContextPath();
        String[] aFileName = (String[])this.resourceMap.get(sUri = sUri.substring(sContextPath.length()));
        if (aFileName == null || aFileName.length <= 0) {
            return false;
        }
        ServletContext application = request.getSession(true).getServletContext();
        int nIdx = sUri.lastIndexOf("/");
        String sFileName = sUri.substring(nIdx + 1);
        String realPath = application.getRealPath(sUri.substring(0, nIdx));
        StringBuffer outx = new StringBuffer();
        String sNewFile = null;
        try {
            for (int i = 0; i < aFileName.length; ++i) {
                String sTempFileName = realPath + File.separator + aFileName[i].trim();
                this.logger.debug((Object)("merge file:" + sTempFileName));
                this.outContent(sTempFileName, outx);
            }
            sNewFile = new FileService(realPath + "/../../../runtime/".replace('/', File.separatorChar) + sFileName).getAbsolutePath();
            this.logger.debug((Object)("write merged file:" + sNewFile));
            CMyFile.writeFile(sNewFile, outx.toString(), this.m_sJsEncoding);
            PrintWriter writer = response.getWriter();
            writer.println(outx.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void doWithAbsList(ServletResponse response, HttpServletResponse httpResponse, String realPath, String sFileName, String sFileNameWithoutExt) {
        response.setContentType("text/javascript;charset=utf-8");
        StringBuffer outx = new StringBuffer();
        String[] fileNames = new String[]{"PageContext.js", "BubblePannel.js", "PageLayout.js", "PageFilter.js", "PageGrid.js", "PageOper.js", "PageNav.js", "PageTab.js", "PageLiterator.js", "KeyProvider.js"};
        try {
            for (int i = 0; i < fileNames.length; ++i) {
                this.outContent(realPath + File.separator + fileNames[i], outx);
            }
            String sNewFile = new FileService(realPath + "/../../../runtime/".replace('/', File.separatorChar) + sFileName).getAbsolutePath();
            CMyFile.writeFile(sNewFile, outx.toString(), this.m_sJsEncoding);
            ServletOutputStream out = response.getOutputStream();
            out.println(outx.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doWithOpers(ServletResponse response, HttpServletResponse httpResponse, String realPath, String sFileName, String sFileNameWithoutExt) {
        response.setContentType("text/javascript;charset=utf-8");
        StringBuffer outx = new StringBuffer();
        try {
            this.outContent(realPath + File.separator + "../locale/" + sFileName, outx);
            this.outContent(realPath + File.separator + sFileName, outx);
            this.outContent(realPath + File.separator + sFileNameWithoutExt, outx);
            String sNewFile = new FileService(realPath + "/../../runtime/opers/".replace('/', File.separatorChar) + sFileName).getAbsolutePath();
            CMyFile.writeFile(sNewFile, outx.toString(), this.m_sJsEncoding);
            httpResponse.sendRedirect("../../runtime/opers/" + sFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
    }
}

