/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service.util;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MetaViewDataEditorContentAnalyzer {
    private static Logger logger = Logger.getLogger(MetaViewDataEditorContentAnalyzer.class);
    private List m_oFoundObj;
    private int m_nIndex = 0;
    private int m_nFoundCount = 0;
    private Pattern m_ignoreExp = Pattern.compile("(?im)<img[^>]*? (ignore=(\"|')1\\1)[^>]*>");
    private Pattern m_readImageExp = Pattern.compile("(?im)<img[^>]*? src=(\"|').*?read_image.jsp.*?\\1[^>]*>");
    private IMetaDataDefCacheMgr oMetaDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");

    public void analyze() throws WCMException {
        this.m_oFoundObj = new ArrayList();
        this.m_nIndex = 0;
        this.m_nFoundCount = 0;
        MetaViews oViews = MetaViews.createNewInstance(ContextHelper.getLoginUser());
        oViews.open(null);
        int nSize = oViews.size();
        for (int i = 0; i < nSize; ++i) {
            MetaView oView = (MetaView)oViews.getAt(i);
            if (oView == null) continue;
            this.analyze0(oView);
        }
        logger.info((Object)("\u603b\u8fc7\u5206\u6790\u3010" + this.m_nIndex + "\u3011\u6761\u8bb0\u5f55"));
        logger.info((Object)("\u5171\u53d1\u73b0\u9700\u8981\u5904\u7406\u7684\u6587\u6863\u603b\u6570:" + this.m_nFoundCount));
        this.printFoundRecords();
    }

    public void analyze(MetaView oView) throws WCMException {
        this.m_oFoundObj = new ArrayList();
        this.m_nIndex = 0;
        this.m_nFoundCount = 0;
        this.analyze0(oView);
        logger.info((Object)("\u603b\u8fc7\u5206\u6790\u3010" + this.m_nIndex + "\u3011\u6761\u8bb0\u5f55"));
        logger.info((Object)("\u5171\u53d1\u73b0\u9700\u8981\u5904\u7406\u7684\u6587\u6863\u603b\u6570:" + this.m_nFoundCount));
        this.printFoundRecords();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyze0(MetaView oView) throws WCMException {
        logger.info((Object)("\u5f00\u59cb\u5206\u6790\u89c6\u56fe:" + oView.getDesc()));
        Map oHtmlViewFields = this.oMetaDataDefCacheMgr.getMetaViewFields(oView.getId(), 12);
        String sTableName = oView.getTrueTableName();
        String sSQL = "select MetaDataId from " + sTableName;
        Connection conn = null;
        Statement statement = null;
        ResultSet records = null;
        try {
            conn = DBManager.getDBManager().getConnection();
            statement = conn.createStatement();
            records = statement.executeQuery(sSQL);
            while (records.next()) {
                int nMetaDataId = records.getInt(1);
                MetaViewData oViewData = MetaViewData.findById(nMetaDataId);
                this.analyze(oViewData, oHtmlViewFields);
                ++this.m_nIndex;
                if (this.m_nIndex % 50 != 0) continue;
                logger.info((Object)("\u5f00\u59cb\u5206\u6790\u7b2c\u3010" + this.m_nIndex + "\u3011\u6761\u8bb0\u5f55......"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (records != null) {
                try {
                    records.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (conn != null) {
                DBManager.getDBManager().freeConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeDocument() throws WCMException {
        this.m_oFoundObj = new ArrayList();
        this.m_nIndex = 0;
        this.m_nFoundCount = 0;
        String sSQL = "select docid from WCMDOCUMENT";
        Connection conn = null;
        Statement statement = null;
        ResultSet records = null;
        try {
            conn = DBManager.getDBManager().getConnection();
            statement = conn.createStatement();
            records = statement.executeQuery(sSQL);
            while (records.next()) {
                int nDocId = records.getInt(1);
                Document doc = Document.findById(nDocId);
                doc.setHtmlContent(this.analyze(doc, doc.getHtmlContent()));
                ++this.m_nIndex;
                if (this.m_nIndex % 50 != 0) continue;
                logger.info((Object)("\u5f00\u59cb\u5206\u6790\u7b2c\u3010" + this.m_nIndex + "\u3011\u6761\u8bb0\u5f55......"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (records != null) {
                try {
                    records.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (conn != null) {
                DBManager.getDBManager().freeConnection(conn);
            }
        }
        logger.info((Object)("\u603b\u8fc7\u5206\u6790\u3010" + this.m_nIndex + "\u3011\u6761\u8bb0\u5f55"));
        logger.info((Object)("\u5171\u53d1\u73b0\u9700\u8981\u5904\u7406\u7684\u6587\u6863\u603b\u6570:" + this.m_nFoundCount));
        this.printFoundRecords();
    }

    private void analyze(MetaViewData oViewData, Map oHtmlViewFields) throws WCMException {
        for (String sFieldName : oHtmlViewFields.keySet()) {
            String sFieldValue = oViewData.getPropertyAsString(sFieldName);
            if (CMyString.isEmpty(sFieldValue)) continue;
            oViewData.setPropertyWithString(sFieldName, this.analyze((BaseObj)oViewData, sFieldValue));
        }
    }

    private String analyze(BaseObj obj, String sHtmlContent) {
        Matcher matcher = this.m_readImageExp.matcher(sHtmlContent);
        boolean isFound = false;
        while (matcher.find()) {
            logger.info((Object)("\u627e\u5230read_image.jsp:" + matcher.group()));
            isFound = true;
        }
        if (isFound) {
            ++this.m_nFoundCount;
            this.m_oFoundObj.add(obj);
        }
        return sHtmlContent;
    }

    private void printFoundRecords() {
        logger.info((Object)"-------------------------");
        for (int i = 0; i < this.m_oFoundObj.size(); ++i) {
            BaseObj obj = (BaseObj)this.m_oFoundObj.get(i);
            logger.info((Object)obj.toString());
        }
    }
}

