/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.FlowingDocLogger;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.engine.FlowContext;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.process.element.FlowContentDocumentImpl;
import com.trs.infra.common.WCMException;

public class FlowingDocOptMarkScouter {
    public static final String FLOWING_DOC_OPT_MARK = "FLOWOPERATIONMARK";
    public static final String FLOWING_DOC_PRE_OPT_MARK = "FLOWPREOPERATIONMARK";
    public static final String FLOWING_DOC_OPT_MARK_ENUM = "FLOWOPERATIONMASKENUM";
    public static final String MARK_FORCE_END = "RESERVED_FORCED_END";
    public static final String IFLOWCONTENT_APPLYFORM_CLASSNAME = "com.trs.components.wcm.process.element.FlowContentApplyFormImpl";

    private FlowingDocOptMarkScouter() {
    }

    public static void updateOperationMark(FlowContext _context) throws WCMException {
        FlowingDocOptMarkScouter.updateOperationMark(_context, null, true);
    }

    public static void updateOperationMark(FlowContext _context, String _sPreOptValue) throws WCMException {
        FlowingDocOptMarkScouter.updateOperationMark(_context, _sPreOptValue, true);
    }

    private static void updateOperationMark(FlowContext _context, String _sPreOptValue, boolean _bOnCurrNodeMark) throws WCMException {
        IFlowContent content = _context.getFlowContent();
        if (content == null) {
            return;
        }
        FlowingDocLogger.info(_context, _sPreOptValue);
        if (content instanceof FlowContentDocumentImpl) {
            FlowingDocOptMarkScouter.saveDocumentOperationMark(_context, _sPreOptValue, content, _bOnCurrNodeMark);
        } else if (content.getClass().getName().equals(IFLOWCONTENT_APPLYFORM_CLASSNAME)) {
            FlowingDocOptMarkScouter.saveCMSObjOperationMark(_context, _sPreOptValue, content, _bOnCurrNodeMark);
        }
    }

    private static void saveDocumentOperationMark(FlowContext _context, String _sPreOptValue, IFlowContent content, boolean _bOnCurrNodeMark) throws WCMException {
        Flow currFlow;
        Document doc = ((FlowContentDocumentImpl)content).getDocument();
        if (doc == null) {
            return;
        }
        String sFieldValue = _sPreOptValue;
        if (_bOnCurrNodeMark) {
            if (sFieldValue == null) {
                FlowNodeBranch branch = _context.getBranch();
                if (branch == null || !branch.isOperationMarkEnable()) {
                    return;
                }
                sFieldValue = branch.getOperationMark();
            }
            if (sFieldValue == null) {
                return;
            }
        }
        boolean bNeedSave = false;
        Document doc2Save = Document.findById(doc.getId());
        User loginUser = ContextHelper.getLoginUser();
        if (_bOnCurrNodeMark) {
            if (doc2Save.getProperty(FLOWING_DOC_OPT_MARK) == null || doc2Save.getProperty(FLOWING_DOC_OPT_MARK) != null && !doc2Save.getProperty(FLOWING_DOC_OPT_MARK).equals(sFieldValue)) {
                bNeedSave = true;
                doc2Save.setProperty(FLOWING_DOC_OPT_MARK, sFieldValue);
            }
        } else if (doc2Save.getProperty(FLOWING_DOC_OPT_MARK) == null || doc2Save.getProperty(FLOWING_DOC_OPT_MARK) != null && !doc2Save.getProperty(FLOWING_DOC_OPT_MARK).equals(sFieldValue)) {
            bNeedSave = true;
            doc2Save.setProperty(FLOWING_DOC_PRE_OPT_MARK, sFieldValue);
        }
        if ((currFlow = _context.getCurrFlow()) != null && (doc2Save.getProperty(FLOWING_DOC_OPT_MARK_ENUM) == null || doc2Save.getProperty(FLOWING_DOC_OPT_MARK_ENUM) != null && !doc2Save.getProperty(FLOWING_DOC_OPT_MARK_ENUM).equals(currFlow.getProperty("OperationMarkEnum")))) {
            bNeedSave = true;
            doc2Save.setProperty(FLOWING_DOC_OPT_MARK_ENUM, currFlow.getProperty("OperationMarkEnum"));
        }
        if (bNeedSave && doc2Save.canEdit(loginUser)) {
            doc2Save.setEnableListener(false);
            doc2Save.save(loginUser);
            doc2Save.setEnableListener(true);
        }
    }

    private static void saveCMSObjOperationMark(FlowContext _context, String _sPreOptValue, IFlowContent content, boolean _bOnCurrNodeMark) throws WCMException {
        CMSObj oCMSObj = content.getSubinstance();
        if (oCMSObj == null) {
            return;
        }
        String sFieldValue = _sPreOptValue;
        if (_bOnCurrNodeMark) {
            if (sFieldValue == null) {
                FlowNodeBranch branch = _context.getBranch();
                if (branch == null || !branch.isOperationMarkEnable()) {
                    return;
                }
                sFieldValue = branch.getOperationMark();
            }
            if (sFieldValue == null) {
                return;
            }
        }
        CMSObj cmsObj2Save = (CMSObj)CMSObj.findById(oCMSObj.getWCMType(), oCMSObj.getId());
        User loginUser = ContextHelper.getLoginUser();
        cmsObj2Save.canEdit(loginUser);
        if (_bOnCurrNodeMark) {
            cmsObj2Save.setProperty(FLOWING_DOC_OPT_MARK, sFieldValue);
        } else {
            cmsObj2Save.setProperty(FLOWING_DOC_PRE_OPT_MARK, sFieldValue);
        }
        Flow currFlow = _context.getCurrFlow();
        if (currFlow != null) {
            cmsObj2Save.setProperty(FLOWING_DOC_OPT_MARK_ENUM, currFlow.getProperty("OperationMarkEnum"));
        }
        cmsObj2Save.save(loginUser);
    }

    public static void updatePreOperationMark(FlowContext _context, String _sPreOptValue) throws WCMException {
        if (_sPreOptValue == null) {
            return;
        }
        FlowingDocOptMarkScouter.updateOperationMark(_context, _sPreOptValue, false);
    }
}

