/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.StringHelper;
import com.trs.idm.util.UrlUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class RequestUtil {
    private static final Logger LOG = Logger.getLogger(RequestUtil.class);
    private static final String ORIGINAL_REMOTE_IP_ADDRESS_TOKEN_CLIENT_IP = "X-Client-IP";
    private static final String ORIGINAL_REMOTE_IP_ADDRESS_TOKEN_FORWARDED_FOR = "X-Forwarded-For";
    private static final String ORIGINAL_REMOTE_IP_ADDRESS_TOKEN_ORIGINALING_IP = "X-Originating-IP";

    public static int getParameterAsInt(HttpServletRequest request, String param) {
        return RequestUtil.getParameterAsInt(request, param, 0);
    }

    public static int getParameterAsPositiveInt(HttpServletRequest request, String param, int defaultValue) {
        int result = RequestUtil.getParameterAsInt(request, param, 0);
        if (result <= 0) {
            result = defaultValue;
        }
        if (result <= 0) {
            result = 15;
        }
        return result;
    }

    public static int getParameterAsInt(HttpServletRequest request, String param, int defaultValue) {
        String value = request.getParameter(param);
        try {
            return value == null || value.trim().length() == 0 ? defaultValue : Integer.parseInt(value);
        }
        catch (Exception e) {
            LOG.error((Object)(e + ", param=" + param + ", value=" + value + ". skip the exception and return " + defaultValue));
            return defaultValue;
        }
    }

    public static double getParameterAsDouble(HttpServletRequest request, String param, int defaultValue) {
        String value = request.getParameter(param);
        try {
            return value == null || value.trim().length() == 0 ? (double)defaultValue : Double.parseDouble(value);
        }
        catch (Exception e) {
            LOG.error((Object)(e + ", param=" + param + ", value=" + value + ". skip the exception and return " + defaultValue));
            return defaultValue;
        }
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String xForwardedFor = RequestUtil.getXForwardedFor(request);
        String remoteAddr = "";
        if (!StringHelper.isEmpty(xForwardedFor)) {
            remoteAddr = StringHelper.split(xForwardedFor, ",")[0];
        }
        return StringHelper.isEmpty(remoteAddr) ? request.getRemoteAddr() : remoteAddr;
    }

    public static String getRemoteAddr(HttpServletRequest request, String originalClientIPHttpHeaderToken) {
        return RequestUtil.getRemoteAddr(request);
    }

    public static int[] getParameterValuesAsInt(HttpServletRequest request, String param, int defaultValue) {
        String[] values = request.getParameterValues(param);
        if (values == null) {
            return new int[0];
        }
        int[] result = new int[values.length];
        int i = 0;
        while (i < values.length) {
            String value = values[i];
            try {
                result[i] = value == null || value.trim().length() == 0 ? defaultValue : Integer.parseInt(value);
            }
            catch (Exception e) {
                LOG.error((Object)(e + ", param=" + param + ", value=" + value + ". skip the exception and return " + defaultValue));
            }
            ++i;
        }
        return result;
    }

    public static String[] getParamterValuesAndTrim(HttpServletRequest request, String param) {
        String[] values = request.getParameterValues(param);
        if (values == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < values.length) {
            if (!StringHelper.isEmpty(values[i])) {
                result.add(values[i]);
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    public static boolean getParameterAsBool(HttpServletRequest request, String param) {
        return RequestUtil.getParameterAsBool(request, param, false);
    }

    public static boolean getParameterAsBool(HttpServletRequest request, String param, boolean defaultValue) {
        boolean result = defaultValue;
        if (request == null) {
            return result;
        }
        String paramValue = request.getParameter(param);
        if (!StringHelper.isEmpty(paramValue)) {
            result = "true".equalsIgnoreCase(paramValue);
        }
        return result;
    }

    public static String getParameterAsGBK(HttpServletRequest req, String param) {
        String result = req.getParameter(param);
        return result == null ? "" : result.trim();
    }

    public static String getParameterAndTrim(HttpServletRequest req, String param) {
        return RequestUtil.getParameterAndTrim(req, param, null);
    }

    public static String getParameterAndTrim(HttpServletRequest req, String param, String defaultValue) {
        String reslut = req.getParameter(param);
        if (StringHelper.isEmpty(reslut)) {
            reslut = defaultValue;
        }
        return reslut == null ? "" : reslut.trim();
    }

    public static String getParameterSafe(HttpServletRequest req, String param) {
        String result = RequestUtil.getParameterAndTrim(req, param);
        return StringHelper.filterXSS(result);
    }

    public static String getAttributeAsTrimStr(HttpServletRequest req, String attrName) {
        return RequestUtil.getAttributeAsTrimStr(req, attrName, "");
    }

    public static String getAttributeAsTrimStr(HttpServletRequest req, String attrName, String defValue) {
        Object obj = req.getAttribute(attrName);
        return obj != null ? obj.toString().trim() : defValue;
    }

    public static boolean existParameter(HttpServletRequest req, String param) {
        if (param == null) {
            return false;
        }
        return req.getParameter(param) != null;
    }

    public static String getFullGetStr(HttpServletRequest req) {
        String qryStr = req.getQueryString();
        if (qryStr == null) {
            return req.getRequestURL().toString();
        }
        return req.getRequestURL().append('?').append(qryStr).toString();
    }

    public static String getCurrentPage(HttpServletRequest req) {
        String requestURI = req.getRequestURI();
        return requestURI.substring(requestURI.lastIndexOf(47) + 1);
    }

    public static String getCurPageWithQryStr(HttpServletRequest req) {
        return RequestUtil.getCurPageWithQryStr(req, null);
    }

    public static String getCurPageWithQryStr(HttpServletRequest req, String excludeParam) {
        String qryStr = RequestUtil.removeQryParam(req.getQueryString(), excludeParam);
        if (qryStr == null) {
            return RequestUtil.getCurrentPage(req);
        }
        return new StringBuffer(RequestUtil.getCurrentPage(req)).append('?').append(qryStr).toString();
    }

    public static String removeQryParamOfURI(String hrefWithParam, String excludeParam) {
        if (StringHelper.isEmpty(hrefWithParam)) {
            return "";
        }
        if (StringHelper.isEmpty(excludeParam)) {
            return hrefWithParam;
        }
        if (StringHelper.split(hrefWithParam, "?").length != 2) {
            return hrefWithParam;
        }
        if (hrefWithParam.indexOf(excludeParam) < 0) {
            return hrefWithParam;
        }
        String link = hrefWithParam.substring(0, hrefWithParam.indexOf("?"));
        String queryString = hrefWithParam.substring(hrefWithParam.indexOf("?") + 1, hrefWithParam.length());
        String excludedQueryString = RequestUtil.removeQryParam(queryString, excludeParam);
        if (!StringHelper.isEmpty(excludedQueryString)) {
            link = String.valueOf(link) + "?" + excludedQueryString;
        }
        return link;
    }

    public static String getCurPageWithQryStr(HttpServletRequest req, String param, String excludeParam) {
        Map qryStrMap;
        String qryStr = RequestUtil.removeQryParam(req.getQueryString(), param);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (!StringHelper.isEmpty(qryStr) && (qryStrMap = StringHelper.String2Map(qryStr, "&", "=")) != null) {
            for (String key : qryStrMap.keySet()) {
                if (key.equals(excludeParam)) continue;
                String value = (String)qryStrMap.get(key);
                resultMap.put(key, value);
            }
        }
        if (resultMap.size() > 0) {
            qryStr = StringHelper.Map2String(resultMap, "&", "=");
        }
        if (qryStr == null) {
            return RequestUtil.getCurrentPage(req);
        }
        return new StringBuffer(RequestUtil.getCurrentPage(req)).append('?').append(qryStr).toString();
    }

    public static String removeQryParam(String qryStr, String param) {
        if (qryStr == null || param == null) {
            return qryStr;
        }
        String[] params = StringHelper.split(qryStr, "&");
        StringBuffer sb = new StringBuffer(qryStr.length());
        int i = 0;
        while (i < params.length) {
            if (!params[i].startsWith(String.valueOf(param) + "=")) {
                sb.append(params[i]).append('&');
            }
            ++i;
        }
        return sb.length() > 0 ? sb.deleteCharAt(sb.length() - 1).toString() : null;
    }

    public static String addQryParam(String qryStr, String param) {
        if (qryStr == null || param == null) {
            return qryStr;
        }
        if (qryStr.indexOf(63) == -1 && qryStr.indexOf(61) == -1) {
            return String.valueOf(qryStr) + '?' + param;
        }
        if (qryStr.endsWith("?")) {
            qryStr = qryStr.substring(0, qryStr.indexOf(63));
        }
        return String.valueOf(qryStr) + (qryStr.indexOf(63) >= 0 ? (char)'&' : '?') + param;
    }

    public static String getRequestInfo(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(320);
        sb.append("[Req]");
        sb.append(req.getClass().getName());
        sb.append(": (").append(req.getScheme()).append(')').append(req.getServerName()).append(':').append(req.getServerPort());
        sb.append(", ").append(req.getMethod()).append(' ').append(req.getProtocol());
        sb.append(", uri=").append(req.getRequestURI());
        sb.append(", ctx=").append(req.getContextPath());
        sb.append(", servlet=").append(req.getServletPath());
        sb.append(", qryStr=").append(req.getQueryString());
        sb.append(", refer=").append(req.getHeader("referer"));
        sb.append(", useragt=").append(req.getHeader("user-agent"));
        sb.append(", ip=").append(req.getRemoteAddr());
        sb.append(", clientIP=").append(req.getHeader(ORIGINAL_REMOTE_IP_ADDRESS_TOKEN_CLIENT_IP));
        sb.append(", encoding=").append(req.getCharacterEncoding());
        return sb.toString();
    }

    public static String getAllHeadersStr(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(256);
        String header = null;
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            header = (String)headers.nextElement();
            sb.append(header);
            sb.append("=");
            sb.append(req.getHeader(header));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static String getUserAgentAndCookies(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("user-agent").append('=').append(req.getHeader("user-agent")).append(';');
        sb.append("trs-ids-cmd").append('=').append(req.getHeader("trs-ids-cmd")).append('\n');
        sb.append("cookies: ");
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                sb.append(cookies[i].getName()).append('=').append(cookies[i].getValue());
                sb.append(';');
                ++i;
            }
        }
        return sb.toString();
    }

    public static String getUserAgent(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        String userAgent = request.getHeader("user-agent");
        if (StringHelper.isEmpty(userAgent)) {
            return "";
        }
        return userAgent;
    }

    public static String getReferUrl(HttpServletRequest req) {
        String referUrl = req.getHeader("referer");
        return referUrl == null ? "" : referUrl;
    }

    public static int getPageUriPosInRequest(HttpServletRequest req, String someUri) {
        if (someUri == null || someUri.trim().length() == 0) {
            return -2;
        }
        return RequestUtil.getRelativePath(req).indexOf(someUri);
    }

    public static String getContextRoot(HttpServletRequest request, String originalHostHttpHeader) {
        String sysUrl = RequestUtil.getOriginalHost(request, originalHostHttpHeader);
        if (StringHelper.isEmpty(sysUrl)) {
            sysUrl = request.getRequestURL().toString();
        }
        if (sysUrl.indexOf(request.getServletPath()) == -1) {
            return String.valueOf(request.getScheme()) + "://" + sysUrl + request.getContextPath();
        }
        return sysUrl.substring(0, sysUrl.indexOf(request.getServletPath()));
    }

    public static String getContextRoot(HttpServletRequest request) {
        return RequestUtil.getContextRoot(request, null);
    }

    public static String getRelativePath(HttpServletRequest req) {
        return req.getRequestURI().substring(req.getContextPath().length());
    }

    public static String getServletContainerInfo(ServletContext application) {
        StringBuffer sb = new StringBuffer(64);
        sb.append(application.getServerInfo());
        sb.append(" (Servlet ").append(application.getMajorVersion()).append('.').append(application.getMinorVersion()).append(')');
        return sb.toString();
    }

    public static void log(Object obj, HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(new Timestamp(System.currentTimeMillis()));
        if (req != null) {
            sb.append('\t').append(req.getRequestURI());
        }
        sb.append('\t').append(obj);
        System.out.println(sb);
    }

    public static void log(HttpServletRequest req) {
        RequestUtil.log(RequestUtil.getRequestInfo(req), null);
    }

    public static Map getAllParameters(HttpServletRequest req) {
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String key = (String)params.nextElement();
            String value = req.getParameter(key);
            if (value == null) continue;
            parameters.put(key, value);
        }
        return parameters;
    }

    protected static Map getGetParametersAsMap(String queryString) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StringHelper.isEmpty(queryString)) {
            LOG.debug((Object)"queryString is null, return empty parameters");
            return parameters;
        }
        try {
            String[] parametersAsStringArray = StringHelper.split(queryString, "&");
            int i = 0;
            while (i < parametersAsStringArray.length) {
                String parameterString = parametersAsStringArray[i];
                String[] keyValues = StringHelper.splitAtFirstToken(parameterString, "=");
                parameters.put(keyValues[0], keyValues[1]);
                ++i;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("get GetParam fail, origal queryString from HttpRequest: " + queryString), (Throwable)e);
            return new HashMap();
        }
        return parameters;
    }

    public static Map getGetParametersAsMap(HttpServletRequest request) {
        return RequestUtil.getGetParametersAsMap(request.getQueryString());
    }

    public static String getGetParametersAsString(HttpServletRequest request) {
        return request.getQueryString();
    }

    public static Map getPostParametersAsMap(HttpServletRequest request) {
        Map allParameters = RequestUtil.getAllParameters(request);
        Map getParameters = RequestUtil.getGetParametersAsMap(request.getQueryString());
        return RequestUtil.getPostParametersAsMap(allParameters, getParameters);
    }

    public static String getPostParametersAsString(HttpServletRequest request) {
        Map allParameters = RequestUtil.getAllParameters(request);
        Map getParameters = RequestUtil.getGetParametersAsMap(request.getQueryString());
        return RequestUtil.getPostParametersAsString(allParameters, getParameters);
    }

    protected static Map getPostParametersAsMap(Map allParameters, Map getParameters) {
        if (allParameters == null || allParameters.size() == 0) {
            return new HashMap();
        }
        if (getParameters == null || getParameters.size() == 0) {
            return allParameters;
        }
        HashMap<String, String> postParameters = new HashMap<String, String>();
        for (Map.Entry entry : allParameters.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (getParameters.containsKey(key)) continue;
            postParameters.put(key, value);
        }
        return postParameters;
    }

    protected static String getPostParametersAsString(Map allParameters, Map getParameters) {
        Map postParameters = RequestUtil.getPostParametersAsMap(allParameters, getParameters);
        if (postParameters.size() == 0) {
            return null;
        }
        StringBuffer strBuff = new StringBuffer();
        Iterator it = postParameters.entrySet().iterator();
        int counter = 0;
        int mapSize = postParameters.size();
        while (it.hasNext()) {
            ++counter;
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            strBuff.append(key);
            strBuff.append("=");
            strBuff.append(value);
            if (counter >= mapSize) continue;
            strBuff.append("&");
        }
        return strBuff.toString();
    }

    public static String concatURL(String head, String tail) {
        if (StringHelper.isEmpty(head) && StringHelper.isEmpty(tail)) {
            return "";
        }
        if (StringHelper.isEmpty(head)) {
            return tail;
        }
        if (StringHelper.isEmpty(tail)) {
            return head;
        }
        if (head.endsWith("/") && tail.startsWith("/")) {
            return String.valueOf(head) + tail.substring(1);
        }
        if (head.endsWith("/") || tail.startsWith("/")) {
            return String.valueOf(head) + tail;
        }
        return String.valueOf(head) + "/" + tail;
    }

    public static String getAppBaseURL(HttpServletRequest request) {
        return RequestUtil.getContextRoot(request);
    }

    public static String getParameterIndirect(HttpServletRequest request, String paramName) {
        return RequestUtil.getParameterIndirect(request, paramName, null);
    }

    public static String getParameterIndirect(HttpServletRequest request, String paramName, String defaultValue) {
        String returnValue = RequestUtil.getParameterIndirectInternal(request.getQueryString(), paramName);
        if (!StringHelper.isEmpty(returnValue)) {
            return returnValue;
        }
        if (!StringHelper.isEmpty(defaultValue)) {
            return defaultValue;
        }
        return null;
    }

    protected static String getParameterIndirectInternal(String queryString, String paramName) {
        if (StringHelper.isEmpty(queryString)) {
            return null;
        }
        Map parameters = StringHelper.String2Map(queryString, "&", "=");
        if (parameters == null || parameters.size() == 0) {
            return null;
        }
        return (String)parameters.get(paramName);
    }

    public static boolean isMultipartRequest(HttpServletRequest req) {
        String type = null;
        String type1 = req.getHeader("Content-Type");
        String type2 = req.getContentType();
        if (type1 == null && type2 != null) {
            type = type2;
        } else if (type2 == null && type1 != null) {
            type = type1;
        } else if (type1 != null && type2 != null) {
            String string = type = type1.length() > type2.length() ? type1 : type2;
        }
        return type != null && type.toLowerCase().startsWith("multipart/form-data");
    }

    public static boolean isReverseProxyRequest(HttpServletRequest request, String originalHostHttpHeader) {
        if (StringHelper.isEmpty(originalHostHttpHeader)) {
            return false;
        }
        String originalHost = RequestUtil.getXForwardedHost(request);
        LOG.debug((Object)("request.getRequestURL(): " + request.getRequestURL() + "; originalHostHttpHeader: " + originalHostHttpHeader + "; originalHost in request: " + originalHost));
        if (StringHelper.isEmpty(originalHost)) {
            LOG.debug((Object)("request.getRequestURL(): " + request.getRequestURL() + "; Can not get value http header[" + originalHostHttpHeader + "], configuration of trsids-agent.properties or Reverse Proxy might be error."));
            return false;
        }
        return true;
    }

    public static String getOriginalHost(HttpServletRequest request, String originalHostHttpHeader) {
        return RequestUtil.getOriginalHost(request);
    }

    public static String getOriginalHost(HttpServletRequest request) {
        String xForwardedHostName = (String)request.getAttribute("XForwardedHost-Name");
        if (StringHelper.isEmpty(xForwardedHostName)) {
            xForwardedHostName = request.getHeader("XForwardedHost-Name");
        }
        if (StringHelper.isEmpty(xForwardedHostName)) {
            return request.getRequestURL().toString();
        }
        String xForwardedHost = request.getHeader(xForwardedHostName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request.getRequestURL(): " + request.getRequestURL() + "; OriginalHostHttpHeader: " + xForwardedHostName + "; originalHost in request: " + xForwardedHost));
        }
        if (StringHelper.isEmpty(xForwardedHost)) {
            return request.getRequestURL().toString();
        }
        String originalHost = StringHelper.splitAndTrim(xForwardedHost, ",")[0];
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("After split from comma: " + xForwardedHost + "; originalHosts[0]: " + originalHost));
        }
        return originalHost;
    }

    public static String getOriginalUrlWithParam(HttpServletRequest request, String originalHostHttpHeader) {
        if (!RequestUtil.isReverseProxyRequest(request, originalHostHttpHeader)) {
            String fullGetUrl = RequestUtil.getFullGetStr(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("originalHostHttpHeader is null, may be not configure, so return request.getFullGetStr(request):" + fullGetUrl));
            }
            return fullGetUrl;
        }
        String originalHostBeforeReverseProxy = RequestUtil.getOriginalHost(request, originalHostHttpHeader);
        String requestURI = request.getRequestURI();
        String queryString = request.getQueryString();
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("http://");
        strBuffer.append(originalHostBeforeReverseProxy);
        if (!StringHelper.isEmpty(requestURI)) {
            strBuffer.append(requestURI);
        }
        if (!StringHelper.isEmpty(queryString)) {
            strBuffer.append("?").append(queryString);
        }
        String returnUrl = strBuffer.toString();
        LOG.debug((Object)("originalHostBeforeReverseProxy: " + originalHostBeforeReverseProxy + "; requestURI: " + requestURI + "; queryString: " + queryString));
        return returnUrl;
    }

    public static String getCurrentRequestURLWithPara(HttpServletRequest req) {
        StringBuffer fullRequestURL = new StringBuffer("");
        fullRequestURL.append(req.getRequestURI());
        String queryString = req.getQueryString();
        if (!StringHelper.isEmpty(queryString)) {
            fullRequestURL.append("?").append(queryString);
        }
        return fullRequestURL.toString();
    }

    public static String getRelativePathWithPara(HttpServletRequest req) {
        StringBuffer relativePathWithPara = new StringBuffer("");
        relativePathWithPara.append(RequestUtil.getRelativePath(req));
        String queryString = req.getQueryString();
        if (!StringHelper.isEmpty(queryString)) {
            relativePathWithPara.append("?").append(queryString);
        }
        return relativePathWithPara.toString();
    }

    public static String[] getCheckBoxValues(HttpServletRequest request, String param) {
        String[] values = request.getParameterValues(param);
        if (values == null) {
            values = new String[]{};
        }
        return values;
    }

    public static String getRequestBody(HttpServletRequest request) {
        ServletInputStream isr = null;
        try {
            isr = request.getInputStream();
            String string = RequestUtil.getBody((InputStream)isr, false);
            return string;
        }
        catch (Throwable e) {
            LOG.error((Object)("failed to get requestBody from request[" + request + "]"), e);
        }
        finally {
            try {
                isr.close();
            }
            catch (Throwable e) {
                LOG.error((Object)("failed to close isr[" + isr + "]"), e);
            }
        }
        return "";
    }

    public static String getBody(InputStream isr, boolean closeInputStream) {
        BufferedReader br = null;
        try {
            StringBuffer requestBody = new StringBuffer("");
            br = new BufferedReader(new InputStreamReader(isr));
            String lineText = null;
            while ((lineText = br.readLine()) != null) {
                requestBody.append(lineText);
            }
            String string = requestBody.toString();
            return string;
        }
        catch (Throwable e) {
            LOG.error((Object)("failed to getRequestBody from inputStream [" + isr + "] ."), e);
        }
        finally {
            try {
                br.close();
                if (closeInputStream) {
                    isr.close();
                }
            }
            catch (Throwable e) {
                LOG.error((Object)("failed to close br [" + br + "] or isr [" + isr + "]."), e);
            }
        }
        return "";
    }

    public static final String getClientIP(HttpServletRequest request) {
        return RequestUtil.getRemoteAddr(request);
    }

    public static String getXForwardedFor(HttpServletRequest request) {
        String xForwardedFor = "";
        String xForwardedForName = (String)request.getAttribute("XForwardedFor-Name");
        if (StringHelper.isEmpty(xForwardedForName)) {
            xForwardedForName = request.getHeader("XForwardedFor-Name");
        }
        if (!StringHelper.isEmpty(xForwardedForName)) {
            xForwardedFor = request.getHeader(xForwardedForName);
        }
        return xForwardedFor;
    }

    public static String getXForwardedHost(HttpServletRequest request) {
        String xForwardedHost = "";
        String xForwardedHostName = (String)request.getAttribute("XForwardedHost-Name");
        if (StringHelper.isEmpty(xForwardedHostName)) {
            xForwardedHostName = request.getHeader("XForwardedHost-Name");
        }
        if (!StringHelper.isEmpty(xForwardedHostName)) {
            xForwardedHost = request.getHeader(xForwardedHostName);
        }
        return xForwardedHost;
    }

    public static String getServerName(HttpServletRequest request) {
        String xForwardedHost = RequestUtil.getXForwardedHost(request);
        String serverName = "";
        if (!StringHelper.isEmpty(xForwardedHost)) {
            serverName = StringHelper.split(StringHelper.split(xForwardedHost, ",")[0], ":")[0];
        }
        return StringHelper.isEmpty(serverName) ? request.getServerName() : serverName;
    }

    public static final String getRealPath(HttpServletRequest request) {
        String realPath = request.getSession().getServletContext().getRealPath("/");
        if (!realPath.endsWith(File.separator)) {
            realPath = String.valueOf(realPath) + File.separator;
        }
        return realPath;
    }

    private static boolean isSecureRedirectUrl(HttpServletRequest request, String toRedirectUrl, String serverName) {
        String host = UrlUtil.getDomainByLevelFromUrl(toRedirectUrl, 10);
        if (!StringHelper.isEmpty(host) && !StringHelper.isEmpty(serverName)) {
            return host.contains(serverName);
        }
        String xFforwardedHost = request.getHeader("x-forwarded-host");
        String actualServerName = "";
        if (StringHelper.isEmpty(xFforwardedHost)) {
            actualServerName = request.getServerName();
        } else {
            String[] serverNamesByProxy = StringHelper.split(xFforwardedHost, ",");
            actualServerName = serverNamesByProxy[serverNamesByProxy.length - 1];
        }
        return toRedirectUrl.contains(actualServerName);
    }

    private static boolean isSecureRedirectUrl(HttpServletRequest request, String toRedirectUrl, String[] serverNames) {
        if (serverNames != null && serverNames.length > 0) {
            int i = 0;
            while (i < serverNames.length) {
                String serverName = serverNames[i];
                if (RequestUtil.isSecureRedirectUrl(request, toRedirectUrl, serverName)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return RequestUtil.isSecureRedirectUrl(request, toRedirectUrl, "");
    }

    public static void sendRedirectSecure(HttpServletRequest request, HttpServletResponse response, String toRedirectUrl, String[] serverNames, boolean actualRedirect) throws IOException {
        if (!actualRedirect) {
            response.sendRedirect(toRedirectUrl);
            return;
        }
        if (StringHelper.isEmpty(toRedirectUrl)) {
            return;
        }
        boolean isSecureRedirectUrl = RequestUtil.isSecureRedirectUrl(request, toRedirectUrl, serverNames);
        if (isSecureRedirectUrl) {
            response.sendRedirect(toRedirectUrl);
        } else {
            StringBuilder redirectInfo = new StringBuilder();
            redirectInfo.append("\u60a8\u5373\u5c06\u79bb\u5f00\u5f53\u524d\u7ad9\u70b9\uff0c\u5982\u679c\u786e\u8ba4\u4ee5\u4e0b\u7f51\u5740\u662f\u5b89\u5168\u7684\u5730\u5740\uff0c\u8bf7\u70b9\u51fb\u94fe\u63a5\u8fdb\u884c\u8df3\u8f6c\uff1a<br> <a href=\"" + StringHelper.filterXSS(toRedirectUrl) + "\">" + StringHelper.filterXSS(toRedirectUrl) + "</a>");
            RequestUtil.outPrintMessage(response, redirectInfo.toString());
        }
    }

    public static void outPrintMessage(HttpServletResponse response, String htmlMessage) throws IOException {
        response.setContentType("text/html; charset=GBK");
        PrintWriter pw = response.getWriter();
        StringBuffer sb = new StringBuffer(256);
        sb.append("<HTML><HEAD><TITLE>TRS\u8eab\u4efd\u670d\u52a1\u5668\u63d0\u793a\u4fe1\u606f</TITLE><body>");
        sb.append(htmlMessage);
        pw.println(sb);
        pw.println("</body></html>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ForwardedIPHeader {
        X_ORIGINAL_IP("X-Originating-IP"),
        X_CLIENT_IP("X-Client-IP"),
        X_ORWARDED_FOR("X-Forwarded-For");

        String name;

        private ForwardedIPHeader(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

