/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.view;

import com.trs.dev4.jdk16.dao.PagedList;
import com.trs.dev4.jdk16.servlet24.RequestUtil;
import com.trs.dev4.jdk16.utils.UrlUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OutlinePageHelper {
    private static final Logger logger = Logger.getLogger(OutlinePageHelper.class);
    private static final String DEFAULT_PAGENO_PARAMNAME = "pn";
    private static final int DEFAULT_PAGESIZE = 20;
    private String paramPageNo;
    private int pageSize;
    private HttpServletRequest request;
    private String clientRequestURL;
    private PagedList<? extends Object> pagedList;
    private String pagedAttributeName = "";

    public OutlinePageHelper(HttpServletRequest request) {
        this.request = request;
        this.pagedAttributeName = "articles";
        this.init(this.paramPageNo, 20);
    }

    public OutlinePageHelper(HttpServletRequest request, String pagedAttributeName) {
        this.request = request;
        this.pagedAttributeName = pagedAttributeName;
        this.init(this.paramPageNo, 20);
    }

    public int getCurrentPage() {
        return RequestUtil.getParameterAsInt(this.request, this.paramPageNo);
    }

    public String getPageLink(int pageIndex) {
        return UrlUtil.addOrReplaceParam(this.clientRequestURL, this.paramPageNo, pageIndex);
    }

    public String getPrevPageLink() {
        return UrlUtil.addOrReplaceParam(this.clientRequestURL, this.paramPageNo, this.pagedList.getPrevPage());
    }

    public String getNextPageLink() {
        return UrlUtil.addOrReplaceParam(this.clientRequestURL, this.paramPageNo, this.pagedList.getNextPage());
    }

    public String getFirstPageLink() {
        return UrlUtil.addOrReplaceParam(this.clientRequestURL, this.paramPageNo, this.pagedList.getFirstPageNo());
    }

    public String getLastPageLink() {
        return UrlUtil.addOrReplaceParam(this.clientRequestURL, this.paramPageNo, this.pagedList.getLastPageNo());
    }

    public String getClientRequestURL() {
        return this.clientRequestURL;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    OutlinePageHelper(HttpServletRequest request, String paramName, int pageSize) {
        this.request = request;
        this.init(paramName, pageSize);
    }

    private void init(String paramName, int pageSize) {
        this.paramPageNo = paramName == null || paramName.isEmpty() ? DEFAULT_PAGENO_PARAMNAME : paramName;
        this.pageSize = pageSize < 1 ? 20 : pageSize;
        this.pagedList = (PagedList)this.request.getAttribute(this.pagedAttributeName);
        this.clientRequestURL = RequestUtil.getClientRequestURL(this.request);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("clientRequestURL:" + this.clientRequestURL + ",pagedAttributeName:" + this.pagedAttributeName + ",paramPageNo:" + this.paramPageNo + ",pageSize:" + pageSize));
        }
    }

    public PagedList<? extends Object> getOutlineResult() {
        return this.pagedList;
    }
}

