/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.view.controller.mission;

import com.trs.cis4.gateway.bean.AgentConfig;
import com.trs.cis4.gateway.helper.ConfigHelper;
import com.trs.cis4.gateway.view.controller.base.Simple_Form_Controller;
import com.trs.cis4.gateway.view.form.UploadForm;
import com.trs.cis4.gateway.view.util.MissionValidate;
import com.trs.cis4.util.ExceptionUtil;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.web.servlet.ModelAndView;

public class Mission_Upload_Controller
extends Simple_Form_Controller {
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws ServletException {
        binder.registerCustomEditor(byte[].class, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    public ModelAndView _onSubmit(HttpServletRequest request, HttpServletResponse response, Object cmd, BindException errors) throws Exception {
        UploadForm form = (UploadForm)cmd;
        String content = this.getContentFromUploadFile(form, request);
        List<AgentConfig> aconfigList = ConfigHelper.stringToObjects(content);
        List<AgentConfig> agentconfigs = super.getConfigLogic().getConfig();
        ArrayList<AgentConfig> addAgentConfigs = new ArrayList<AgentConfig>();
        String notAddAgentConfigName = "";
        if (aconfigList != null) {
            for (AgentConfig agent1 : aconfigList) {
                String task_name1 = agent1.getTask_name();
                if (task_name1.equals("")) {
                    notAddAgentConfigName = String.valueOf(notAddAgentConfigName) + "\u3010 \u5b58\u5728\u4efb\u52a1\u540d\u4e3a\u7a7a\u7684\u60c5\u51b5 \u3011";
                    continue;
                }
                int notrepeate = 0;
                for (AgentConfig agent2 : agentconfigs) {
                    String task_name2 = agent2.getTask_name();
                    if (!task_name1.equalsIgnoreCase(task_name2)) continue;
                    notAddAgentConfigName = String.valueOf(notAddAgentConfigName) + " [" + task_name1 + "] ";
                    ++notrepeate;
                }
                if (notrepeate != 0) continue;
                addAgentConfigs.add(agent1);
            }
            for (AgentConfig config : addAgentConfigs) {
                try {
                    MissionValidate.validateMission(config);
                    super.getConfigLogic().add(config);
                }
                catch (Exception e) {
                    this.log.error((Object)e.getLocalizedMessage());
                    throw new ExceptionUtil(1, "\u521b\u5efa\u4efb\u52a1\u5f02\u5e38\uff01", "<br>" + e.getLocalizedMessage());
                }
            }
            if (!"".equals(notAddAgentConfigName)) {
                throw new ExceptionUtil(1, "\u90e8\u5206\u4efb\u52a1\u540d\u5df2\u7ecf\u5b58\u5728\uff01", String.valueOf(notAddAgentConfigName) + "\u4efb\u52a1\u5728\u4efb\u52a1\u5217\u8868\u4e2d\u5df2\u7ecf\u5b58\u5728\uff0c\u8be5\u90e8\u5206\u4efb\u52a1\u6dfb\u52a0\u5931\u8d25\uff01");
            }
        } else {
            this.log.info((Object)"\u4e0a\u4f20\u6587\u4ef6\u5185\u5bb9\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u65e0\u6cd5\u751f\u6210\u4efb\u52a1\uff01");
            throw new ExceptionUtil(1, "\u6587\u4ef6\u5185\u5bb9\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u65e0\u6cd5\u751f\u6210\u4efb\u52a1\uff01");
        }
        return new ModelAndView(this.getSuccessView());
    }

    private String getContentFromUploadFile(UploadForm form, HttpServletRequest request) throws IOException {
        byte[] bytes = form.getFile();
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        return new String(bytes, "GBK");
    }

    public Object _formBackingObject(HttpServletRequest request) throws Exception {
        return new UploadForm();
    }
}

