/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.logic.impl;

import com.trs.cis4.gateway.bean.AgentConfig;
import com.trs.cis4.gateway.bean.DbParams;
import com.trs.cis4.gateway.bean.DbStatus;
import com.trs.cis4.gateway.bean.FieldData;
import com.trs.cis4.gateway.bean.FieldData2;
import com.trs.cis4.gateway.bean.FtpConfig;
import com.trs.cis4.gateway.bean.LogConfig;
import com.trs.cis4.gateway.bean.LogData;
import com.trs.cis4.gateway.bean.MachineData;
import com.trs.cis4.gateway.bean.TaskStatus;
import com.trs.cis4.gateway.helper.ConfigHelper;
import com.trs.cis4.gateway.logic.IBaseConfigLogic;
import com.trs.cis4.gateway.logic.impl.BaseLogicImpl;
import com.trs.cis4.gateway.logic.util.RobotLogicUtils;
import com.trs.cis4.util.DateTimeUtil;
import com.trs.cis4.util.ExceptionUtil;
import com.trs.cis4.util.GenerateUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseConfigLogicImpl
extends BaseLogicImpl
implements IBaseConfigLogic {
    private Logger log = Logger.getLogger(this.getClass());

    @Override
    public boolean checkBkserver(DbParams dbParams) throws ExceptionUtil {
        return this.robotDAO.checkBkserver(dbParams) == 0;
    }

    @Override
    public boolean checkRegex(String regexStr, String content) throws ExceptionUtil {
        return this.robotDAO.checkRegex(regexStr, content) == 0;
    }

    @Override
    public boolean createFolder(String folder) throws ExceptionUtil {
        return this.robotDAO.createFolder(folder) == 0;
    }

    @Override
    public String createTrsDatabase(DbParams dbParams, List<FieldData2> fList) throws ExceptionUtil {
        return this.robotDAO.createTrsDatabase(dbParams, fList);
    }

    @Override
    public List<String> getDatabase(DbParams dbParams) throws ExceptionUtil {
        return this._arrToList(this.robotDAO.getDatabase(dbParams));
    }

    @Override
    public DbStatus getLoadedRdb() throws ExceptionUtil {
        try {
            if (this.checkMachineCode()) {
                return this.getDbStatus(this.robotDAO.getLoadedRdb());
            }
        }
        catch (ExceptionUtil e) {
            this.log.error((Object)e.getLocalizedMessage());
        }
        return this.getDbStatus(null);
    }

    @Override
    public LogConfig getLogConfig() throws ExceptionUtil {
        String[] bean = this.robotDAO.getLogConfig();
        LogConfig logConfig = new LogConfig();
        logConfig.setLog_size(new Integer(bean[0]));
        logConfig.setBak_span(new Integer(bean[1]));
        logConfig.setBak_count(new Integer(bean[2]));
        logConfig.setLog_type(new Integer(bean[3]));
        logConfig.setOutput_type(new Integer(bean[4]));
        return logConfig;
    }

    @Override
    public List<LogData> getLogNow() throws ExceptionUtil {
        boolean test = false;
        if (test) {
            return this.getTestData();
        }
        String[] bean = this.robotDAO.getLogNow();
        if (bean == null) {
            return null;
        }
        ArrayList<LogData> list = new ArrayList<LogData>();
        int i = 0;
        while (i < bean.length - 1) {
            LogData logData = new LogData();
            logData.setType(new Integer(bean[i]));
            int beginName = bean[i + 1].indexOf("[");
            int endName = bean[i + 1].indexOf("]");
            int threadBegin = bean[i + 1].indexOf("\u7ebf\u7a0b\u53f7\uff1a");
            logData.setRun_time(bean[i + 1].substring(0, 19));
            if (threadBegin != -1) {
                int nameEnd = bean[i + 1].indexOf(" ", threadBegin);
                logData.setThread_num(bean[i + 1].substring(threadBegin + 4, nameEnd));
                int startIndex = bean[i + 1].indexOf(" \u4efb\u52a1\u540d\uff1a");
                if (startIndex != -1) {
                    int contentIndex = bean[i + 1].indexOf(" ", startIndex + 4);
                    String task_name = bean[i + 1].substring(startIndex + 5, contentIndex);
                    logData.setTask_name(task_name);
                    logData.setContent(bean[i + 1].substring(contentIndex + 1));
                } else if (beginName != -1 && endName != -1 && endName > beginName) {
                    logData.setTask_name(bean[i + 1].substring(beginName + 1, endName));
                    if (endName != -1) {
                        logData.setContent("\u7ed3\u675f\u6267\u884c\u4efb\u52a1" + bean[i + 1].substring(endName + 1));
                    } else {
                        logData.setContent(bean[i + 1]);
                    }
                } else {
                    logData.setTask_name("");
                    logData.setContent(bean[i + 1]);
                }
            } else if (beginName != -1 && endName != -1 && endName > beginName) {
                logData.setTask_name(bean[i + 1].substring(beginName + 1, endName));
                logData.setThread_num("");
                if (bean[i + 1].length() > 27) {
                    logData.setContent(bean[i + 1].substring(27));
                } else {
                    logData.setContent(bean[i + 1]);
                }
            } else {
                logData.setTask_name("");
                logData.setThread_num("");
                logData.setContent(bean[i + 1]);
            }
            list.add(logData);
            i += 2;
        }
        return list;
    }

    private List<LogData> getTestData() {
        ArrayList<LogData> list = new ArrayList<LogData>();
        int number = GenerateUtil.generate3() / 500 + 1;
        int i = 0;
        while (i < number) {
            list.add(new LogData(0, String.valueOf(DateTimeUtil.getYMDHMSFromDate((Date)new Date())) + "    \u65b0\u5efa\u7acb\u4efb\u52a1 [sql]"));
            list.add(new LogData(1, String.valueOf(DateTimeUtil.getYMDHMSFromDate((Date)new Date())) + "    \u7ebf\u7a0b\u53f7\uff1a2336    \u4efb\u52a1\u540d\uff1asql    \u5411TRS\u88c5\u8f7d\u6570\u636e\u65f6\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1aErrorNumber  RecordAddress  RecordSize     ErrorPrompt"));
            list.add(new LogData(0, String.valueOf(DateTimeUtil.getYMDHMSFromDate((Date)new Date())) + "    \u7ed3\u675f\u6267\u884c\u4efb\u52a1 [sql]    \u53d6\u51fa\u6570\u636e\u603b\u6570\uff1a120\uff1b\u5411TRS \u6570\u636e\u5e93\uff1alocalhost\uff1a8888\uff1aSYSTEM.gatewaytest\u88c5\u8f7d\u6570\u636e\u603b\u6570\uff1a0\uff0c\u5220\u9664\u6570\u636e\u603b\u6570\uff1a0\uff1b\u5411TRS \u6570\u636e\u5e93\uff1alocalhost\uff1a8888\uff1aSYSTEM.gatewaytest\u88c5\u8f7d\u6570\u636e\u603b\u6570\uff1a0\uff0c\u5220\u9664\u6570\u636e\u603b\u6570\uff1a0\uff1b\u5411TRS \u6570\u636e\u5e93\uff1alocalhost\uff1a8888\uff1aSYSTEM.gatewaytest\u88c5\u8f7d\u6570\u636e\u603b\u6570\uff1a0\uff0c\u5220\u9664\u6570\u636e\u603b\u6570\uff1a0"));
            ++i;
        }
        return list;
    }

    @Override
    public DbStatus getRegisteredRdb() throws ExceptionUtil {
        return this.getDbStatus(this.robotDAO.getRegisteredRdb());
    }

    @Override
    public List<String> getTable(DbParams dbParams) throws ExceptionUtil {
        return this._arrToList(this.robotDAO.getTable(dbParams));
    }

    @Override
    public List<FieldData> getTableColumn(DbParams dbParams) throws ExceptionUtil {
        return this.getFieldDatas(dbParams.getDbtype(), this.robotDAO.getTableColumn(dbParams));
    }

    @Override
    public List<TaskStatus> getTaskStatus() throws ExceptionUtil {
        ArrayList<TaskStatus> list = new ArrayList<TaskStatus>();
        String[] bean = this.robotDAO.getTaskStatus();
        int i = 0;
        while (i < bean.length) {
            TaskStatus taskStatus = new TaskStatus();
            taskStatus.setTask_name(bean[i]);
            taskStatus.setStatus(new Integer(bean[i + 1]));
            taskStatus.setNext_runtime(new Long(bean[i + 2]));
            taskStatus.setRun_time(new Integer(bean[i + 3]));
            list.add(taskStatus);
            i += 4;
        }
        return list;
    }

    @Override
    public List<String> getTrsUser(DbParams dbParams) throws ExceptionUtil {
        return this._arrToList(this.robotDAO.getTrsUser(dbParams));
    }

    @Override
    public List<String> getView(DbParams dbParams) throws ExceptionUtil {
        return this._arrToList(this.robotDAO.getView(dbParams));
    }

    @Override
    public List<FieldData> getViewColumn(DbParams dbParams) throws ExceptionUtil {
        return this.getFieldDatas(dbParams.getDbtype(), this.robotDAO.getViewColumn(dbParams));
    }

    @Override
    public List<String> getViewTable(DbParams dbParams) throws ExceptionUtil {
        return this._arrToList(this.robotDAO.getViewTable(dbParams));
    }

    @Override
    public List<String> getVirtualView(DbParams dbParams) throws ExceptionUtil {
        return this._arrToList(this.robotDAO.getVirtualView(dbParams));
    }

    @Override
    public List<MachineData> getVirtualViewBkserver(DbParams dbParams) throws ExceptionUtil {
        return this.arrToMachineData(this.robotDAO.getVirtualViewBkserver(dbParams));
    }

    private List<MachineData> arrToMachineData(String[] datas) {
        ArrayList<MachineData> mList = new ArrayList<MachineData>();
        int i = 0;
        while (i < datas.length - 5) {
            MachineData machineData = new MachineData();
            machineData.setGroup_name(datas[i]);
            machineData.setNode_no(new Integer(datas[i]));
            machineData.setMachine_no(new Integer(datas[i + 1]));
            machineData.setTrs_server(datas[i + 2]);
            machineData.setTrs_port(new Integer(datas[i + 3]).toString());
            machineData.setTrs_database(datas[i + 4]);
            int machine_view = Integer.parseInt(datas[i + 5]);
            if (machine_view == 1) {
                machine_view = 0;
            }
            machineData.setMachine_view(machine_view);
            mList.add(machineData);
            i += 6;
        }
        return mList;
    }

    @Override
    public String getWorkPath() throws ExceptionUtil {
        return this.robotDAO.getWorkPath();
    }

    @Override
    public String loginDb(DbParams dbParams) throws ExceptionUtil {
        return this.robotDAO.loginDb(dbParams);
    }

    @Override
    public boolean loginFtp(FtpConfig ftpConfig) throws ExceptionUtil {
        return this.robotDAO.loginFtp(ftpConfig) == 0;
    }

    @Override
    public boolean setLogConfig(LogConfig logConfig) throws ExceptionUtil {
        return this.robotDAO.setLogConfig(logConfig) == 0;
    }

    @Override
    public boolean setWatchConfig(String taskName) throws ExceptionUtil {
        return this.robotDAO.setWatchConfig(taskName) == 0;
    }

    @Override
    public boolean run(String taskName) throws ExceptionUtil {
        return this.robotDAO.run(taskName) == 0;
    }

    @Override
    public boolean stop(String taskName) throws ExceptionUtil {
        return this.robotDAO.stop(taskName) == 0;
    }

    @Override
    public void exit() throws ExceptionUtil {
        this.robotDAO.exit();
    }

    @Override
    public Date getServerTime() throws ExceptionUtil {
        String string = this.robotDAO.getServerTime();
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTimeInMillis(Long.parseLong(string) * 1000L);
        Date date = rightNow.getTime();
        return date;
    }

    @Override
    public String loadExt() throws ExceptionUtil {
        return this.robotDAO.loadExt();
    }

    @Override
    public boolean extStat() throws ExceptionUtil {
        return this.robotDAO.extStat().equals("1");
    }

    @Override
    public String getMachineCode() throws ExceptionUtil {
        return this.robotDAO.getMachineCode();
    }

    @Override
    public boolean delete(String task_names) throws ExceptionUtil {
        if (this.robotDAO.delete(task_names) == 0) {
            this.downloadConfig();
            return true;
        }
        return false;
    }

    @Override
    public boolean add(AgentConfig agentConfig) throws ExceptionUtil {
        String rMac;
        String robotHost = this.robotConfig.getRobothost();
        if (!(robotHost.equals("127.0.0.1") || robotHost.toLowerCase().equals("localhost") || (rMac = this.robotDAO.getMachineCode()).equalsIgnoreCase(this.robotConfig.getMachineCode()))) {
            this.log.error((Object)("\u8fdc\u7a0b\u670d\u52a1\u5668\u5730\u5740(" + robotHost + ")\u673a\u5668\u7801\u9a8c\u8bc1\u9519\u8bef\uff01"));
            return false;
        }
        if (this.hadRepeatData(agentConfig)) {
            throw new ExceptionUtil(1, "\u4efb\u52a1\u540d\u540d\u91cd\u590d[" + agentConfig.getTask_name() + "]!");
        }
        int trspolicy = agentConfig.getTrsConfig().getTrs_policy();
        int dbtype = agentConfig.getRdbConfig().getRdb_type();
        if (dbtype != 0 && trspolicy == 1) {
            int machine_type = agentConfig.getMachine_type();
            List<MachineData> machine_list = agentConfig.getMachine_list();
            if (machine_list.size() > 0) {
                if (machine_type == 0) {
                    if (machine_list.get(0).getMachine_no() != -1 || machine_list.get(0).getNode_no() != -1 || machine_list.get(0).getMachine_view() != 1) {
                        MachineData tmdata = new MachineData();
                        tmdata.setTrs_server("127.0.0.1");
                        tmdata.setTrs_database("gw_auto_view");
                        tmdata.setTrs_port("8888");
                        tmdata.setTrs_username("system");
                        tmdata.setTrs_password("manager");
                        tmdata.setMachine_no(-1);
                        tmdata.setNode_no(-1);
                        tmdata.setGroup_name("0");
                        tmdata.setMachine_view(1);
                        machine_list.add(0, tmdata);
                        agentConfig.setMachine_list(machine_list);
                    }
                    int i = 0;
                    while (i < machine_list.size()) {
                        if (machine_list.get(i).getMachine_view() != 1) {
                            machine_list.get(i).setGroup_name("0," + machine_list.get(i).getMachine_no());
                        }
                        ++i;
                    }
                } else if (machine_type == 1 && !machine_list.get(0).getGroup_name().equals("0") && agentConfig.getVirtual_view() != null) {
                    machine_list.add(0, agentConfig.getVirtual_view());
                }
            }
            agentConfig.setMachine_list(machine_list);
        }
        ArrayList<AgentConfig> agentConfigs = new ArrayList<AgentConfig>();
        agentConfigs.add(agentConfig);
        String config = ConfigHelper.objectsToString(agentConfigs);
        if (this.robotDAO.add(config) == 0) {
            this.downloadConfig();
            return true;
        }
        return false;
    }

    @Override
    public boolean edit(AgentConfig agentConfig, String oldTaskName) throws ExceptionUtil {
        List<AgentConfig> aList = this.getConfig();
        boolean hadValue = false;
        AgentConfig _agentConfig = new AgentConfig();
        int i = aList.size() - 1;
        while (i >= 0) {
            _agentConfig = aList.get(i);
            if (_agentConfig.getId().equals(agentConfig.getId())) {
                aList.set(i, agentConfig);
                hadValue = true;
                break;
            }
            --i;
        }
        if (!hadValue) {
            throw new ExceptionUtil(1, "\u6ca1\u6709\u627e\u5230ID\u4e3a" + agentConfig.getId() + "\u7684\u4efb\u52a1\uff01");
        }
        if (this.hadRepeatData(agentConfig)) {
            throw new ExceptionUtil(1, "\u4efb\u52a1\u540d\u540d\u91cd\u590d[" + agentConfig.getTask_name() + "]!");
        }
        ArrayList<AgentConfig> agentConfigs = new ArrayList<AgentConfig>();
        agentConfigs.add(agentConfig);
        String config = ConfigHelper.objectsToString(agentConfigs);
        if (this.robotDAO.edit(oldTaskName, config) == 0) {
            this.downloadConfig();
            return true;
        }
        return false;
    }

    public String getServerVersion() throws ExceptionUtil {
        return this.robotDAO.getServerVersion();
    }

    protected boolean hadRepeatData(AgentConfig _agentConfig) throws ExceptionUtil {
        List<AgentConfig> list = this.gets();
        if (list == null || list.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            AgentConfig agentConfig = list.get(i);
            if (_agentConfig.getId() == null ? agentConfig.getTask_name().toLowerCase().trim().equals(_agentConfig.getTask_name().toLowerCase().trim()) : !_agentConfig.getId().equals(agentConfig.getId()) && agentConfig.getTask_name().toLowerCase().trim().equals(_agentConfig.getTask_name().toLowerCase().trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public AgentConfig get(String task_name) throws ExceptionUtil {
        List<AgentConfig> list = this.gets();
        for (AgentConfig agentConfig : list) {
            if (!agentConfig.getTask_name().equals(task_name)) continue;
            return agentConfig;
        }
        throw new ExceptionUtil(1, "\u6ca1\u6709\u627e\u5230\u4efb\u52a1\u540d\u4e3a" + task_name + "\uff01");
    }

    @Override
    public List<AgentConfig> gets() throws ExceptionUtil {
        return this.getConfig();
    }

    private DbStatus getDbStatus(String[] bean) {
        DbStatus dbStatus = new DbStatus();
        if (bean == null) {
            return dbStatus;
        }
        int i = 0;
        while (i < bean.length) {
            if (new Integer(bean[i]) == 0) {
                dbStatus.setTrs(true);
            } else if (new Integer(bean[i]) == 1) {
                dbStatus.setSqlserver(true);
            } else if (new Integer(bean[i]) == 2) {
                dbStatus.setOracle(true);
            } else if (new Integer(bean[i]) == 3) {
                dbStatus.setDb2(true);
            } else if (new Integer(bean[i]) == 4) {
                dbStatus.setSybase(true);
            } else if (new Integer(bean[i]) == 5) {
                dbStatus.setMysql(true);
            }
            ++i;
        }
        return dbStatus;
    }

    private List<FieldData> getFieldDatas(int dbtype, String[] bean) {
        ArrayList<FieldData> list = new ArrayList<FieldData>();
        if (dbtype == 0) {
            int i = 0;
            while (i < bean.length - 3) {
                FieldData fieldData = new FieldData();
                fieldData.setField_name(bean[i]);
                fieldData.setField_type(new Integer(bean[i + 1]));
                fieldData.setField_len(new Integer(bean[i + 2]));
                list.add(fieldData);
                i += 3;
            }
        } else {
            int i = 0;
            while (i < bean.length - 13) {
                FieldData fieldData = new FieldData();
                fieldData.setField_name(bean[i]);
                fieldData.setAlias(bean[i + 1]);
                fieldData.setField_type(new Integer(bean[i + 2]));
                fieldData.setField_len(new Integer(bean[i + 3]));
                fieldData.setField_pk(RobotLogicUtils.convertNumToBool(bean[i + 4]));
                fieldData.setField_upk(RobotLogicUtils.convertNumToBool(bean[i + 5]));
                fieldData.setField_mn(RobotLogicUtils.convertNumToBool(bean[i + 6]));
                fieldData.setField_num(RobotLogicUtils.convertNumToBool(bean[i + 7]));
                fieldData.setField_lob(RobotLogicUtils.convertNumToBool(bean[i + 8]));
                fieldData.setField_use(RobotLogicUtils.convertNumToBool(bean[i + 9]));
                fieldData.setFieldData2(new FieldData2(bean[i + 10], new Integer(bean[i + 11]), new Integer(bean[i + 3])));
                fieldData.setExt_type(new Integer(bean[i + 12]));
                fieldData.setField_ext(bean[i + 13]);
                list.add(fieldData);
                i += 14;
            }
        }
        return list;
    }

    private List<String> _arrToList(String[] datas) {
        ArrayList<String> list = new ArrayList<String>();
        if (datas == null) {
            return list;
        }
        int i = 0;
        while (i < datas.length) {
            list.add(datas[i]);
            ++i;
        }
        return list;
    }
}

