/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.perftests;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.perftests.OperationType;
import com.aliyun.oss.perftests.TestScenario;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class PerftestRunner {
    private static final Log log = LogFactory.getLog(PerftestRunner.class);
    private TestScenario scenario;
    private OSSClient ossClient;
    private Date startTime;
    private Date endTime;
    private int putErrNum = 0;
    private int getErrNum = 0;
    private final ReentrantLock lock = new ReentrantLock();
    private static String fileName = "perftest.txt";
    private byte[] byteArray1KB;
    private byte[] byteArray100KB;
    private byte[] byteArray1MB;
    private byte[] byteArray4MB;

    private static TestScenario.Type determineScenarioType(String scenarioTypeString) {
        TestScenario.Type t = TestScenario.Type.UNKNOWN;
        if (scenarioTypeString.equals("onlyput-1MB")) {
            t = TestScenario.Type.ONLY_PUT_1MB;
        } else if (scenarioTypeString.equals("onlyput-4MB")) {
            t = TestScenario.Type.ONLY_PUT_4MB;
        } else if (scenarioTypeString.equals("get-and-put-1vs1-1KB")) {
            t = TestScenario.Type.GET_AND_PUT_1VS1_1KB;
        } else if (scenarioTypeString.equals("get-and-put-1vs1-100KB")) {
            t = TestScenario.Type.GET_AND_PUT_1VS1_100KB;
        } else if (scenarioTypeString.equals("get-and-put-1vs1-1MB")) {
            t = TestScenario.Type.GET_AND_PUT_1VS1_1MB;
        } else if (scenarioTypeString.equals("get-and-put-1vs1-4MB")) {
            t = TestScenario.Type.GET_AND_PUT_1VS1_4MB;
        } else if (scenarioTypeString.equals("get-and-put-1vs1-1MB")) {
            t = TestScenario.Type.GET_AND_PUT_1VS1_1MB;
        } else if (scenarioTypeString.equals("get-and-put-1vs4-1MB")) {
            t = TestScenario.Type.GET_AND_PUT_1VS4_1MB;
        } else if (scenarioTypeString.equals("get-and-put-1vs4-4MB")) {
            t = TestScenario.Type.GET_AND_PUT_1VS4_4MB;
        } else {
            throw new IllegalArgumentException("Unsupported test sconario type " + scenarioTypeString);
        }
        return t;
    }

    public void buildScenario(String scenarioTypeString) {
        File confFile = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "runner_conf.xml");
        FileInputStream input = null;
        try {
            input = new FileInputStream(confFile);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
            Assert.fail((String)e.getMessage());
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build((InputStream)input);
            Element root = doc.getRootElement();
            this.scenario = new TestScenario();
            this.scenario.setHost(root.getChildText("host"));
            this.scenario.setAccessId(root.getChildText("accessid"));
            this.scenario.setAccessKey(root.getChildText("accesskey"));
            this.scenario.setBucketName(root.getChildText("bucket"));
            this.scenario.setType(PerftestRunner.determineScenarioType(scenarioTypeString));
            Element target = root.getChild(scenarioTypeString);
            if (target != null) {
                this.scenario.setContentLength(Long.parseLong(target.getChildText("size")));
                this.scenario.setPutThreadNumber(Integer.parseInt(target.getChildText("putthread")));
                this.scenario.setGetThreadNumber(Integer.parseInt(target.getChildText("getthread")));
                this.scenario.setDurationInSeconds(Integer.parseInt(target.getChildText("time")));
                this.scenario.setGetQPS(Integer.parseInt(target.getChildText("getqps")));
                this.scenario.setPutQPS(Integer.parseInt(target.getChildText("putqps")));
            } else {
                log.error((Object)("Unable to locate XML element " + scenarioTypeString));
                Assert.fail((String)("Unable to locate XML element " + scenarioTypeString));
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public void prepareEnv() {
        String endpoint = this.scenario.getHost();
        String accessId = this.scenario.getAccessId();
        String accessKey = this.scenario.getAccessKey();
        this.ossClient = new OSSClient(endpoint, accessId, accessKey);
        try {
            this.byteArray1KB = PerftestRunner.createFixedLengthBytes(1024);
            this.byteArray100KB = PerftestRunner.createFixedLengthBytes(102400);
            this.byteArray1MB = PerftestRunner.createFixedLengthBytes(0x100000);
            this.byteArray4MB = PerftestRunner.createFixedLengthBytes(0x400000);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            Assert.fail((String)e.getMessage());
        }
    }

    public void createBucket() {
        String bucketName = this.scenario.getBucketName();
        try {
            this.ossClient.createBucket(bucketName);
        }
        catch (OSSException e) {
            log.error((Object)("Put bucket " + bucketName + " error " + e.getMessage()));
            Assert.fail((String)e.getMessage());
        }
        catch (ClientException e) {
            log.error((Object)("Put bucket " + bucketName + " error " + e.getMessage()));
            Assert.fail((String)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("Put bucket " + bucketName + " error " + e.getMessage()));
            Assert.fail((String)e.getMessage());
        }
    }

    private static byte[] createFixedLengthBytes(int fixedLength) {
        byte[] data = new byte[fixedLength];
        int i = 0;
        while (i < fixedLength) {
            data[i] = 97;
            ++i;
        }
        return data;
    }

    private byte[] chooseByteArray(long contentLength) {
        if (contentLength == 1024L) {
            return this.byteArray1KB;
        }
        if (contentLength == 102400L) {
            return this.byteArray100KB;
        }
        if (contentLength == 0x100000L) {
            return this.byteArray1MB;
        }
        if (contentLength == 0x400000L) {
            return this.byteArray4MB;
        }
        throw new IllegalArgumentException("Illegal content length, only support 1KB & 100KB & 1MB & 4MB");
    }

    private boolean hasExpired() {
        Date now = new Date();
        long interval = (now.getTime() - this.startTime.getTime()) / 1000L;
        return interval > (long)this.scenario.getDurationInSeconds();
    }

    private String buildObjectKey(String keyPrefix) {
        int n = new Random().nextInt(100000);
        StringBuilder sb = new StringBuilder();
        sb.append(keyPrefix);
        sb.append(Integer.toString(n));
        return sb.toString();
    }

    private static Thread[] joinThreads(Thread[] ... threadArrays) {
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        Thread[][] threadArray = threadArrays;
        int n = threadArrays.length;
        int n2 = 0;
        while (n2 < n) {
            Thread[] tarr;
            Thread[] threadArray2 = tarr = threadArray[n2];
            int n3 = tarr.length;
            int n4 = 0;
            while (n4 < n3) {
                Thread t = threadArray2[n4];
                threadList.add(t);
                ++n4;
            }
            ++n2;
        }
        Thread[] joined = new Thread[threadList.size()];
        return threadList.toArray(joined);
    }

    public static void waitAll(Thread[] targets) {
        int i = 0;
        while (i < targets.length) {
            targets[i].start();
            ++i;
        }
        i = 0;
        while (i < targets.length) {
            try {
                targets[i].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }

    private String getTestName(OperationType type) {
        switch (type) {
            case PUT: {
                return "PutObject";
            }
            case GET: {
                return "GetObject";
            }
        }
        return "UnknownTest";
    }

    private String getLengthString(long contentLength) {
        if (contentLength > 0L) {
            if (contentLength % 0x40000000L == 0L) {
                return contentLength / 0x40000000L + "G";
            }
            if (contentLength % 0x100000L == 0L) {
                return contentLength / 0x100000L + "M";
            }
            if (contentLength % 1024L == 0L) {
                return contentLength / 1024L + "K";
            }
        }
        return contentLength + "B";
    }

    private String getTimeSpanString(long passTime) {
        if (passTime > 0L) {
            if (passTime % 3600L == 0L) {
                return passTime / 3600L + "hour";
            }
            if (passTime % 60L == 0L) {
                return passTime / 60L + "min";
            }
        }
        return passTime + "s";
    }

    /*
     * Unable to fully structure code
     */
    private void calculateResult(List<Long> latencyArray, OperationType type, int threadNum) {
        try {
            errNum = type == OperationType.PUT ? this.putErrNum : this.getErrNum;
            totalNum = latencyArray.size() + errNum;
            if (totalNum <= 0) {
                return;
            }
            thresholds = new long[]{10L, 50L, 100L, 1000L, 3000L, 0x7FFFFFFFFFFFFFFFL};
            thresholdNum = new long[6];
            avgLatency = 0L;
            Collections.sort(latencyArray);
            j = 0;
            i = 0;
            ** GOTO lbl20
            {
                v0 = i;
                thresholdNum[v0] = thresholdNum[v0] + 1L;
                avgLatency += latencyArray.get(j).longValue();
                ++j;
                do {
                    if (j < latencyArray.size() && latencyArray.get(j) <= thresholds[i]) continue block2;
                    ++i;
lbl20:
                    // 2 sources

                } while (i < thresholds.length);
            }
            passTime = this.endTime.getTime() - this.startTime.getTime();
            qps = (double)latencyArray.size() * 1000.0 / (double)passTime;
            errRate = (double)errNum * 1.0 / (double)totalNum;
            throughput = qps * (double)this.scenario.getContentLength() / 1048576.0;
            contentStr = null;
            contentStr = String.format("TestType:%s\n", new Object[]{this.getTestName(type)});
            contentStr = String.valueOf(contentStr) + String.format("threads:%d, %s, %s\n", new Object[]{threadNum, this.getLengthString(this.scenario.getContentLength()), this.getTimeSpanString(this.scenario.getDurationInSeconds())});
            contentStr = String.valueOf(contentStr) + String.format("Qps:%.1f Throughput:%.2fM AvgLatency:%dms\n", new Object[]{qps, throughput, avgLatency /= (long)latencyArray.size()});
            contentStr = String.valueOf(contentStr) + String.format("ErrorRate:%.2f\n", new Object[]{errRate});
            contentStr = String.valueOf(contentStr) + "Latency Range:\n";
            contentStr = String.valueOf(contentStr) + String.format("%d-%dms\t%.2f%s\n", new Object[]{0, thresholds[0], (double)thresholdNum[0] * 100.0 / (double)totalNum, "%"});
            i = 0;
            while (i < thresholds.length - 2) {
                contentStr = String.valueOf(contentStr) + String.format("%d-%dms\t%.2f%s\n", new Object[]{thresholds[i], thresholds[i + 1], (double)thresholdNum[i + 1] * 100.0 / (double)totalNum, "%"});
                ++i;
            }
            contentStr = String.valueOf(contentStr) + String.format("%dms+\t\t%.2f%s\n", new Object[]{thresholds[thresholds.length - 2], (double)thresholdNum[thresholdNum.length - 1] * 100.0 / (double)totalNum, "%"});
            System.out.printf("%s", new Object[]{contentStr});
            this.writeResult(contentStr);
        }
        catch (Exception e) {
            PerftestRunner.log.error((Object)("Unexpected exception occurs when calculate result " + this.getTestName(type)));
            Assert.fail((String)e.getMessage());
        }
    }

    public void writeResult(String contentStr) {
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(fileName, true);
                writer.write(contentStr);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
                Assert.fail((String)e.getMessage());
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception e2) {
                    log.error((Object)e2.getMessage());
                    Assert.fail((String)e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage());
                Assert.fail((String)e2.getMessage());
            }
        }
    }

    private void recordError(OperationType type) {
        try {
            this.lock.lock();
            if (type == OperationType.PUT) {
                ++this.putErrNum;
            } else if (type == OperationType.GET) {
                ++this.getErrNum;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void testRun() {
        int putThreadNumber = this.scenario.getPutThreadNumber();
        int getThreadNumber = this.scenario.getGetThreadNumber();
        int getQPS = this.scenario.getGetQPS();
        int putQPS = this.scenario.getPutQPS();
        final int getInterval = getThreadNumber == 0 ? 0 : getThreadNumber * (1000 / getQPS);
        final int putInterval = putThreadNumber * (1000 / putQPS);
        final long contentLength = this.scenario.getContentLength();
        final String bucketName = this.scenario.getBucketName();
        final byte[] byteArray = this.chooseByteArray(contentLength);
        String keyPrefix = "xiao-perf-test-";
        final ArrayList uploadedObjects = new ArrayList();
        final ArrayList<Long> putLatencyArray = new ArrayList<Long>();
        final ArrayList<Long> getLatencyArray = new ArrayList<Long>();
        final PerftestRunner self = this;
        Thread[] putThreads = new Thread[putThreadNumber];
        try {
            int i = 0;
            while (i < putThreadNumber) {
                Runnable r = new Runnable(){

                    /*
                     * Loose catch block
                     */
                    @Override
                    public void run() {
                        while (!self.hasExpired()) {
                            ByteArrayInputStream input;
                            block26: {
                                input = null;
                                try {
                                    input = new ByteArrayInputStream(byteArray);
                                    String objectKey = PerftestRunner.this.buildObjectKey("xiao-perf-test-");
                                    log.info((Object)("Begin put " + objectKey));
                                    Date from = new Date();
                                    ObjectMetadata metadata = new ObjectMetadata();
                                    metadata.setContentLength(contentLength);
                                    PerftestRunner.this.ossClient.putObject(bucketName, objectKey, input, metadata);
                                    Date to = new Date();
                                    long latency = to.getTime() - from.getTime();
                                    if (latency < (long)putInterval) {
                                        Thread.sleep((long)putInterval - latency);
                                    } else {
                                        log.warn((Object)("Put object " + objectKey + " latency " + latency + ", exceed max interval " + putInterval));
                                    }
                                    log.info((Object)("Put object " + objectKey + " finished, elapsed " + latency + "ms"));
                                    try {
                                        PerftestRunner.this.lock.lock();
                                        uploadedObjects.add(objectKey);
                                        putLatencyArray.add(latency);
                                        break block26;
                                    }
                                    finally {
                                        PerftestRunner.this.lock.unlock();
                                    }
                                }
                                catch (OSSException oe) {
                                    log.warn((Object)("Unexpected oss exception occurs when putting object " + oe.getMessage()));
                                    PerftestRunner.this.recordError(OperationType.PUT);
                                    if (input == null) continue;
                                    try {
                                        ((InputStream)input).close();
                                        input = null;
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    continue;
                                }
                                catch (ClientException ce) {
                                    log.warn((Object)("Unexpected client exception occurs when putting object " + ce.getMessage()));
                                    PerftestRunner.this.recordError(OperationType.PUT);
                                    continue;
                                }
                                catch (Exception e) {
                                    log.warn((Object)("Other unexpected exception " + e.getMessage()));
                                    PerftestRunner.this.recordError(OperationType.PUT);
                                    if (input == null) continue;
                                    {
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                    }
                                    try {
                                        ((InputStream)input).close();
                                        input = null;
                                    }
                                    catch (IOException e2) {
                                        e2.printStackTrace();
                                    }
                                    continue;
                                }
                                {
                                    finally {
                                        if (input != null) {
                                            try {
                                                ((InputStream)input).close();
                                                input = null;
                                            }
                                            catch (IOException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                }
                            }
                            if (input == null) continue;
                            try {
                                ((InputStream)input).close();
                                input = null;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                };
                putThreads[i] = new Thread(r);
                ++i;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage());
            Assert.fail((String)ex.getMessage());
        }
        Thread[] getThreads = new Thread[getThreadNumber];
        try {
            int i = 0;
            while (i < getThreadNumber) {
                Runnable r = new Runnable(){

                    /*
                     * Loose catch block
                     */
                    @Override
                    public void run() {
                        OSSObject o = null;
                        while (!PerftestRunner.this.hasExpired()) {
                            block35: {
                                String objectKey;
                                block34: {
                                    objectKey = null;
                                    if (uploadedObjects.size() > 0) {
                                        try {
                                            PerftestRunner.this.lock.lock();
                                            if (uploadedObjects.size() <= 0) break block34;
                                            int index = new Random().nextInt(uploadedObjects.size());
                                            objectKey = (String)uploadedObjects.get(index);
                                            break block34;
                                        }
                                        finally {
                                            PerftestRunner.this.lock.unlock();
                                        }
                                    }
                                    Thread.sleep(50L);
                                    if (o == null) continue;
                                    try {
                                        o.getObjectContent().close();
                                        o = null;
                                    }
                                    catch (IOException e) {
                                        log.error((Object)("IO Exception " + e.getMessage()));
                                    }
                                    continue;
                                }
                                try {
                                    GetObjectRequest request = new GetObjectRequest(bucketName, objectKey);
                                    log.info((Object)("Begin get " + objectKey));
                                    Date from = new Date();
                                    o = PerftestRunner.this.ossClient.getObject(request);
                                    byte[] content = new byte[8196];
                                    InputStream in = o.getObjectContent();
                                    while (in.read(content) >= 0) {
                                    }
                                    Date to = new Date();
                                    long latency = to.getTime() - from.getTime();
                                    if (latency < (long)getInterval) {
                                        Thread.sleep((long)getInterval - latency);
                                    } else {
                                        log.warn((Object)("Get object " + objectKey + " latency " + latency + ", exceed max interval " + getInterval));
                                    }
                                    log.info((Object)("Get object " + objectKey + " finished, elapsed " + latency + "ms"));
                                    try {
                                        PerftestRunner.this.lock.lock();
                                        getLatencyArray.add(latency);
                                        break block35;
                                    }
                                    finally {
                                        PerftestRunner.this.lock.unlock();
                                    }
                                }
                                catch (OSSException oe) {
                                    log.warn((Object)("Unexpected oss exception occurs when getting object " + oe.getMessage()));
                                    PerftestRunner.this.recordError(OperationType.GET);
                                    if (o == null) continue;
                                    try {
                                        o.getObjectContent().close();
                                        o = null;
                                    }
                                    catch (IOException e) {
                                        log.error((Object)("IO Exception " + e.getMessage()));
                                    }
                                    continue;
                                }
                                catch (ClientException ce) {
                                    log.warn((Object)("Unexpected oss exception occurs when getting object " + ce.getMessage()));
                                    PerftestRunner.this.recordError(OperationType.GET);
                                    continue;
                                }
                                catch (Exception e) {
                                    log.warn((Object)("Other unexpected exception " + e.getMessage()));
                                    PerftestRunner.this.recordError(OperationType.GET);
                                    if (o == null) continue;
                                    {
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                    }
                                    try {
                                        o.getObjectContent().close();
                                        o = null;
                                    }
                                    catch (IOException e2) {
                                        log.error((Object)("IO Exception " + e2.getMessage()));
                                    }
                                    continue;
                                }
                                {
                                    finally {
                                        if (o != null) {
                                            try {
                                                o.getObjectContent().close();
                                                o = null;
                                            }
                                            catch (IOException e) {
                                                log.error((Object)("IO Exception " + e.getMessage()));
                                            }
                                        }
                                    }
                                }
                            }
                            if (o == null) continue;
                            try {
                                o.getObjectContent().close();
                                o = null;
                            }
                            catch (IOException e) {
                                log.error((Object)("IO Exception " + e.getMessage()));
                            }
                        }
                    }
                };
                getThreads[i] = new Thread(r);
                ++i;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage());
            Assert.fail((String)ex.getMessage());
        }
        this.startTime = new Date();
        Thread[] allThreads = PerftestRunner.joinThreads(putThreads, getThreads);
        PerftestRunner.waitAll(allThreads);
        this.endTime = new Date();
        this.calculateResult(putLatencyArray, OperationType.PUT, putThreadNumber);
        this.calculateResult(getLatencyArray, OperationType.GET, getThreadNumber);
    }

    public static void deleteFile() {
        File file = new File(fileName);
        if (file.isFile() && file.exists()) {
            file.delete();
        }
    }

    public static void main(String[] args) {
        String[] realArgs = args.length >= 1 ? Arrays.copyOf(args, args.length) : new String[]{"get-and-put-1vs1-1KB", "get-and-put-1vs1-100KB", "get-and-put-1vs1-1MB", "get-and-put-1vs1-4MB"};
        PerftestRunner.deleteFile();
        int i = 0;
        while (i < realArgs.length) {
            PerftestRunner runner = new PerftestRunner();
            runner.buildScenario(realArgs[i]);
            runner.prepareEnv();
            runner.createBucket();
            runner.writeResult("TestCycle:\n");
            System.out.printf("TestCycle:\n", new Object[0]);
            runner.testRun();
            ++i;
        }
    }
}

