/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.PropertyUtil;
import com.trs.idm.util.StringHelper;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import org.apache.log4j.Logger;

public class JceEncryptUtil {
    private static final Logger logger = Logger.getLogger(JceEncryptUtil.class);

    public static byte[] doEncrypt(Key key, byte[] toEncryptData, String transformation) {
        if (toEncryptData == null) {
            return null;
        }
        Cipher cipher = JceEncryptUtil.getCipher(key, 1, transformation);
        byte[] encryptedData = null;
        try {
            encryptedData = cipher.doFinal(toEncryptData);
        }
        catch (IllegalBlockSizeException e) {
            logger.error((Object)("get error while encrypt data by key[" + key + "] and transformation[" + transformation + "], error info: " + e));
        }
        catch (BadPaddingException e) {
            logger.error((Object)("get error while encrypt data by key[" + key + "] and transformation[" + transformation + "], error info: " + e));
        }
        return encryptedData;
    }

    public static byte[] doDecrypt(Key key, byte[] toDecryptData, String transformation) {
        if (toDecryptData == null) {
            return null;
        }
        Cipher cipher = JceEncryptUtil.getCipher(key, 2, transformation);
        byte[] decryptedData = null;
        try {
            decryptedData = cipher.doFinal(toDecryptData);
        }
        catch (IllegalBlockSizeException e) {
            logger.error((Object)("get error while decrypt data by key[" + key + "] and transformation[" + transformation + "], error info: " + e));
        }
        catch (BadPaddingException e) {
            logger.error((Object)("get error while decrypt data by key[" + key + "] and transformation[" + transformation + "], error info: " + e));
        }
        return decryptedData;
    }

    public static Cipher getCipher(Key key, int cipherMode, String transformation) {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(transformation);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("get error while getCipher by key[" + key + "], cipherMode[" + cipherMode + "], and transformation[" + transformation + "], error info: " + e));
        }
        catch (NoSuchPaddingException e) {
            logger.error((Object)("get error while getCipher by key[" + key + "], cipherMode[" + cipherMode + "], and transformation[" + transformation + "], error info: " + e));
        }
        try {
            cipher.init(cipherMode, key);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)("get error while int Cipher by key[" + key + "], cipherMode[" + cipherMode + "], error info: " + e));
        }
        return cipher;
    }

    public static SecretKey getKey(String algorithm, KeySpec keySpec) {
        SecretKeyFactory keyFactory = null;
        try {
            keyFactory = SecretKeyFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("get error while get key by algorithm [" + algorithm + "] and keySpec [" + keySpec + "], error info: " + e));
        }
        try {
            return keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            logger.error((Object)("get error while generate key by algorithm [" + algorithm + "] and keySpec [" + keySpec + "], error info: " + e));
            logger.error((Object)("can not get key by by algorithm [" + algorithm + "] and keySpec [" + keySpec + "]"));
            return null;
        }
    }

    public static String getKeyDataFromResource(String resName, String propertyName) {
        String keyData = "";
        try {
            keyData = PropertyUtil.assertAndLoadFromResource(JceEncryptUtil.class, resName).getProperty(propertyName);
        }
        catch (Exception e) {
            logger.error((Object)("get error of not such file by resourceName[" + resName + "] and propertyName[" + propertyName + "], error info: " + e));
        }
        if (StringHelper.isEmpty(keyData)) {
            logger.error((Object)("can not get keyData[" + keyData + "] from resourceName[" + resName + "] by propertyName[" + propertyName + "]"));
            return null;
        }
        return keyData;
    }
}

