/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent.validator;

import com.trs.idm.exception.FileReadException;
import com.trs.idm.exception.NoSuchFileException;
import com.trs.idm.interact.agent.AgentBase;
import com.trs.idm.interact.agent.validator.AgentConfigItem;
import com.trs.idm.interact.agent.validator.IAgentPropertiesValidator;
import com.trs.idm.saml.common.SPConfig;
import com.trs.idm.saml.common.SPConfigDesc;
import com.trs.idm.util.PropertyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SSOAPIPropertiesValidator
implements IAgentPropertiesValidator {
    private static final Logger LOG = Logger.getLogger(SSOAPIPropertiesValidator.class);
    private Properties agentConfigProperties;
    private List necessaryItems;
    private List errorItems;
    StringBuffer detailCheckResult;

    public SSOAPIPropertiesValidator() {
        this.init();
    }

    private void init() {
        this.detailCheckResult = new StringBuffer(256);
        try {
            this.agentConfigProperties = PropertyUtil.assertAndLoadFromResource(AgentBase.class, "/trsids-agent.properties");
        }
        catch (NoSuchFileException e) {
            LOG.error((Object)"trsids-agent.properties is not exist !!!!!!!!!", (Throwable)e);
            this.detailCheckResult.append("trsids-agent.properties \u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5b58\u5728\u8be5\u6587\u4ef6\uff01");
            return;
        }
        catch (FileReadException e) {
            LOG.error((Object)"read trsids-agent.properties error !!!!!!!!!", (Throwable)e);
            this.detailCheckResult.append("trsids-agent.properties \u65e0\u6cd5\u8bfb\u53d6\uff0c\u8bf7\u786e\u8ba4\u8be5\u6587\u4ef6\u662f\u5426\u6b63\u88ab\u5176\u4ed6\u7a0b\u5e8f\u9501\u5b9a\uff01");
            return;
        }
        this.necessaryItems = this.initNecessaryItems();
        this.errorItems = new ArrayList();
    }

    private List initNecessaryItems() {
        ArrayList<AgentConfigItem> items = new ArrayList<AgentConfigItem>();
        AgentConfigItem agentNameItem = new AgentConfigItem();
        agentNameItem.setName("agent.name");
        agentNameItem.setNotNull(true);
        agentNameItem.setDesc("\u534f\u4f5c\u5e94\u7528\u540d(\u82f1\u6587)\uff0c\u5fc5\u987b\u548c\u5728\u6240\u8981\u8fde\u63a5IDS\u4e0a\u6ce8\u518c\u7684\u534f\u4f5c\u5e94\u7528\u540d\u4fdd\u6301\u4e00\u81f4\u3002");
        items.add(agentNameItem);
        AgentConfigItem idsSSOUrlItem = new AgentConfigItem();
        idsSSOUrlItem.setName(SPConfig.BASIC_SSO_IDS_URL);
        idsSSOUrlItem.setNotNull(true);
        idsSSOUrlItem.setDesc(SPConfigDesc.BASIC_SSO_IDS_URL);
        items.add(idsSSOUrlItem);
        return items;
    }

    @Override
    public boolean check() {
        this.detailCheckResult = new StringBuffer(256);
        this.errorItems = new ArrayList();
        for (AgentConfigItem necessaryItem : this.necessaryItems) {
            if (this.agentConfigProperties.get(necessaryItem.getName()) != null) continue;
            AgentConfigItem missingItem = new AgentConfigItem();
            missingItem.setName(necessaryItem.getName());
            missingItem.setNotNull(necessaryItem.isNotNull());
            missingItem.setDesc(necessaryItem.getDesc());
            missingItem.setError(true);
            missingItem.setErrorMessage("\u65e0\u6cd5\u627e\u5230\u8be5\u914d\u7f6e\u9879\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u9879\u662f\u5426\u5728  trsids-agent.properties \u4e2d\u5b58\u5728\uff01");
            this.errorItems.add(missingItem);
        }
        this.checkAgentName();
        this.checkIDSSSOUrl();
        if (this.hasErrorItem()) {
            LOG.error((Object)"Error Config in trsids-agent.properties !!!!!!!!");
            LOG.error((Object)("all error items: " + this.errorItems));
            return false;
        }
        return true;
    }

    private void checkAgentName() {
        if ("".equals(this.agentConfigProperties.get("agent.name"))) {
            AgentConfigItem emptyItem = new AgentConfigItem();
            emptyItem.setName("agent.name");
            emptyItem.setNotNull(true);
            emptyItem.setDesc("\u534f\u4f5c\u5e94\u7528\u540d(\u82f1\u6587)\uff0c\u5fc5\u987b\u548c\u5728\u6240\u8981\u8fde\u63a5IDS\u4e0a\u6ce8\u518c\u7684\u534f\u4f5c\u5e94\u7528\u540d\u4fdd\u6301\u4e00\u81f4\u3002");
            emptyItem.setError(true);
            emptyItem.setErrorMessage("\u914d\u7f6e\u9879\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            this.errorItems.add(emptyItem);
        }
    }

    private void checkIDSSSOUrl() {
        if ("".equals(this.agentConfigProperties.get(SPConfig.BASIC_SSO_IDS_URL))) {
            AgentConfigItem emptyItem = new AgentConfigItem();
            emptyItem.setName(SPConfig.BASIC_SSO_IDS_URL);
            emptyItem.setNotNull(true);
            emptyItem.setDesc(SPConfigDesc.BASIC_SSO_IDS_URL);
            emptyItem.setError(true);
            emptyItem.setErrorMessage("\u914d\u7f6e\u9879\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            this.errorItems.add(emptyItem);
        }
    }

    @Override
    public String getDetailCheckResult() {
        if (this.hasErrorItem()) {
            this.detailCheckResult.append(" IDS Agent\u914d\u7f6e\u9519\u8bef\uff0c\u5bfc\u81f4Agent\u542f\u52a8\u5931\u8d25 \uff01 ");
        }
        return this.detailCheckResult.toString();
    }

    @Override
    public boolean hasErrorItem() {
        return this.errorItems != null && this.errorItems.size() > 0;
    }

    @Override
    public List listAllErrorItem() {
        return this.errorItems;
    }

    @Override
    public Properties getAgentConfigProperties() {
        return this.agentConfigProperties;
    }

    @Override
    public void addErrorItem(AgentConfigItem errorItem) {
        if (errorItem != null || this.errorItems != null) {
            this.errorItems.add(errorItem);
        }
    }
}

