/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.exception.FileReadException;
import com.trs.idm.exception.IdMException;
import com.trs.idm.exception.NoSuchFileException;
import com.trs.idm.util.CloseUtil;
import com.trs.idm.util.StringHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertyUtil {
    private static final Logger LOG = Logger.getLogger(PropertyUtil.class);

    public static Properties loadProperties(String fileName) {
        if (fileName == null) {
            return new Properties();
        }
        return PropertyUtil.loadProperties(new File(fileName));
    }

    public static Properties loadProperties(File f) {
        Properties props;
        block13: {
            props = new Properties();
            if (f == null || !f.exists()) {
                return props;
            }
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(f);
                    props.load(fis);
                }
                catch (Exception e) {
                    LOG.error((Object)("erron on load file: " + f), (Throwable)e);
                    if (fis == null) break block13;
                    try {
                        fis.close();
                    }
                    catch (IOException e1) {
                        LOG.error((Object)("erron on close file: " + f), (Throwable)e1);
                    }
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e1) {
                        LOG.error((Object)("erron on close file: " + f), (Throwable)e1);
                    }
                }
            }
        }
        return props;
    }

    public static Properties assertAndLoadProperties(File f) throws NoSuchFileException, FileReadException {
        Properties properties;
        if (f == null || !f.exists()) {
            throw new IllegalArgumentException("file is null!");
        }
        if (!f.isFile()) {
            throw new NoSuchFileException("file [ " + f + " ] not found.");
        }
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            props.load(fis);
            properties = props;
        }
        catch (IOException e) {
            try {
                LOG.error((Object)("erron on load file: " + f), (Throwable)e);
                throw new FileReadException("fail to read [" + f + "]", e);
            }
            catch (Throwable throwable) {
                CloseUtil.closeInputStream(fis);
                throw throwable;
            }
        }
        CloseUtil.closeInputStream(fis);
        return properties;
    }

    public static Properties loadFromResource(String resName) {
        return PropertyUtil.loadFromResource(PropertyUtil.class, resName);
    }

    public static Properties loadFromResource(Class clazz, String resName) {
        Properties props;
        block15: {
            props = new Properties();
            URL resUrl = clazz.getResource(resName);
            if (resUrl == null) {
                LOG.warn((Object)("resUrl=null! resName=" + resName));
                return props;
            }
            InputStream fis = null;
            try {
                fis = resUrl.openStream();
            }
            catch (IOException e) {
                LOG.error((Object)("erron on url.openStream(), url=" + resUrl), (Throwable)e);
            }
            try {
                try {
                    props.load(fis);
                }
                catch (Exception e) {
                    LOG.error((Object)("erron on load resource: " + resName + ", url=" + resUrl), (Throwable)e);
                    if (fis == null) break block15;
                    try {
                        fis.close();
                    }
                    catch (IOException e1) {
                        LOG.error((Object)("erron on close resource: " + resName + ", url=" + resUrl), (Throwable)e1);
                    }
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e1) {
                        LOG.error((Object)("erron on close resource: " + resName + ", url=" + resUrl), (Throwable)e1);
                    }
                }
            }
        }
        return props;
    }

    public static Properties assertAndLoadFromResource(Class clazz, String resName) throws NoSuchFileException, FileReadException {
        if (resName == null) {
            throw new IllegalArgumentException("the resource name is null!");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("the class object is null!");
        }
        URL resUrl = clazz.getResource(resName);
        if (resUrl == null) {
            if (resName.startsWith("/")) {
                throw new NoSuchFileException("resource [ " + resName + " ] not found in [ " + clazz.getResource("/") + " ]!");
            }
            throw new NoSuchFileException("resource [ " + resName + " ] not found in [ " + clazz.getResource("/") + PropertyUtil.getFSPathFormOfPackage(clazz) + " ]!");
        }
        InputStream fis = null;
        try {
            fis = resUrl.openStream();
        }
        catch (IOException e) {
            throw new FileReadException("fail to open [" + resUrl + "]", e);
        }
        Properties props = new Properties();
        try {
            try {
                props.load(fis);
            }
            catch (IOException e) {
                throw new FileReadException("fail to read [" + resUrl + "]", e);
            }
        }
        finally {
            CloseUtil.closeInputStream(fis);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadFromResource(Class clazz, String resName, String keyPrefix) {
        Properties props = PropertyUtil.loadFromResource(clazz, resName);
        Properties result = new Properties();
        Properties properties = props;
        synchronized (properties) {
            int max = props.size() - 1;
            Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
            int i = 0;
            while (i <= max) {
                Map.Entry<Object, Object> e = it.next();
                String key = (String)e.getKey();
                if (key.startsWith(keyPrefix)) {
                    result.put(key, e.getValue());
                }
                ++i;
            }
        }
        return result;
    }

    public static int getPropertyAsInt(Properties props, String key, int defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(strValue.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getPropertyByEncoding(Properties props, String key, String encoding) {
        return PropertyUtil.getPropertyByEncoding(props, key, "", encoding);
    }

    public static String getPropertyByEncoding(Properties props, String key, String defaultValue, String encoding) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return new String(strValue.getBytes("ISO-8859-1"), encoding);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getPropertyAsGBK(Properties props, String key) {
        return PropertyUtil.getPropertyByEncoding(props, key, "", "GBK");
    }

    public static String getPropertyAsGBK(Properties props, String key, String defaultValue) {
        return PropertyUtil.getPropertyByEncoding(props, key, defaultValue, "GBK");
    }

    public static String getTrimString(Properties props, String key, String defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null || "".equals(strValue)) {
            return defaultValue;
        }
        return (strValue = strValue.trim()).length() == 0 ? defaultValue : strValue;
    }

    public static long getPropertyAsLong(Properties props, String key, long defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(strValue.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean getPropertyAsBool(Properties props, String key, boolean defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null || "".equals(strValue)) {
            return defaultValue;
        }
        try {
            return strValue.trim().equalsIgnoreCase("true");
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String[] getPropertyAsStrAry(Properties props, String key, String token) {
        if (props == null) {
            return null;
        }
        String value = props.getProperty(key);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return StringHelper.splitAlways(value, token);
    }

    public static float getPropertyAsFloat(Properties props, String key, float defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String strValue = props.getProperty(key);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(strValue.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Properties props, String keyPrefix) {
        if (props == null || keyPrefix == null) {
            return "null! keyPrefix=" + keyPrefix;
        }
        String delit = ", ";
        int delitLen = ", ".length();
        StringBuffer sb = new StringBuffer(64);
        sb.append('{');
        Properties properties = props;
        synchronized (properties) {
            int max = props.size() - 1;
            Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
            int i = 0;
            while (i <= max) {
                Map.Entry<Object, Object> e = it.next();
                String key = (String)e.getKey();
                if (key.startsWith(keyPrefix)) {
                    sb.append(key).append('=').append(e.getValue());
                    sb.append(", ");
                }
                ++i;
            }
        }
        sb.delete(sb.length() > delitLen ? sb.length() - delitLen : 1, sb.length());
        sb.append('}');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getSubProperties(Properties props, String keyPrefix) {
        if (props == null || keyPrefix == null) {
            return props;
        }
        Properties result = new Properties();
        Properties properties = props;
        synchronized (properties) {
            int max = props.size() - 1;
            Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
            int i = 0;
            while (i <= max) {
                Map.Entry<Object, Object> e = it.next();
                String key = (String)e.getKey();
                if (key.startsWith(keyPrefix)) {
                    result.put(key, e.getValue());
                }
                ++i;
            }
        }
        return result;
    }

    public static Properties assertAndLoadFromResource(String resName) throws IdMException {
        return PropertyUtil.assertAndLoadFromResource(PropertyUtil.class, resName);
    }

    private static String getFSPathFormOfPackage(Class clazz) {
        Class<?> c = clazz;
        while (c.isArray()) {
            c = c.getComponentType();
        }
        String baseName = c.getName();
        int index = baseName.lastIndexOf(46);
        if (index != -1) {
            return baseName.substring(0, index).replace('.', '/');
        }
        return baseName;
    }
}

