/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.protocol;

import com.trs.idm.interact.protocol.AbstractPU;
import com.trs.idm.interact.protocol.JDK13PUImpl;
import com.trs.idm.interact.protocol.JDK14PUImpl;
import com.trs.idm.interact.protocol.ProtocolPacket;
import com.trs.idm.util.EnvUtil;
import com.trs.idm.util.StringHelper;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PacketUtil {
    private static final Logger LOG = Logger.getLogger(PacketUtil.class);
    private static final Pattern SEPARATOR = Pattern.compile("\n\r");
    private static AbstractPU puImpl;

    static {
        if (EnvUtil.isJDK14OrHigher()) {
            puImpl = new JDK14PUImpl();
        } else if (EnvUtil.isJDK13OrHigher()) {
            puImpl = new JDK13PUImpl();
        }
    }

    public static byte[] requestHead2Bytes(short len, short id, byte cmd) {
        return PacketUtil.convertPacketHead2Bytes(len, (byte)0, id, cmd, (byte)0, (byte)0, (byte)0, (byte)0);
    }

    public static byte[] responseHead2Bytes(short len, short id, byte rsCode, byte processCmd) {
        return PacketUtil.convertPacketHead2Bytes(len, (byte)1, id, rsCode, (byte)0, (byte)0, (byte)0, processCmd);
    }

    public static short parseBodyLength(byte[] data) {
        return puImpl.parseBodyLength(data);
    }

    static byte[] short2Bytes(short value) {
        return puImpl.short2Bytes(value);
    }

    static byte[] convertPacketHead2Bytes(short bodyLen, byte type, short packetID, byte cmdOrErrcode, byte encryptAlgo, byte reversed1, byte reversed2, byte processCmd) {
        return puImpl.convertPacketHead2Bytes(bodyLen, type, packetID, cmdOrErrcode, encryptAlgo, reversed1, reversed2, processCmd);
    }

    static short caculateBodyLength(String[] data, byte majorVersion, String idmServerCharset) {
        if (data == null) {
            return 0;
        }
        short result = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("request data has null data! i = " + i));
                }
                data[i] = "";
            }
            try {
                result = (short)(result + data[i].getBytes(PacketUtil.getCharsetName(majorVersion, idmServerCharset)).length);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)("UnsupportedEncoding[" + PacketUtil.getCharsetName(majorVersion, idmServerCharset) + "]"), (Throwable)e);
            }
            result = (short)(result + "\n\r".length());
            ++i;
        }
        return result;
    }

    static short caculateBodyLength(String[] data) {
        boolean PROTOCOL_MAJ_OLD_VER = true;
        return PacketUtil.caculateBodyLength(data, (byte)1, null);
    }

    static byte[] stringArray2PacketBodyBytes(String[] body, short bodyLen, byte majorVersion, String idmServerCharset) {
        if (body == null) {
            LOG.error((Object)"body == null!");
            return null;
        }
        if (bodyLen <= 0) {
            LOG.error((Object)"bodyLen <= 0!");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("packet bodyLen=" + bodyLen + ", body: " + StringHelper.toString(body, true, "; ")));
        }
        return puImpl.stringArray2PacketBodyBytes(body, bodyLen, majorVersion, idmServerCharset);
    }

    static byte[] stringArray2PacketBodyBytes(String[] body, short bodyLen) {
        boolean PROTOCOL_MAJ_OLD_VER = true;
        return PacketUtil.stringArray2PacketBodyBytes(body, bodyLen, (byte)1, null);
    }

    static String[] packetBodyBytes2StringArray(byte[] body, byte majorVersion, String idmServerCharset) {
        try {
            String allData = new String(body, PacketUtil.getCharsetName(majorVersion, idmServerCharset));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get allData=" + allData + " by majorVersion[" + majorVersion + "], charset[" + PacketUtil.getCharsetName(majorVersion, idmServerCharset) + "]"));
            }
            String[] result = SEPARATOR.split(allData);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get result[" + result + "] by allData=" + allData + " by majorVersion[" + majorVersion + "], charset[" + PacketUtil.getCharsetName(majorVersion, idmServerCharset) + "]"));
            }
            return result;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("UnsupportedEncoding: " + PacketUtil.getCharsetName(majorVersion, idmServerCharset)), (Throwable)e);
            LOG.warn((Object)"get packet body stringArray result is null!");
            return null;
        }
    }

    public static boolean isMajorVersion2(byte majorVersion) {
        return 2 == majorVersion;
    }

    public static String getCharsetName(byte majorVersion, String idmServerCharset) {
        if (!StringHelper.isEmpty(idmServerCharset)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get charset[" + idmServerCharset + "] by idmServerCharset[" + idmServerCharset + "], majorVersion[" + majorVersion + "]"));
            }
            return idmServerCharset;
        }
        if (PacketUtil.isMajorVersion2(majorVersion)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get charset[utf-8] by idmServerCharset[" + idmServerCharset + "], majorVersion[" + majorVersion + "]"));
            }
            return "utf-8";
        }
        String PACKET_BODY_CHARSET_OLD = "GBK";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get charset[GBK] by idmServerCharset[" + idmServerCharset + "], majorVersion[" + majorVersion + "]"));
        }
        return "GBK";
    }

    static String[] packetBodyBytes2StringArray(byte[] body) {
        boolean PROTOCOL_MAJ_OLD_VER = true;
        return PacketUtil.packetBodyBytes2StringArray(body, (byte)1, null);
    }

    public static ProtocolPacket parseFromBytes(byte[] data) {
        return puImpl.parseFromBytes(data);
    }
}

