/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.support.CustomSQLErrorCodesTranslation;
import org.springframework.jdbc.support.SQLErrorCodes;
import org.springframework.jdbc.support.SQLErrorCodesFactory;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

public class SQLErrorCodeSQLExceptionTranslator
implements SQLExceptionTranslator {
    private static final int MESSAGE_ONLY_CONSTRUCTOR = 1;
    private static final int MESSAGE_THROWABLE_CONSTRUCTOR = 2;
    private static final int MESSAGE_SQLEX_CONSTRUCTOR = 3;
    private static final int MESSAGE_SQL_THROWABLE_CONSTRUCTOR = 4;
    private static final int MESSAGE_SQL_SQLEX_CONSTRUCTOR = 5;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected SQLErrorCodes sqlErrorCodes;
    private SQLExceptionTranslator fallback = new SQLStateSQLExceptionTranslator();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$sql$SQLException;
    static /* synthetic */ Class class$org$springframework$dao$DataAccessException;

    public SQLErrorCodeSQLExceptionTranslator() {
    }

    public SQLErrorCodeSQLExceptionTranslator(SQLErrorCodes sec) {
        this.sqlErrorCodes = sec;
    }

    public SQLErrorCodeSQLExceptionTranslator(DataSource ds) {
        this.setDataSource(ds);
    }

    public void setSqlErrorCodes(SQLErrorCodes sec) {
        this.sqlErrorCodes = sec;
    }

    public void setDataSource(DataSource ds) {
        this.sqlErrorCodes = SQLErrorCodesFactory.getInstance().getErrorCodes(ds);
    }

    public void setFallbackTranslator(SQLExceptionTranslator fallback) {
        this.fallback = fallback;
    }

    public DataAccessException translate(String task, String sql, SQLException sqlex) {
        DataAccessException dex;
        if (task == null) {
            task = "";
        }
        if (sql == null) {
            sql = "";
        }
        if ((dex = this.customTranslate(task, sql, sqlex)) != null) {
            return dex;
        }
        String errorCode = this.sqlErrorCodes != null && this.sqlErrorCodes.isUseSqlStateForTranslation() ? sqlex.getSQLState() : Integer.toString(sqlex.getErrorCode());
        if (this.sqlErrorCodes != null && errorCode != null) {
            if (!this.sqlErrorCodes.getCustomTranslations().isEmpty()) {
                Iterator customIter = this.sqlErrorCodes.getCustomTranslations().iterator();
                while (customIter.hasNext()) {
                    CustomSQLErrorCodesTranslation customCode = (CustomSQLErrorCodesTranslation)customIter.next();
                    if (Arrays.binarySearch(customCode.getErrorCodes(), errorCode) < 0) continue;
                    Class<?> exceptionClass = null;
                    DataAccessException customException = null;
                    try {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        exceptionClass = cl.loadClass(customCode.getExceptionClass());
                    }
                    catch (ClassNotFoundException ex) {
                        this.logger.warn((Object)("Unable to load custom exception class: " + customCode.getExceptionClass()));
                    }
                    if (exceptionClass == null) continue;
                    try {
                        int constructorType = 0;
                        Constructor<?>[] constructors = exceptionClass.getConstructors();
                        for (int i = 0; i < constructors.length; ++i) {
                            Class<?>[] parameterTypes = constructors[i].getParameterTypes();
                            if (parameterTypes.length == 1 && parameterTypes[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && constructorType < 1) {
                                constructorType = 1;
                            }
                            if (parameterTypes.length == 2 && parameterTypes[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && parameterTypes[1].equals(class$java$lang$Throwable == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.Throwable") : class$java$lang$Throwable) && constructorType < 2) {
                                constructorType = 2;
                            }
                            if (parameterTypes.length == 2 && parameterTypes[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && parameterTypes[1].equals(class$java$sql$SQLException == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.sql.SQLException") : class$java$sql$SQLException) && constructorType < 3) {
                                constructorType = 3;
                            }
                            if (parameterTypes.length == 3 && parameterTypes[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && parameterTypes[1].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && parameterTypes[2].equals(class$java$lang$Throwable == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.Throwable") : class$java$lang$Throwable) && constructorType < 4) {
                                constructorType = 4;
                            }
                            if (parameterTypes.length != 3 || !parameterTypes[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) || !parameterTypes[1].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) || !parameterTypes[2].equals(class$java$sql$SQLException == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.sql.SQLException") : class$java$sql$SQLException) || constructorType >= 5) continue;
                            constructorType = 5;
                        }
                        Constructor<?> exceptionConstructor = null;
                        switch (constructorType) {
                            case 5: {
                                Class[] messageAndSqlAndSqlExArgsClass = new Class[]{class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String, class$java$sql$SQLException == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.sql.SQLException") : class$java$sql$SQLException};
                                Object[] messageAndSqlAndSqlExArgs = new Object[]{task, sql, sqlex};
                                exceptionConstructor = exceptionClass.getConstructor(messageAndSqlAndSqlExArgsClass);
                                customException = (DataAccessException)exceptionConstructor.newInstance(messageAndSqlAndSqlExArgs);
                                break;
                            }
                            case 4: {
                                Class[] messageAndSqlAndThrowableArgsClass = new Class[]{class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String, class$java$lang$Throwable == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.Throwable") : class$java$lang$Throwable};
                                Object[] messageAndSqlAndThrowableArgs = new Object[]{task, sql, sqlex};
                                exceptionConstructor = exceptionClass.getConstructor(messageAndSqlAndThrowableArgsClass);
                                customException = (DataAccessException)exceptionConstructor.newInstance(messageAndSqlAndThrowableArgs);
                                break;
                            }
                            case 3: {
                                Class[] messageAndSqlExArgsClass = new Class[]{class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String, class$java$sql$SQLException == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.sql.SQLException") : class$java$sql$SQLException};
                                Object[] messageAndSqlExArgs = new Object[]{task + ": " + sqlex.getMessage(), sqlex};
                                exceptionConstructor = exceptionClass.getConstructor(messageAndSqlExArgsClass);
                                customException = (DataAccessException)exceptionConstructor.newInstance(messageAndSqlExArgs);
                                break;
                            }
                            case 2: {
                                Class[] messageAndThrowableArgsClass = new Class[]{class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String, class$java$lang$Throwable == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.Throwable") : class$java$lang$Throwable};
                                Object[] messageAndThrowableArgs = new Object[]{task + ": " + sqlex.getMessage(), sqlex};
                                exceptionConstructor = exceptionClass.getConstructor(messageAndThrowableArgsClass);
                                customException = (DataAccessException)exceptionConstructor.newInstance(messageAndThrowableArgs);
                                break;
                            }
                            case 1: {
                                Class[] messageOnlyArgsClass = new Class[]{class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String};
                                Object[] messageOnlyArgs = new Object[]{task + ": " + sqlex.getMessage()};
                                exceptionConstructor = exceptionClass.getConstructor(messageOnlyArgsClass);
                                customException = (DataAccessException)exceptionConstructor.newInstance(messageOnlyArgs);
                                break;
                            }
                            default: {
                                this.logger.warn((Object)("Unable to find necessary constructor for custom exception class [" + customCode.getExceptionClass() + "]"));
                                break;
                            }
                        }
                    }
                    catch (ClassCastException ex) {
                        this.logger.warn((Object)("Unable to instantiate custom exception class [" + customCode.getExceptionClass() + "]. It is not a subclass of [" + (class$org$springframework$dao$DataAccessException == null ? SQLErrorCodeSQLExceptionTranslator.class$("org.springframework.dao.DataAccessException") : class$org$springframework$dao$DataAccessException) + "]."));
                    }
                    catch (Exception ex) {
                        this.logger.warn((Object)("Unable to instantiate custom exception class [" + customCode.getExceptionClass() + "]"), (Throwable)ex);
                    }
                    if (customException == null) continue;
                    this.logTranslation(task, sql, sqlex, true);
                    return customException;
                }
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getBadSqlGrammarCodes(), errorCode) >= 0) {
                this.logTranslation(task, sql, sqlex, false);
                return new BadSqlGrammarException(task, sql, sqlex);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getDataIntegrityViolationCodes(), errorCode) >= 0) {
                this.logTranslation(task, sql, sqlex, false);
                return new DataIntegrityViolationException(task + ": " + sqlex.getMessage(), sqlex);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getDataRetrievalFailureCodes(), errorCode) >= 0) {
                this.logTranslation(task, sql, sqlex, false);
                return new DataRetrievalFailureException(task + ": " + sqlex.getMessage(), sqlex);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getOptimisticLockingFailureCodes(), errorCode) >= 0) {
                this.logTranslation(task, sql, sqlex, false);
                return new OptimisticLockingFailureException(task + ": " + sqlex.getMessage(), sqlex);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getCannotAcquireLockCodes(), errorCode) >= 0) {
                this.logTranslation(task, sql, sqlex, false);
                return new CannotAcquireLockException(task + ": " + sqlex.getMessage(), sqlex);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getDataAccessResourceFailureCodes(), errorCode) >= 0) {
                this.logTranslation(task, sql, sqlex, false);
                return new DataAccessResourceFailureException(task + ": " + sqlex.getMessage(), sqlex);
            }
        }
        this.logger.warn((Object)("Unable to translate SQLException with errorCode '" + sqlex.getErrorCode() + "', will now try the fallback translator"));
        return this.fallback.translate(task, sql, sqlex);
    }

    protected DataAccessException customTranslate(String task, String sql, SQLException sqlex) {
        return null;
    }

    private void logTranslation(String task, String sql, SQLException sqlex, boolean custom) {
        if (this.logger.isInfoEnabled()) {
            String intro = custom ? "Custom translation of" : "Translating";
            this.logger.info((Object)(intro + " SQLException with SQLState '" + sqlex.getSQLState() + "' and errorCode '" + sqlex.getErrorCode() + "' and message [" + sqlex.getMessage() + "]; SQL was [" + sql + "] for task [" + task + "]"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

