/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.providers;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.MessageRouter;
import org.apache.soap.server.RPCRouter;
import org.apache.soap.util.Bean;
import org.apache.soap.util.MethodUtils;
import org.apache.soap.util.Provider;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public class CORBAProvider
implements Provider {
    private static final String DEFAULT_ORB_INITIAL_HOST = "localhost";
    private static final String DEFAULT_ORB_INITIAL_PORT = "900";
    private DeploymentDescriptor dd;
    private Envelope envelope;
    private Call call;
    private String methodName;
    private String targetObjectURI;
    private String interfaceClassName = null;
    private java.lang.Object targetObject = null;
    static /* synthetic */ Class class$org$omg$CORBA$Object;
    static /* synthetic */ Class class$org$apache$soap$Envelope;
    static /* synthetic */ Class class$org$apache$soap$rpc$SOAPContext;

    public void locate(DeploymentDescriptor dd, Envelope env, Call call, String methodName, String targetObjectURI, SOAPContext reqContext) throws SOAPException {
        Object corbaObject;
        String nameId;
        String orbInitialPort;
        Hashtable props;
        String orbInitialHost;
        this.dd = dd;
        this.envelope = env;
        this.call = call;
        this.methodName = methodName;
        this.targetObjectURI = targetObjectURI;
        if (call != null) {
            if (!RPCRouter.validCall(dd, call)) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Method '" + call.getMethodName() + "' is not supported.");
            }
        } else if (!MessageRouter.validMessage(dd, methodName)) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Method '" + methodName + "' is not supported.");
        }
        if ((orbInitialHost = (String)(props = dd.getProps()).get("ORBInitialHost")) == null) {
            orbInitialHost = DEFAULT_ORB_INITIAL_HOST;
        }
        if ((orbInitialPort = (String)props.get("ORBInitialPort")) == null) {
            orbInitialPort = DEFAULT_ORB_INITIAL_PORT;
        }
        if ((nameId = (String)props.get("NameID")) == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "NameID must be specified");
        }
        String nameKind = (String)props.get("NameKind");
        if (nameKind == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "NameKind must be specified");
        }
        this.interfaceClassName = (String)props.get("InterfaceClassName");
        if (this.interfaceClassName == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "InterfaceClassName must be specified");
        }
        String helperClassName = (String)props.get("HelperClassName");
        if (helperClassName == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "HelperClassName must be specified");
        }
        Properties orbProps = new Properties();
        orbProps.put("org.omg.CORBA.ORBInitialHost", orbInitialHost);
        orbProps.put("org.omg.CORBA.ORBInitialPort", orbInitialPort);
        ORB orb = null;
        try {
            orb = ORB.init((String[])new String[0], (Properties)orbProps);
        }
        catch (Exception e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error initializing ORB: " + e, e);
        }
        NamingContext root = null;
        try {
            root = NamingContextHelper.narrow((Object)orb.resolve_initial_references("NameService"));
        }
        catch (Exception e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error getting name service: " + e, e);
        }
        NameComponent nc = new NameComponent(nameId, nameKind);
        NameComponent[] ncs = new NameComponent[]{nc};
        try {
            corbaObject = root.resolve(ncs);
        }
        catch (Exception e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error resolving '" + nameId + "': " + e, e);
        }
        Method narrowMethod = null;
        try {
            Class<?> helperClass = Class.forName(helperClassName);
            narrowMethod = helperClass.getMethod("narrow", class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = CORBAProvider.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object);
        }
        catch (Exception e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error getting helper class '" + helperClassName + "': " + e, e);
        }
        try {
            this.targetObject = narrowMethod.invoke(null, corbaObject);
        }
        catch (Exception e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error using helper class '" + helperClassName + " to narrow': " + e, e);
        }
    }

    public void invoke(SOAPContext reqContext, SOAPContext resContext) throws SOAPException {
        Parameter ret = null;
        java.lang.Object[] args = null;
        Class[] argTypes = null;
        String respEncStyle = null;
        if (this.call != null) {
            Vector methodParameters = this.call.getParams();
            respEncStyle = this.call.getEncodingStyleURI();
            if (methodParameters != null) {
                int parametersCount = methodParameters.size();
                args = new java.lang.Object[parametersCount];
                argTypes = new Class[parametersCount];
                for (int i = 0; i < parametersCount; ++i) {
                    Parameter param = (Parameter)methodParameters.elementAt(i);
                    args[i] = param.getValue();
                    argTypes[i] = param.getType();
                    if (respEncStyle != null) continue;
                    respEncStyle = param.getEncodingStyleURI();
                }
            }
            if (respEncStyle == null) {
                respEncStyle = "http://schemas.xmlsoap.org/soap/encoding/";
            }
        } else {
            argTypes = new Class[]{class$org$apache$soap$Envelope == null ? (class$org$apache$soap$Envelope = CORBAProvider.class$("org.apache.soap.Envelope")) : class$org$apache$soap$Envelope, class$org$apache$soap$rpc$SOAPContext == null ? (class$org$apache$soap$rpc$SOAPContext = CORBAProvider.class$("org.apache.soap.rpc.SOAPContext")) : class$org$apache$soap$rpc$SOAPContext, class$org$apache$soap$rpc$SOAPContext == null ? (class$org$apache$soap$rpc$SOAPContext = CORBAProvider.class$("org.apache.soap.rpc.SOAPContext")) : class$org$apache$soap$rpc$SOAPContext};
            args = new java.lang.Object[]{this.envelope, reqContext, resContext};
        }
        try {
            Method m = MethodUtils.getMethod(this.targetObject, this.methodName, argTypes);
            Bean result = new Bean(m.getReturnType(), m.invoke(this.targetObject, args));
            if (result.type != Void.TYPE) {
                ret = new Parameter(RPCConstants.ELEM_RETURN, result.type, result.value, null);
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw new SOAPException(Constants.FAULT_CODE_SERVER, t.getMessage(), t);
        }
        catch (Throwable t) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, t.getMessage(), t);
        }
        if (this.call != null) {
            try {
                Response resp = new Response(this.targetObjectURI, this.methodName, ret, null, null, respEncStyle, resContext);
                Envelope env = resp.buildEnvelope();
                StringWriter sw = new StringWriter();
                env.marshall(sw, this.call.getSOAPMappingRegistry(), resContext);
                resContext.setRootPart(sw.toString(), "text/xml;charset=utf-8");
            }
            catch (Exception e) {
                if (e instanceof SOAPException) {
                    throw (SOAPException)e;
                }
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error creating response: " + e, e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

